switch(global.quest){
    case 0:
        if(global.mixed){ow_map_img = 2 + (4 * global.mirrored);}
        else{ow_map_img = 0 + (4 * global.mirrored);}
    break;
    case 1:
        if(global.mixed){ow_map_img = 3 + (4 * global.mirrored);}
        else{ow_map_img = 1 + (4 * global.mirrored);}
    break;
}

if(global.curr_map == 0){
    if(global.show_indicators){
        for(i = 0; i < 8; i += 1){
            if(global.ow_map_transparency == 2){
                draw_sprite_part_ext(s_map_overworld, ow_map_img, 0, i * 11, 256, 11, 0, 53 + (i * 16), 1, 1, c_white, 0.4);
            }
            else{
                draw_sprite_part_ext(s_map_overworld, ow_map_img, 0, i * 11, 256, 11, 0, 53 + (i * 16), 1, 1, c_white, 1);
            }
            if(global.track_auto && surface_exists(global.srf_owmap)){
                if(global.ow_map_transparency == 1){
                    draw_surface_part_ext(global.srf_owmap, 0, i * 11, 256, 11, 0, 53 + (i * 16), 1, 1, c_white, 0.25);
                }
                else{
                    draw_surface_part_ext(global.srf_owmap, 0, i * 11, 256, 11, 0, 53 + (i * 16), 1, 1, c_white, 1);
                }
            }
        }
        draw_sprite(s_map_overworld_grid, 0, 0, 48);
    }
    else{
        if(global.ow_map_transparency == 2){
            draw_sprite_ext(s_map_overworld, ow_map_img, 0, 48, 1, 1, 0, c_white, 0.4);
        }
        else
        {
            draw_sprite_ext(s_map_overworld, ow_map_img, 0, 48, 1, 1, 0, c_white, 1);
        }
        if(global.track_auto && surface_exists(global.srf_owmap)){
            if(global.ow_map_transparency == 1){
                draw_surface_ext(global.srf_owmap, 0, 48, 1, 1, 0, c_white, 0.25);
            }
            else{
                draw_surface_ext(global.srf_owmap, 0, 48, 1, 1, 0, c_white, 1);
            }
        }
        draw_sprite(s_map_overworld_grid_nocoord, 0, 0, 48);
    }
    
    var val;
    for(i = 0; i < 128; i += 1){
        //val = ds_grid_get(global.inst_ctrl_tracker.grd_ow_icons, 0, (i mod 16) + (16 * (i div 16))); //wtf was i thinking here? mess == i
        val = ds_grid_get(global.inst_ctrl_tracker.grd_ow_icons, 0, i);
        if(val > 0){
            if(global.show_indicators){
                if(global.ow_transparency){
                    draw_sprite_ext(s_icon_overworld, val, 16 * (i mod 16), y + 5 + (16 * (i div 16)), 1, 1, 0, c_white, 0.9 - (0.4 * global.ow_transparency));
                }
                else{
                    draw_sprite(s_icon_overworld, val, 16 * (i mod 16), y + 5 + (16 * (i div 16)));
                }
            }
            else{
                if(global.ow_transparency){
                    draw_sprite_ext(s_icon_overworld, val, 16 * (i mod 16), y + (11 * (i div 16)), 1, 1, 0, c_white, 0.9 - (0.4 * global.ow_transparency));
                }
                else{
                    draw_sprite(s_icon_overworld, val, 16 * (i mod 16), y + (11 * (i div 16)));
                }
            }
        }
    }

    //draw location bar text
    draw_set_font(global.fnt_mwtiny);
    draw_set_halign(fa_left);
    draw_set_color(c_white);
    if(loc_x >= 0 && loc_x < 16 && loc_y >= 0 && loc_y < 8){
        draw_text(0, 41, string_hash_to_newline("OW(" + zh_get_hex_char(loc_screen) + "): " + zh_get_location_desc(loc_screen)));
    }
    else{ //if you see this with a screen number listed, GM is messing up badly
        draw_text(0, 41, string_hash_to_newline("I AM ERROR."));
    }

    if(global.show_indicators){
        //draw tint overlay
        switch(global.quest){
            case 0:
                if(global.mixed){draw_sprite_ext(s_overlay_overworld_tint, 2 + (4 * global.mirrored), 0, 48, 1, 1, 0, c_white, 0.33);}
                else{draw_sprite_ext(s_overlay_overworld_tint, 0 + (4 * global.mirrored), 0, 48, 1, 1, 0, c_white, 0.33);}
            break;
            case 1:
                if(global.mixed){draw_sprite_ext(s_overlay_overworld_tint, 3 + (4 * global.mirrored), 0, 48, 1, 1, 0, c_white, 0.33);}
                else{draw_sprite_ext(s_overlay_overworld_tint, 1 + (4 * global.mirrored), 0, 48, 1, 1, 0, c_white, 0.33);}
            break;
        }
    
        //draw mix overlay
        switch(global.quest){
            case 0:
                if(global.mixed){draw_sprite_ext(s_overlay_overworld_mix, 0 + (2 * global.mirrored), 0, 48, 1, 1, 0, c_white, mix_alpha);}
            break;
            case 1:
                if(global.mixed){draw_sprite_ext(s_overlay_overworld_mix, 1 + (2 * global.mirrored), 0, 48, 1, 1, 0, c_white, mix_alpha);}
            break;
        }
    
        //draw areas overlay
        if(global.show_areas){
            draw_sprite_ext(s_overlay_overworld_areas, 0 + (1 * global.mirrored), 0, 48, 1, 1, 0, c_white, 0.66);
        }
    }
    else{
        //draw tint overlay
        switch(global.quest){
            case 0:
                if(global.mixed){draw_sprite_ext(s_overlay_overworld_tint_nocoord, 2 + (4 * global.mirrored), 0, 48, 1, 1, 0, c_white, 0.33);}
                else{draw_sprite_ext(s_overlay_overworld_tint_nocoord, 0 + (4 * global.mirrored), 0, 48, 1, 1, 0, c_white, 0.33);}
            break;
            case 1:
                if(global.mixed){draw_sprite_ext(s_overlay_overworld_tint_nocoord, 3 + (4 * global.mirrored), 0, 48, 1, 1, 0, c_white, 0.33);}
                else{draw_sprite_ext(s_overlay_overworld_tint_nocoord, 1 + (4 * global.mirrored), 0, 48, 1, 1, 0, c_white, 0.33);}
            break;
        }
    
        //draw mix overlay
        switch(global.quest){
            case 0:
                if(global.mixed){draw_sprite_ext(s_overlay_overworld_mix_nocoord, 0 + (2 * global.mirrored), 0, 48, 1, 1, 0, c_white, mix_alpha);}
            break;
            case 1:
                if(global.mixed){draw_sprite_ext(s_overlay_overworld_mix_nocoord, 1 + (2 * global.mirrored), 0, 48, 1, 1, 0, c_white, mix_alpha);}
            break;
        }
    
        //draw areas overlay
        if(global.show_areas){
            draw_sprite_ext(s_overlay_overworld_areas_nocoord, 0 + (1 * global.mirrored), 0, 48, 1, 1, 0, c_white, 0.66);
        }
    }
    
    //draw overworld coordinates
    var col;
    if(global.show_indicators){
        //draw large indicators and coordinate text
        draw_set_color(global.playercolor);
        for(i = 0; i < 128; i += 1){
            if(global.net_playerid != -1){
                if(ds_grid_get(global.inst_ctrl_tracker.grd_ow_icons_marker, 0, (global.net_playerid * 128) + i) == 1){
                    draw_sprite_ext(s_ind_player, 0, 8 + (16 * (i mod 16)), 3 + (y + (16 * (i div 16))), 1, 1, 0, global.playercolor, !global.ow_coord_style);
                    if(global.ow_coord_style == 0){
                        draw_text((i mod 16) * 16, 48 + ((i div 16) * 16), string_hash_to_newline(zh_get_hex_char(i)));
                    }
                    else{
                        draw_text((i mod 16) * 16, 48 + ((i div 16) * 16), string_hash_to_newline(zh_get_coord_char(i)));
                    }
                }
            }
            else{
                if(ds_grid_get(global.inst_ctrl_tracker.grd_ow_icons_marker, 0, i) == 1){
                    draw_sprite_ext(s_ind_player, 0, 8 + (16 * (i mod 16)), 3 + (y + (16 * (i div 16))), 1, 1, 0, global.playercolor, !global.ow_coord_style);
                    if(global.ow_coord_style == 0){
                        draw_text((i mod 16) * 16, 48 + ((i div 16) * 16), string_hash_to_newline(zh_get_hex_char(i)));
                    }
                    else{
                        draw_text((i mod 16) * 16, 48 + ((i div 16) * 16), string_hash_to_newline(zh_get_coord_char(i)));
                    }
                }
            }
        }
        draw_set_color(c_gray);
        for(i = 0; i < 128; i += 1){
            if(global.net_playerid != -1){
                if(ds_grid_get(global.inst_ctrl_tracker.grd_ow_icons_marker, 0, (global.net_playerid * 128) + i) == 0){
                    if(global.ow_coord_style == 0){
                        draw_text((i mod 16) * 16, 48 + ((i div 16) * 16), string_hash_to_newline(zh_get_hex_char(i)));
                    }
                    else{
                        draw_text((i mod 16) * 16, 48 + ((i div 16) * 16), string_hash_to_newline(zh_get_coord_char(i)));
                    }
                }
            }
            else{
                if(ds_grid_get(global.inst_ctrl_tracker.grd_ow_icons_marker, 0, i) == 0){
                    if(global.ow_coord_style == 0){
                        draw_text((i mod 16) * 16, 48 + ((i div 16) * 16), string_hash_to_newline(zh_get_hex_char(i)));
                    }
                    else{
                        draw_text((i mod 16) * 16, 48 + ((i div 16) * 16), string_hash_to_newline(zh_get_coord_char(i)));
                    }
                }
            }
        }
        
        //draw other players' indicators
        if(global.ow_coord_style == 0){
            for(j = 0; j < 8; j++){
                col = make_color_hsv(color_get_hue(global.playercolors[j]), color_get_saturation(global.playercolors[j]), color_get_value(global.playercolors[j]) * 0.75);
                for(k = 0; k < 128; k += 1){
                    if(ds_grid_get(global.inst_ctrl_tracker.grd_ow_icons_marker, 0, k + (128 * j)) == 1){
                        draw_sprite_ext(s_ind_player_other, 0, 8 + j + (16 * (k mod 16)),y + (16 * (k div 16)), 1, 1, 0, col, 1);
                    }
                }
            }
        }
    }
    
    //draw start screen overlay
    if(ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, 0) != -1){
        if(global.show_indicators){
            draw_sprite(s_outline_startscreen, 0, 16 * (ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, 0) mod 16), y + 5 + (16 * (ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, 0) div 16)));
        }
        else{
            draw_sprite(s_outline_startscreen, 0, 16 * (ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, 0) mod 16), y + (11 * (ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, 0) div 16)));
        }
    }

    //draw player location indicators if auto-tracking is enabled
    if(global.show_indicators){
        if(global.net_active){
            for(i = 0; i < 8; i++){
                if(i != global.net_playerid && global.playerowpos[i] < 128){
                    if(global.playermaptype[i] == 1){
                        draw_sprite_ext(s_outline_tr_playerloc_outer, 0, ((global.playerowpos[i] mod 16) * 16) - 5, 48 + ((global.playerowpos[i] div 16) * 16), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolors[i]), color_get_saturation(global.playercolors[i]), 255), 0.66 - (abs(sin(anim_cycle)) * 0.65));
                        draw_sprite_ext(s_outline_tr_playerloc, 0, ((global.playerowpos[i] mod 16) * 16), 53 + ((global.playerowpos[i] div 16) * 16), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolors[i]), color_get_saturation(global.playercolors[i]), 255 - (abs(sin(anim_cycle)) * 80)), 1.0);
                    }
                    else if(global.playermaptype[i] == 2){
                        draw_sprite_ext(s_outline_tr_playerloc_outer, 0, ((global.playerowpos[i] mod 16) * 16) - 5, 48 + ((global.playerowpos[i] div 16) * 16), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolors[i]), color_get_saturation(global.playercolors[i]), 255), 0.66 - (abs(sin(anim_cycle)) * 0.65));
                        draw_sprite_ext(s_outline_tr_playerloc, 1, ((global.playerowpos[i] mod 16) * 16), 53 + ((global.playerowpos[i] div 16) * 16), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolors[i]), color_get_saturation(global.playercolors[i]), 255 - (abs(sin(anim_cycle)) * 80)), 1.0);
                    }
                }
            }
            if(global.net_playerid != -1 && global.playerowpos[global.net_playerid] < 128){
                if(global.playermaptype[global.net_playerid] == 1){
                    draw_sprite_ext(s_outline_tr_playerloc_outer, 1, ((global.playerowpos[global.net_playerid] mod 16) * 16) - 5, 48 + ((global.playerowpos[global.net_playerid] div 16) * 16), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255), 0.66 - (abs(sin(anim_cycle)) * 0.65));
                    draw_sprite_ext(s_outline_tr_playerloc, 0, ((global.playerowpos[global.net_playerid] mod 16) * 16), 53 + ((global.playerowpos[global.net_playerid] div 16) * 16), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255 - (abs(sin(anim_cycle)) * 80)), 1.0);
                }
                else if(global.playermaptype[global.net_playerid] == 2){
                    draw_sprite_ext(s_outline_tr_playerloc_outer, 1, ((global.playerowpos[global.net_playerid] mod 16) * 16) - 5, 48 + ((global.playerowpos[global.net_playerid] div 16) * 16), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255), 0.66 - (abs(sin(anim_cycle)) * 0.65));
                    draw_sprite_ext(s_outline_tr_playerloc, 1, ((global.playerowpos[global.net_playerid] mod 16) * 16), 53 + ((global.playerowpos[global.net_playerid] div 16) * 16), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255 - (abs(sin(anim_cycle)) * 80)), 1.0);
                }
            }
        }
        else{
            if(global.playermaptype[0] == 1){
                draw_sprite_ext(s_outline_tr_playerloc_outer, 1, ((global.playerowpos[0] mod 16) * 16) - 5, 48 + ((global.playerowpos[0] div 16) * 16), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255), 0.66 - (abs(sin(anim_cycle)) * 0.65));
                draw_sprite_ext(s_outline_tr_playerloc, 0, ((global.playerowpos[0] mod 16) * 16), 53 + ((global.playerowpos[0] div 16) * 16), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255 - (abs(sin(anim_cycle)) * 80)), 1.0);
            }
            else if(global.playermaptype[0] == 2){
                draw_sprite_ext(s_outline_tr_playerloc_outer, 1, ((global.playerowpos[0] mod 16) * 16) - 5, 48 + ((global.playerowpos[0] div 16) * 16), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255), 0.66 - (abs(sin(anim_cycle)) * 0.65));
                draw_sprite_ext(s_outline_tr_playerloc, 1, ((global.playerowpos[0] mod 16) * 16), 53 + ((global.playerowpos[0] div 16) * 16), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255 - (abs(sin(anim_cycle)) * 80)), 1.0);
            }
        }
    }
    else{
        if(global.net_active){
            for(i = 0; i < 8; i++){
                if(i != global.net_playerid && global.playerowpos[i] < 128){
                    if(global.playermaptype[i] == 1){
                        draw_sprite_ext(s_outline_tr_playerloc_outer, 0, ((global.playerowpos[i] mod 16) * 16) - 5, 43 + ((global.playerowpos[i] div 16) * 11), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolors[i]), color_get_saturation(global.playercolors[i]), 255), 0.66 - (abs(sin(anim_cycle)) * 0.65));
                        draw_sprite_ext(s_outline_tr_playerloc, 0, ((global.playerowpos[i] mod 16) * 16), 48 + ((global.playerowpos[i] div 16) * 11), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolors[i]), color_get_saturation(global.playercolors[i]), 255 - (abs(sin(anim_cycle)) * 80)), 1.0);
                    }
                    else if(global.playermaptype[i] == 2){
                        draw_sprite_ext(s_outline_tr_playerloc_outer, 0, ((global.playerowpos[i] mod 16) * 16) - 5, 43 + ((global.playerowpos[i] div 16) * 11), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolors[i]), color_get_saturation(global.playercolors[i]), 255), 0.66 - (abs(sin(anim_cycle)) * 0.65));
                        draw_sprite_ext(s_outline_tr_playerloc, 1, ((global.playerowpos[i] mod 16) * 16), 48 + ((global.playerowpos[i] div 16) * 11), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolors[i]), color_get_saturation(global.playercolors[i]), 255 - (abs(sin(anim_cycle)) * 80)), 1.0);
                    }
                }
            }
            if(global.net_playerid != -1 && global.playerowpos[global.net_playerid] < 128){
                if(global.playermaptype[global.net_playerid] == 1){
                    draw_sprite_ext(s_outline_tr_playerloc_outer, 1, ((global.playerowpos[global.net_playerid] mod 16) * 16) - 5, 43 + ((global.playerowpos[global.net_playerid] div 16) * 11), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255), 0.66 - (abs(sin(anim_cycle)) * 0.65));
                    draw_sprite_ext(s_outline_tr_playerloc, 0, ((global.playerowpos[global.net_playerid] mod 16) * 16), 48 + ((global.playerowpos[global.net_playerid] div 16) * 11), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255 - (abs(sin(anim_cycle)) * 80)), 1.0);
                }
                else if(global.playermaptype[global.net_playerid] == 2){
                    draw_sprite_ext(s_outline_tr_playerloc_outer, 1, ((global.playerowpos[global.net_playerid] mod 16) * 16) - 5, 43 + ((global.playerowpos[global.net_playerid] div 16) * 11), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255), 0.66 - (abs(sin(anim_cycle)) * 0.65));
                    draw_sprite_ext(s_outline_tr_playerloc, 1, ((global.playerowpos[global.net_playerid] mod 16) * 16), 48 + ((global.playerowpos[global.net_playerid] div 16) * 11), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255 - (abs(sin(anim_cycle)) * 80)), 1.0);
                }
            }
        }
        else{
            if(global.playermaptype[0] == 1){
                draw_sprite_ext(s_outline_tr_playerloc_outer, 1, ((global.playerowpos[0] mod 16) * 16) - 5, 43 + ((global.playerowpos[0] div 16) * 11), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255), 0.66 - (abs(sin(anim_cycle)) * 0.65));
                draw_sprite_ext(s_outline_tr_playerloc, 0, ((global.playerowpos[0] mod 16) * 16), 48 + ((global.playerowpos[0] div 16) * 11), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255 - (abs(sin(anim_cycle)) * 80)), 1.0);
            }
            else if(global.playermaptype[0] == 2){
                draw_sprite_ext(s_outline_tr_playerloc_outer, 1, ((global.playerowpos[0] mod 16) * 16) - 5, 43 + ((global.playerowpos[0] div 16) * 11), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255), 0.66 - (abs(sin(anim_cycle)) * 0.65));
                draw_sprite_ext(s_outline_tr_playerloc, 1, ((global.playerowpos[0] mod 16) * 16), 48 + ((global.playerowpos[0] div 16) * 11), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255 - (abs(sin(anim_cycle)) * 80)), 1.0);
            }
        }
    }
    
    //draw outline under cursor if enabled
    if(global.show_outline && loc_x >= 0 && loc_x < 16 && loc_y >= 0 && loc_y < 8){
        draw_set_color(c_white);
        if(global.show_indicators){
            draw_rectangle(16 * loc_x, y + 5 + (16 * loc_y), (16 * loc_x) + 15, (y + 5 + (16 * loc_y)) + 10, 1);
        }
        else{
            draw_rectangle(16 * loc_x, y + (11 * loc_y), (16 * loc_x) + 15, (y + (11 * loc_y)) + 10, 1);
        }
    }
}

//increment animation counter and set new alpha value
anim_cycle += pi / 60;
if(anim_cycle > pi * 2){
  anim_cycle = 0;
}
mix_alpha = abs(sin(anim_cycle)) * 0.9;

