if(global.curr_map > 9 && global.curr_map < 14){
    if(global.show_indicators){
        for(i = 0; i < 8; i += 1){
            draw_sprite_part(s_map_dgn_classic, global.curr_map - 10, 0, i * 11, 256, 11, 0, 53 + (i * 16));
        }
        draw_sprite(s_map_overworld_grid, 0, 0, 48);
    }
    else{
        draw_sprite(s_map_dgn_classic, global.curr_map - 10, 0, 48);
        draw_sprite(s_map_overworld_grid_nocoord, 0, 0, 48);
    }

    var val;
    for(i = 0; i < 128; i += 1){
        val = ds_grid_get(global.inst_ctrl_tracker.grd_dgn_classic_icons, 0, (128 * (global.curr_map - 10)) + ((i mod 16) + (16 * (i div 16))));
        if(val > 0){
            if(global.show_indicators){
                draw_sprite(s_icon_dungeon, val, 2 + (16 * (i mod 16)), y + 7 + (16 * (i div 16)));
            }
            else{
                draw_sprite(s_icon_dungeon, val, 2 + (16 * (i mod 16)), y + 2 + (11 * (i div 16)));
            }
        }
    }

    //draw location bar text
    draw_set_font(global.fnt_mwtiny);
    draw_set_halign(fa_left);
    draw_set_color(c_white);
    if(loc_x >= 0 && loc_x < 16 && loc_y >= 0 && loc_y < 8){
        draw_text(0, 41, string_hash_to_newline("DGN"+ string(global.curr_map - 10) + "(" + zh_get_hex_char(loc_screen) + "): " + zh_get_location_desc_classic((128 * (global.curr_map - 10)) + loc_screen)));
    }
    else{ //if you see this with a screen number listed, GM is messing up badly
        draw_text(0, 41, string_hash_to_newline("I AM ERROR."));
    }

    //draw dungeon coordinates
    var col;
    if(global.show_indicators){
        //draw large indicators and coordinate text
        draw_set_color(global.playercolor);
        for(i = 0; i < 128; i += 1){
            if(global.net_playerid != -1){
                if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_classic_icons_marker, 0, (1024 * (global.curr_map - 10)) + (128 * global.net_playerid) + i) == 1){
                    draw_sprite_ext(s_ind_player, 0, 8 + (16 * (i mod 16)), 3 + (y + (16 * (i div 16))), 1, 1, 0, global.playercolor, 1);
                    draw_text((i mod 16) * 16, 48 + ((i div 16) * 16), string_hash_to_newline(zh_get_hex_char(i)));
                }
            }
            else{
                if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_classic_icons_marker, 0, (1024 * (global.curr_map - 10)) + i) == 1){
                    draw_sprite_ext(s_ind_player, 0, 8 + (16 * (i mod 16)), 3 + (y + (16 * (i div 16))), 1, 1, 0, global.playercolor, 1);
                    draw_text((i mod 16) * 16, 48 + ((i div 16) * 16), string_hash_to_newline(zh_get_hex_char(i)));
                }
                
            }
        }
        draw_set_color(c_gray);
        for(i = 0; i < 128; i += 1){
            if(global.net_playerid != -1){
                if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_classic_icons_marker, 0, (1024 * (global.curr_map - 10)) + (128 * global.net_playerid) + i) == 0){
                    draw_text((i mod 16) * 16, 48 + ((i div 16) * 16), string_hash_to_newline(zh_get_hex_char(i)));
                }
            }
            else{
                if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_classic_icons_marker, 0, (1024 * (global.curr_map - 10)) + i) == 0){
                    draw_text((i mod 16) * 16, 48 + ((i div 16) * 16), string_hash_to_newline(zh_get_hex_char(i)));
                }
            }
        }
        
        //draw other players' indicators
        for(j = 0; j < 8; j++){
            col = make_color_hsv(color_get_hue(global.playercolors[j]), color_get_saturation(global.playercolors[j]), color_get_value(global.playercolors[j]) * 0.75);
            for(k = 0; k < 128; k += 1){
                if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_classic_icons_marker, 0, (1024 * (global.curr_map - 10)) + (k + (128 * j))) == 1){
                    draw_sprite_ext(s_ind_player_other, 0, 8 + j + (16 * (k mod 16)),y + (16 * (k div 16)), 1, 1, 0, col, 1);
                }
            }
        }
    }
    
    //draw outline under cursor if enabled
    if(global.show_outline && loc_x >= 0 && loc_x < 16 && loc_y >= 0 && loc_y < 8){
        draw_set_color(c_white);
        if(global.show_indicators){
            draw_rectangle(16 * loc_x, y + 5 + (16 * loc_y), (16 * loc_x) + 15, (y + 5 + (16 * loc_y)) + 10, 1);
        }
        else{
            draw_rectangle(16 * loc_x, y + (11 * loc_y), (16 * loc_x) + 15, (y + (11 * loc_y)) + 10, 1);
        }
    }
}

