//do it the hard way since GM crashes due to building up big buffers on the client
switch(curr_section){
    case 0:
        //dungeon icons
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 8);
        buffer_write(buf_server, buffer_s8, -1);
        for(i = 0; i < 576; i += 1){
            buffer_write(buf_server, buffer_u8, ds_grid_get(global.inst_ctrl_server.grd_dgn_icons, 0, i));
        }
        for(i = 0; i < 8; i += 1){
            if(global.inst_ctrl_server.server_playerconnected[i] && global.inst_ctrl_server.server_playersocket[i] != -1){
                network_send_raw(global.inst_ctrl_server.server_playersocket[i], buf_server, 578);
            }
        }
    break;
    case 1:
        //dungeon markers
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 9);
        buffer_write(buf_server, buffer_s8, -1);
        buffer_write(buf_server, buffer_u8, map_num);
        for(i = 0; i < 512; i += 1){
            buffer_write(buf_server, buffer_bool, ds_grid_get(global.inst_ctrl_server.grd_dgn_icons_marker, 0, (map_num * 512) + i));
        }
        for(i = 0; i < 8; i += 1){
            if(global.inst_ctrl_server.server_playerconnected[i] && global.inst_ctrl_server.server_playersocket[i] != -1){
                network_send_raw(global.inst_ctrl_server.server_playersocket[i], buf_server, 515);
            }
        }
    break;
    case 2:
        //classic dungeon icons
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 11);
        buffer_write(buf_server, buffer_s8, -1);
        for(j = 0; j < 512; j += 1){
            buffer_write(buf_server, buffer_u8, ds_grid_get(global.inst_ctrl_server.grd_dgn_classic_icons, 0, i));
        }
        for(i = 0; i < 8; i += 1){
            if(global.inst_ctrl_server.server_playerconnected[i] && global.inst_ctrl_server.server_playersocket[i] != -1){
                network_send_raw(global.inst_ctrl_server.server_playersocket[i], buf_server, 514);
            }
        }
    break;
    case 3:
        //classic dungeon markers
        temp = 0;
        if(dgn_num < 6){ //1st 1-6
            temp = 0;
        }
        else if(dgn_num >= 6 && dgn_num < 9){ //1st 7-9
            temp = 1;
        }
        else if(dgn_num >= 9 && dgn_num < 15){ //2nd 1-6
            temp = 2;
        }
        else if(dgn_num >= 15 && dgn_num < 18){ //2nd 7-9
            temp = 3;
        }
        else{
            zh_server_msg("Invalid dungeon number for classic marker sync: " + string(dgn_num));
        }
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 12);
        buffer_write(buf_server, buffer_s8, -1);
        buffer_write(buf_server, buffer_u8, temp);
        for(i = 0; i < 1024; i += 1){
            buffer_write(buf_server, buffer_bool, ds_grid_get(global.inst_ctrl_server.grd_dgn_classic_icons_marker, 0, (temp * 1024) + i));
        }
        for(i = 0; i < 8; i += 1){
            if(global.inst_ctrl_server.server_playerconnected[i] && global.inst_ctrl_server.server_playersocket[i] != -1){
                network_send_raw(global.inst_ctrl_server.server_playersocket[i], buf_server, 1027);
            }
        }
    break;
    default:
        zh_server_msg("Tried to send nonexistent dungeon sync section " + string(curr_section) + " to P" + string(player_id) + ".");
}
curr_section += 1;
if(curr_section > 3){
    zh_server_msg("Sync of dungeon " + string(dgn_num) + " complete!");
    instance_destroy();
}
else{
    alarm[0] = global.server_stream_delay;
}

