//do it the hard way since GM crashes due to building up big buffers on the client
switch(curr_section){
    case 0:
        buffer_seek(buf_server, buffer_seek_start, 0); //player data
        buffer_write(buf_server, buffer_u8, 4);
        buffer_write(buf_server, buffer_s8, -1);
        for(i = 0; i < 8; i += 1){
            buffer_write(buf_server, buffer_u32, global.inst_ctrl_server.server_playercolor[i]); //player color
            buffer_write(buf_server, buffer_u8, string_length(global.inst_ctrl_server.server_playername[i])); //player name len
            buffer_write(buf_server, buffer_string, global.inst_ctrl_server.server_playername[i]); //player name
            for(j = 0; j < 16 - string_length(global.inst_ctrl_server.server_playername[i]); j += 1){
                buffer_write(buf_server, buffer_u8, 0);
            }
        }
        network_send_raw(client_socket, buf_server, 178);
    break;
    case 1:
        buffer_seek(buf_server, buffer_seek_start, 0); //start markers, itemboxes, dungeon nums/colors
        buffer_write(buf_server, buffer_u8, 5);
        buffer_write(buf_server, buffer_s8, -1);
        for(i = 0; i < 10; i += 1){ //starting screens
            buffer_write(buf_server, buffer_u8, ds_grid_get(global.inst_ctrl_server.grd_starts, 0, i));
        }
        
        for(i = 0; i < 24; i += 1){ //item boxes
            buffer_write(buf_server, buffer_u8, ds_grid_get(global.inst_ctrl_server.grd_items, 0, i));
        }
        
        for(i = 0; i < 9; i += 1){ //dungeon numbers
            buffer_write(buf_server, buffer_s8, ds_grid_get(global.inst_ctrl_server.grd_dgn_nums, 0, i));
        }
        
        for(i = 0; i < 9; i += 1){ //dungeon colors
            buffer_write(buf_server, buffer_u32, ds_grid_get(global.inst_ctrl_server.grd_dgn_colors, 0, i));
        }
        for(i = 0; i < 9; i += 1){ //dungeon location hints
            buffer_write(buf_server, buffer_u8, ds_grid_get(global.inst_ctrl_server.grd_hint_dgnloc, 0, i));
        }
        network_send_raw(client_socket, buf_server, 90);
    break;
    case 2:
        buffer_seek(buf_server, buffer_seek_start, 0); //overworld icons
        buffer_write(buf_server, buffer_u8, 6);
        buffer_write(buf_server, buffer_s8, -1);
        for(i = 0; i < 128; i += 1){
            buffer_write(buf_server, buffer_u8, ds_grid_get(global.inst_ctrl_server.grd_ow_icons, 0, i));
        }
        network_send_raw(client_socket, buf_server, 130);
    break;
    case 3:
        //overworld markers
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 7);
        buffer_write(buf_server, buffer_s8, -1);
        for(i = 0; i < 1024; i += 1){
            buffer_write(buf_server, buffer_bool, ds_grid_get(global.inst_ctrl_server.grd_ow_icons_marker, 0, i));
        }
        network_send_raw(client_socket, buf_server, 1026);
    break;
    case 4:
        //dungeon icons
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 8);
        buffer_write(buf_server, buffer_s8, -1);
        for(j = 0; j < 576; j += 1){
            buffer_write(buf_server, buffer_u8, ds_grid_get(global.inst_ctrl_server.grd_dgn_icons, 0, j));
        }
        network_send_raw(client_socket, buf_server, 578);
    break;
    case 5:
        //dungeon markers
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 9);
        buffer_write(buf_server, buffer_s8, -1);
        buffer_write(buf_server, buffer_u8, 0);
        for(k = 0; k < 512; k += 1){
            buffer_write(buf_server, buffer_bool, ds_grid_get(global.inst_ctrl_server.grd_dgn_icons_marker, 0, k));
        }
        network_send_raw(client_socket, buf_server, 515);
    break;
    case 6:
        //dungeon markers
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 9);
        buffer_write(buf_server, buffer_s8, -1);
        buffer_write(buf_server, buffer_u8, 1);
        for(k = 0; k < 512; k += 1){
            buffer_write(buf_server, buffer_bool, ds_grid_get(global.inst_ctrl_server.grd_dgn_icons_marker, 0, 512 + k));
        }
        network_send_raw(client_socket, buf_server, 515);
    break;
    case 7:
        //dungeon markers
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 9);
        buffer_write(buf_server, buffer_s8, -1);
        buffer_write(buf_server, buffer_u8, 2);
        for(k = 0; k < 512; k += 1){
            buffer_write(buf_server, buffer_bool, ds_grid_get(global.inst_ctrl_server.grd_dgn_icons_marker, 0, 1024 + k));
        }
        network_send_raw(client_socket, buf_server, 515);
    break;
    case 8:
        //dungeon markers
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 9);
        buffer_write(buf_server, buffer_s8, -1);
        buffer_write(buf_server, buffer_u8, 3);
        for(k = 0; k < 512; k += 1){
            buffer_write(buf_server, buffer_bool, ds_grid_get(global.inst_ctrl_server.grd_dgn_icons_marker, 0, 1536 + k));
        }
        network_send_raw(client_socket, buf_server, 515);
    break;
    case 9:
        //dungeon markers
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 9);
        buffer_write(buf_server, buffer_s8, -1);
        buffer_write(buf_server, buffer_u8, 4);
        for(k = 0; k < 512; k += 1){
            buffer_write(buf_server, buffer_bool, ds_grid_get(global.inst_ctrl_server.grd_dgn_icons_marker, 0, 2048 + k));
        }
        network_send_raw(client_socket, buf_server, 515);
    break;
    case 10:
        //dungeon markers
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 9);
        buffer_write(buf_server, buffer_s8, -1);
        buffer_write(buf_server, buffer_u8, 5);
        for(k = 0; k < 512; k += 1){
            buffer_write(buf_server, buffer_bool, ds_grid_get(global.inst_ctrl_server.grd_dgn_icons_marker, 0, 2560 + k));
        }
        network_send_raw(client_socket, buf_server, 515);
    break;
    case 11:
        //dungeon markers
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 9);
        buffer_write(buf_server, buffer_s8, -1);
        buffer_write(buf_server, buffer_u8, 6);
        for(k = 0; k < 512; k += 1){
            buffer_write(buf_server, buffer_bool, ds_grid_get(global.inst_ctrl_server.grd_dgn_icons_marker, 0, 3072 + k));
        }
        network_send_raw(client_socket, buf_server, 515);
    break;
    case 12:
        //dungeon markers
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 9);
        buffer_write(buf_server, buffer_s8, -1);
        buffer_write(buf_server, buffer_u8, 7);
        for(k = 0; k < 512; k += 1){
            buffer_write(buf_server, buffer_bool, ds_grid_get(global.inst_ctrl_server.grd_dgn_icons_marker, 0, 3584 + k));
        }
        network_send_raw(client_socket, buf_server, 515);
    break;
    case 13:
        //dungeon markers
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 9);
        buffer_write(buf_server, buffer_s8, -1);
        buffer_write(buf_server, buffer_u8, 8);
        for(k = 0; k < 512; k += 1){
            buffer_write(buf_server, buffer_bool, ds_grid_get(global.inst_ctrl_server.grd_dgn_icons_marker, 0, 4096 + k));
        }
        network_send_raw(client_socket, buf_server, 515);
    break;
    case 14:
        //dungeon doors
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 10);
        buffer_write(buf_server, buffer_s8, -1);
        for(i = 0; i < 504; i += 1){
            buffer_write(buf_server, buffer_u8, ds_grid_get(global.inst_ctrl_server.grd_dgn_doors_h, 0, i));
        }
        for(i = 0; i < 504; i += 1){
            buffer_write(buf_server, buffer_u8, ds_grid_get(global.inst_ctrl_server.grd_dgn_doors_v, 0, i));
        }
        network_send_raw(client_socket, buf_server, 1010);
    break;
    case 15:
        //classic dungeon icons
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 11);
        buffer_write(buf_server, buffer_s8, -1);
        for(i = 0; i < 512; i += 1){
            buffer_write(buf_server, buffer_u8, ds_grid_get(global.inst_ctrl_server.grd_dgn_classic_icons, 0, i));
        }
        network_send_raw(client_socket, buf_server, 514);
    break;
    case 16:
        //classic dungeon markers
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 12);
        buffer_write(buf_server, buffer_s8, -1);
        buffer_write(buf_server, buffer_u8, 0);
        for(i = 0; i < 1024; i += 1){
            buffer_write(buf_server, buffer_bool, ds_grid_get(global.inst_ctrl_server.grd_dgn_classic_icons_marker, 0, i));
        }
        network_send_raw(client_socket, buf_server, 1027);
    break;
    case 17:
        //classic dungeon markers
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 12);
        buffer_write(buf_server, buffer_s8, -1);
        buffer_write(buf_server, buffer_u8, 1);
        for(i = 0; i < 1024; i += 1){
            buffer_write(buf_server, buffer_bool, ds_grid_get(global.inst_ctrl_server.grd_dgn_classic_icons_marker, 0, 1024 + i));
        }
        network_send_raw(client_socket, buf_server, 1027);
    break;
    case 18:
        //classic dungeon markers
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 12);
        buffer_write(buf_server, buffer_s8, -1);
        buffer_write(buf_server, buffer_u8, 2);
        for(i = 0; i < 1024; i += 1){
            buffer_write(buf_server, buffer_bool, ds_grid_get(global.inst_ctrl_server.grd_dgn_classic_icons_marker, 0, 2048 + i));
        }
        network_send_raw(client_socket, buf_server, 1027);
    break;
    case 19:
        //classic dungeon markers
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 12);
        buffer_write(buf_server, buffer_s8, -1);
        buffer_write(buf_server, buffer_u8, 3);
        for(i = 0; i < 1024; i += 1){
            buffer_write(buf_server, buffer_bool, ds_grid_get(global.inst_ctrl_server.grd_dgn_classic_icons_marker, 0, 3072 + i));
        }
        network_send_raw(client_socket, buf_server, 1027);
    break;
    case 20: //player locations
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 14);
        buffer_write(buf_server, buffer_s8, -1);
        for(i = 0; i < 8; i += 1){
            buffer_write(buf_server, buffer_u8, global.inst_ctrl_server.server_playerowpos[i]);
            buffer_write(buf_server, buffer_u8, global.inst_ctrl_server.server_playermaptype[i]);
            buffer_write(buf_server, buffer_u8, global.inst_ctrl_server.server_playerdgnmap[i]);
            buffer_write(buf_server, buffer_u8, global.inst_ctrl_server.server_playerdgnpos[i]);
        }
        network_send_raw(client_socket, buf_server, 34);
    break;
    case 21: //auto dungeon palettes
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 15);
        buffer_write(buf_server, buffer_s8, -1);
        for(i = 0; i < 36; i += 1){
            buffer_write(buf_server, buffer_u32, ds_grid_get(global.inst_ctrl_server.grd_auto_dgnpals, 0, i));
        }
        network_send_raw(client_socket, buf_server, 146);
    break;
    case 22: //auto dungeon levels
        buffer_seek(buf_server, buffer_seek_start, 0);
        buffer_write(buf_server, buffer_u8, 16);
        buffer_write(buf_server, buffer_s8, -1);
        for(i = 0; i < 9; i += 1){
            buffer_write(buf_server, buffer_u8, ds_grid_get(global.inst_ctrl_server.grd_auto_dgnlevels, 0, i));
        }
        network_send_raw(client_socket, buf_server, 11);
    break;
    default:
        zh_server_msg("Tried to send nonexistent sync section " + string(curr_section) + " to P" + string(player_id) + ".");
}
curr_section += 1;
if(curr_section > 22){
    zh_server_msg("Syncing of P" + string(player_id) + " complete!");
    instance_destroy();
}
else{
    alarm[0] = global.server_stream_delay;
}

