//handle incoming packets if server is not active
if(global.server_id < 0){
    if(ds_map_find_value(async_load, "type") == network_type_connect){ //client connect
    }
    else if(ds_map_find_value(async_load, "type") == network_type_disconnect){ //client disconnect
        global.net_active = 0;
        global.playernames[0] = global.playername;
        global.playercolors[0] = global.playercolor;
        global.playerowpos[0] = 255;
        global.playerowpos[1] = 255;
        global.playerowpos[2] = 255;
        global.playerowpos[3] = 255;
        global.playerowpos[4] = 255;
        global.playerowpos[5] = 255;
        global.playerowpos[6] = 255;
        global.playerowpos[7] = 255;
        
        global.playerdgnpos[0] = 255;
        global.playerdgnpos[1] = 255;
        global.playerdgnpos[2] = 255;
        global.playerdgnpos[3] = 255;
        global.playerdgnpos[4] = 255;
        global.playerdgnpos[5] = 255;
        global.playerdgnpos[6] = 255;
        global.playerdgnpos[7] = 255;
        
        global.playermaptype[0] = 0;
        global.playermaptype[1] = 0;
        global.playermaptype[2] = 0;
        global.playermaptype[3] = 0;
        global.playermaptype[4] = 0;
        global.playermaptype[5] = 0;
        global.playermaptype[6] = 0;
        global.playermaptype[7] = 0;
        
        global.playerdgnmap[0] = 255;
        global.playerdgnmap[1] = 255;
        global.playerdgnmap[2] = 255;
        global.playerdgnmap[3] = 255;
        global.playerdgnmap[4] = 255;
        global.playerdgnmap[5] = 255;
        global.playerdgnmap[6] = 255;
        global.playerdgnmap[7] = 255;

        network_destroy(global.net_socketid);
        global.net_socketid = -1;
        global.alert_msg = "Connection to server lost."
        global.alert_show = 1;
        with(global.inst_ctrl_tracker){
            alarm[2] = global.alert_time;
        }
    }
    else if(ds_map_find_value(async_load, "type") == network_type_data){ //received data
        if(buf_leftover == -1){ //no leftovers from anticrash
            global.net_buf_recv = ds_map_find_value(async_load, "buffer");
            buffer_seek(global.net_buf_recv, buffer_seek_start, 0);
        }
        else{ //put leftovers from anticrash at the start of the received data to repair the stream
            global.net_buf_recv = buffer_create(buffer_get_size(buf_leftover) + ds_map_find_value(async_load, "size"), buffer_fixed, 1);
            buffer_seek(global.net_buf_recv, buffer_seek_start, 0);
            buffer_copy(buf_leftover, 0, buffer_get_size(buf_leftover), global.net_buf_recv, 0);
            buffer_copy(ds_map_find_value(async_load, "buffer"), 0, ds_map_find_value(async_load, "size"), global.net_buf_recv, buffer_get_size(buf_leftover));
            buffer_seek(global.net_buf_recv, buffer_seek_start, 0);
            buffer_delete(buf_leftover);
            buf_leftover = -1;
        }
        while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
            packet_id = buffer_read(global.net_buf_recv, buffer_u8);
            if(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){ //make sure it doesn't crash
                player_id = buffer_read(global.net_buf_recv, buffer_s8);
            }
            else{
                //KILL IT BEFORE IT EVEN THINKS ABOUT READING FROM OUTSIDE THE BUFFER!!!
                buf_leftover = buffer_create(1, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            
            //KILL IT BEFORE IT EVEN THINKS ABOUT READING FROM OUTSIDE THE BUFFER!!!
            if(packet_id == 1 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 1)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 4 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 176)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 5 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 88)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 6 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 128)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 7 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 1024)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 8 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 576)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 9 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 513)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 10 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 1008)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 11 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 512)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 12 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 1025)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 13 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 176)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 14 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 32)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 15 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 144)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 16 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 9)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 101 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 2)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 102 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 2)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 103 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 2)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 104 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 3)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 105 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 3)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 106 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 4)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 107 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 2)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 108 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 5)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 109 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 3)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 110 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 3)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 111 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 3)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 112 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 4)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 113 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 2)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            else if(packet_id == 201 && (buffer_tell(global.net_buf_recv) > buffer_get_size(global.net_buf_recv) - 1)){
                buf_leftover = buffer_create((buffer_get_size(global.net_buf_recv) - buffer_tell(global.net_buf_recv)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(global.net_buf_recv) < buffer_get_size(global.net_buf_recv)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(global.net_buf_recv, buffer_u8));
                }

                global.alert_msg = "ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!";
                global.alert_severe = 1;
                global.alert_show = 1;
                with(global.inst_ctrl_tracker){
                    alarm[2] = global.alert_time_severe;
                }
                break;
            }
            
            //handle packet
            switch(packet_id){
                case 1: //get player id, reset client
                    //reset client if player id is -1
                    if(global.net_playerid == -1){
                        //destroy old data structures to avoid memory leaks
                        ds_grid_destroy(grd_starts);
                        ds_grid_destroy(grd_triforce);
                        ds_grid_destroy(grd_hearts);
                        ds_grid_destroy(grd_items);
                        ds_grid_destroy(grd_items_marker);
                        ds_grid_destroy(grd_bomb_up);
                        ds_grid_destroy(grd_ow_icons);
                        ds_grid_destroy(grd_ow_icons_marker);
                        ds_grid_destroy(grd_dgn_icons);
                        ds_grid_destroy(grd_dgn_icons_marker);
                        ds_grid_destroy(grd_dgn_nums);
                        ds_grid_destroy(grd_dgn_colors);
                        ds_grid_destroy(grd_dgn_doors_h);
                        ds_grid_destroy(grd_dgn_doors_v);
                        ds_grid_destroy(grd_dgn_classic_icons);
                        ds_grid_destroy(grd_dgn_classic_icons_marker);
                        ds_grid_destroy(grd_hint_dgnloc);
                        ds_grid_destroy(grd_auto_dgnpals);
                        ds_grid_destroy(grd_auto_dgnlevels);
                        
                        //create new data structures
                        grd_starts = ds_grid_create(1, 10);
                        grd_triforce = ds_grid_create(1, 8);
                        grd_hearts = ds_grid_create(1, 13);
                        grd_items = ds_grid_create(1, 24);
                        grd_items_marker = ds_grid_create(1, 24);
                        grd_bomb_up = ds_grid_create(1, 2);
                        grd_ow_icons = ds_grid_create(1, 128);
                        grd_ow_icons_marker = ds_grid_create(1, 1024);
                        grd_dgn_icons = ds_grid_create(1, 576);
                        grd_dgn_icons_marker = ds_grid_create(1, 4608);
                        grd_dgn_nums = ds_grid_create(1, 9);
                        grd_dgn_colors = ds_grid_create(1, 9);
                        grd_dgn_doors_h = ds_grid_create(1, 504);
                        grd_dgn_doors_v = ds_grid_create(1, 504);
                        grd_dgn_classic_icons = ds_grid_create(1, 512);
                        grd_dgn_classic_icons_marker = ds_grid_create(1, 4096);
                        grd_hint_dgnloc = ds_grid_create(1, 9);
                        grd_auto_dgnpals = ds_grid_create(1, 36);
                        for(i = 0; i < 36; i++){
                            ds_grid_set(grd_auto_dgnpals, 0, i, c_white);
                        }
                        grd_auto_dgnlevels = ds_grid_create(1, 9);
                        
                        //set all starts to -1 to avoid wrong drawing
                        ds_grid_clear(grd_starts, -1);
                        
                        //set all dungeon colors to white to avoid issues
                        ds_grid_clear(grd_dgn_colors, c_white);
                        
                        //set dungeon number grid to null
                        for(i = 0; i < 9; i += 1){
                            ds_grid_set(grd_dgn_nums, 0, i, -1);
                        }
                        
                        //reset player positions
                        global.playerowpos[0] = 255;
                        global.playerowpos[1] = 255;
                        global.playerowpos[2] = 255;
                        global.playerowpos[3] = 255;
                        global.playerowpos[4] = 255;
                        global.playerowpos[5] = 255;
                        global.playerowpos[6] = 255;
                        global.playerowpos[7] = 255;
                        
                        global.playerdgnpos[0] = 255;
                        global.playerdgnpos[1] = 255;
                        global.playerdgnpos[2] = 255;
                        global.playerdgnpos[3] = 255;
                        global.playerdgnpos[4] = 255;
                        global.playerdgnpos[5] = 255;
                        global.playerdgnpos[6] = 255;
                        global.playerdgnpos[7] = 255;
                        
                        global.playermaptype[0] = 0;
                        global.playermaptype[1] = 0;
                        global.playermaptype[2] = 0;
                        global.playermaptype[3] = 0;
                        global.playermaptype[4] = 0;
                        global.playermaptype[5] = 0;
                        global.playermaptype[6] = 0;
                        global.playermaptype[7] = 0;
                        
                        global.playerdgnmap[0] = 255;
                        global.playerdgnmap[1] = 255;
                        global.playerdgnmap[2] = 255;
                        global.playerdgnmap[3] = 255;
                        global.playerdgnmap[4] = 255;
                        global.playerdgnmap[5] = 255;
                        global.playerdgnmap[6] = 255;
                        global.playerdgnmap[7] = 255;
                                                
                        //create automapper surface
                        if(surface_exists(global.srf_owmap)){
                            surface_free(global.srf_owmap);
                        }
                        global.srf_owmap = surface_create(256, 88);
                        
                    }
                    
                    //get player id
                    global.net_playerid = buffer_read(global.net_buf_recv, buffer_u8);
    
                    //send full sync request
                    buffer_seek(global.net_buf_send, buffer_seek_start, 0);
                    buffer_write(global.net_buf_send, buffer_u8, 3);
                    buffer_write(global.net_buf_send, buffer_s8, global.net_playerid);
                    network_send_raw(global.net_socketid, global.net_buf_send, 2);
                break;
                case 2: //reset client
                    //destroy old data structures to avoid memory leaks
                    ds_grid_destroy(grd_starts);
                    ds_grid_destroy(grd_triforce);
                    ds_grid_destroy(grd_hearts);
                    ds_grid_destroy(grd_items);
                    ds_grid_destroy(grd_items_marker);
                    ds_grid_destroy(grd_bomb_up);
                    ds_grid_destroy(grd_ow_icons);
                    ds_grid_destroy(grd_ow_icons_marker);
                    ds_grid_destroy(grd_dgn_icons);
                    ds_grid_destroy(grd_dgn_icons_marker);
                    ds_grid_destroy(grd_dgn_nums);
                    ds_grid_destroy(grd_dgn_colors);
                    ds_grid_destroy(grd_dgn_doors_h);
                    ds_grid_destroy(grd_dgn_doors_v);
                    ds_grid_destroy(grd_dgn_classic_icons);
                    ds_grid_destroy(grd_dgn_classic_icons_marker);
                    ds_grid_destroy(grd_hint_dgnloc);
                    ds_grid_destroy(grd_auto_dgnpals);
                    ds_grid_destroy(grd_auto_dgnlevels);
                    
                    //create new data structures
                    grd_starts = ds_grid_create(1, 10);
                    grd_triforce = ds_grid_create(1, 8);
                    grd_hearts = ds_grid_create(1, 13);
                    grd_items = ds_grid_create(1, 24);
                    grd_items_marker = ds_grid_create(1, 24);
                    grd_bomb_up = ds_grid_create(1, 2);
                    grd_ow_icons = ds_grid_create(1, 128);
                    grd_ow_icons_marker = ds_grid_create(1, 1024);
                    grd_dgn_icons = ds_grid_create(1, 576);
                    grd_dgn_icons_marker = ds_grid_create(1, 4608);
                    grd_dgn_nums = ds_grid_create(1, 9);
                    grd_dgn_colors = ds_grid_create(1, 9);
                    grd_dgn_doors_h = ds_grid_create(1, 504);
                    grd_dgn_doors_v = ds_grid_create(1, 504);
                    grd_dgn_classic_icons = ds_grid_create(1, 512);
                    grd_dgn_classic_icons_marker = ds_grid_create(1, 4096);
                    grd_hint_dgnloc = ds_grid_create(1, 9);
                    grd_auto_dgnpals = ds_grid_create(1, 36);
                    for(i = 0; i < 36; i++){
                        ds_grid_set(grd_auto_dgnpals, 0, i, c_white);
                    }
                    grd_auto_dgnlevels = ds_grid_create(1, 9);
                    
                    //set all starts to -1 to avoid wrong drawing
                    ds_grid_clear(grd_starts, -1);
                    
                    //set all dungeon colors to white to avoid issues
                    ds_grid_clear(grd_dgn_colors, c_white);
                    
                    //set dungeon number grid to null
                    for(i = 0; i < 9; i += 1){
                        ds_grid_set(grd_dgn_nums, 0, i, -1);
                    }
                    
                    //reset player positions
                    global.playerowpos[0] = 255;
                    global.playerowpos[1] = 255;
                    global.playerowpos[2] = 255;
                    global.playerowpos[3] = 255;
                    global.playerowpos[4] = 255;
                    global.playerowpos[5] = 255;
                    global.playerowpos[6] = 255;
                    global.playerowpos[7] = 255;
                    
                    global.playerdgnpos[0] = 255;
                    global.playerdgnpos[1] = 255;
                    global.playerdgnpos[2] = 255;
                    global.playerdgnpos[3] = 255;
                    global.playerdgnpos[4] = 255;
                    global.playerdgnpos[5] = 255;
                    global.playerdgnpos[6] = 255;
                    global.playerdgnpos[7] = 255;
                    
                    global.playermaptype[0] = 0;
                    global.playermaptype[1] = 0;
                    global.playermaptype[2] = 0;
                    global.playermaptype[3] = 0;
                    global.playermaptype[4] = 0;
                    global.playermaptype[5] = 0;
                    global.playermaptype[6] = 0;
                    global.playermaptype[7] = 0;
                    
                    global.playerdgnmap[0] = 255;
                    global.playerdgnmap[1] = 255;
                    global.playerdgnmap[2] = 255;
                    global.playerdgnmap[3] = 255;
                    global.playerdgnmap[4] = 255;
                    global.playerdgnmap[5] = 255;
                    global.playerdgnmap[6] = 255;
                    global.playerdgnmap[7] = 255;
                    
                    //create automapper surface
                    if(surface_exists(global.srf_owmap)){
                        surface_free(global.srf_owmap);
                    }
                    global.srf_owmap = surface_create(256, 88);
                break;
                case 4: //sync player info
                    for(i = 0; i < 8; i += 1){ //player info
                        player_color = buffer_read(global.net_buf_recv, buffer_u32);
                        name_len = buffer_read(global.net_buf_recv, buffer_u8);
                        player_name = buffer_read(global.net_buf_recv, buffer_string);
                        for(j = 0; j < 16 - string_length(player_name); j += 1){
                            garbage_dump = buffer_read(global.net_buf_recv, buffer_u8);
                        }
                        global.playercolors[i] = player_color;
                        global.playernames[i] = player_name;
                    }
                break;
                case 5: //sync start markers, itemboxes, dungeon numbers, and dungeon colors
                    for(i = 0; i < 10; i += 1){ //start markers
                        cell_data = buffer_read(global.net_buf_recv, buffer_u8);
                        ds_grid_set(grd_starts, 0, i, cell_data);
                    }
                    for(i = 0; i < 24; i += 1){ //item boxes
                        cell_data = buffer_read(global.net_buf_recv, buffer_u8);
                        ds_grid_set(grd_items, 0, i, cell_data);
                    }
                    for(i = 0; i < 9; i += 1){ //dungeon numbers
                        dgn_num = buffer_read(global.net_buf_recv, buffer_s8);
                        ds_grid_set(grd_dgn_nums, 0, i, dgn_num);
                    }
                    for(i = 0; i < 9; i += 1){ //dungeon colors
                        dgn_color = buffer_read(global.net_buf_recv, buffer_u32);
                        ds_grid_set(grd_dgn_colors, 0, i, dgn_color);
                    }
                    for(i = 0; i < 9; i += 1){ //dungeon location hints
                        hint_loc = buffer_read(global.net_buf_recv, buffer_u8);
                        ds_grid_set(grd_hint_dgnloc, 0, i, hint_loc);
                    }
                break;
                case 6: //sync overworld icons
                    for(i = 0; i < 128; i += 1){
                        cell_data = buffer_read(global.net_buf_recv, buffer_u8);
                        ds_grid_set(grd_ow_icons, 0, i, cell_data);
                    }
                break;
                case 7: //sync overworld markers
                    for(i = 0; i < 1024; i += 1){
                        cell_data = buffer_read(global.net_buf_recv, buffer_bool);
                        ds_grid_set(grd_ow_icons_marker, 0, i, cell_data);
                    }
                break;
                case 8: //sync dungeon icons
                    for(i = 0; i < 576; i += 1){
                        cell_data = buffer_read(global.net_buf_recv, buffer_u8);
                        ds_grid_set(grd_dgn_icons, 0, i, cell_data);
                    }
                break;
                case 9: //sync dungeon markers for the specified dungeon number
                    map_num = buffer_read(global.net_buf_recv, buffer_u8);
                    for(i = 0; i < 512; i += 1){
                        cell_data = buffer_read(global.net_buf_recv, buffer_bool);
                        ds_grid_set(grd_dgn_icons_marker, 0, (map_num * 512) + i, cell_data);
                    }
                break;
                case 10: //sync dungeon doors
                    for(i = 0; i < 504; i += 1){
                        cell_data = buffer_read(global.net_buf_recv, buffer_u8);
                        ds_grid_set(grd_dgn_doors_h, 0, i, cell_data);
                    }
                    for(i = 0; i < 504; i += 1){
                        cell_data = buffer_read(global.net_buf_recv, buffer_u8);
                        ds_grid_set(grd_dgn_doors_v, 0, i, cell_data);
                    }
                break;
                case 11: //sync classic dungeon icons
                    for(i = 0; i < 512; i += 1){
                        cell_data = buffer_read(global.net_buf_recv, buffer_u8);
                        ds_grid_set(grd_dgn_classic_icons, 0, i, cell_data);
                    }
                break;
                case 12: //sync classic dungeon markers for specified map number
                    map_num = buffer_read(global.net_buf_recv, buffer_u8);
                    for(i = 0; i < 1024; i += 1){
                        cell_data = buffer_read(global.net_buf_recv, buffer_bool);
                        ds_grid_set(grd_dgn_classic_icons_marker, 0, (map_num * 1024) + i, cell_data);
                    }
                break;
                case 13: //sync all player info
                    for(i = 0; i < 8; i += 1){
                        player_color = buffer_read(global.net_buf_recv, buffer_u32);
                        name_len = buffer_read(global.net_buf_recv, buffer_u8);
                        player_name = buffer_read(global.net_buf_recv, buffer_string);
                        for(j = 0; j < 16 - string_length(player_name); j += 1){
                            garbage_dump = buffer_read(global.net_buf_recv, buffer_u8);
                        }
                        global.playercolors[i] = player_color;
                        global.playernames[i] = player_name;
                    }
                break;
                case 14: //sync all player positions
                    for(i = 0; i < 8; i += 1){
                        global.playerowpos[i] = buffer_read(global.net_buf_recv, buffer_u8);
                        global.playermaptype[i] = buffer_read(global.net_buf_recv, buffer_u8);
                        global.playerdgnmap[i] = buffer_read(global.net_buf_recv, buffer_u8);
                        global.playerdgnpos[i] = buffer_read(global.net_buf_recv, buffer_u8);
                    }
                break;
                case 15: //sync all auto dungeon palette info
                    for(i = 0; i < 36; i += 1){
                        ds_grid_set(grd_auto_dgnpals, 0, i, buffer_read(global.net_buf_recv, buffer_u32));
                    }
                break;
                case 16: //sync all auto dungeon level info
                    for(i = 0; i < 9; i += 1){
                        ds_grid_set(grd_auto_dgnlevels, 0, i, buffer_read(global.net_buf_recv, buffer_u8));
                    }
                break;
                case 101: //sync single start marker
                    map_num = buffer_read(global.net_buf_recv, buffer_u8);
                    screen_num = buffer_read(global.net_buf_recv, buffer_u8);
                    ds_grid_set(grd_starts, 0, map_num, screen_num);
                break;
                case 102: //sync single itembox icon
                    cell_num = buffer_read(global.net_buf_recv, buffer_u8);
                    cell_data = buffer_read(global.net_buf_recv, buffer_u8);
                    ds_grid_set(grd_items, 0, cell_num, cell_data);
                break;
                case 103: //sync single overworld icon
                    cell_num = buffer_read(global.net_buf_recv, buffer_u8);
                    cell_data = buffer_read(global.net_buf_recv, buffer_u8);
                    ds_grid_set(grd_ow_icons, 0, cell_num, cell_data);
                break;
                case 104: //sync single overworld marker
                    cell_num = buffer_read(global.net_buf_recv, buffer_u8);
                    player_num = buffer_read(global.net_buf_recv, buffer_u8);
                    cell_data = buffer_read(global.net_buf_recv, buffer_bool);
                    ds_grid_set(grd_ow_icons_marker, 0, (player_num * 128) + cell_num, cell_data);
                break;
                case 105: //sync single dungeon icon
                    map_num = buffer_read(global.net_buf_recv, buffer_u8);
                    cell_num = buffer_read(global.net_buf_recv, buffer_u8);
                    cell_data = buffer_read(global.net_buf_recv, buffer_bool);
                    ds_grid_set(grd_dgn_icons, 0, (map_num * 64) + cell_num, cell_data);
                break;
                case 106: //sync single dungeon marker
                    map_num = buffer_read(global.net_buf_recv, buffer_u8);
                    cell_num = buffer_read(global.net_buf_recv, buffer_u8);
                    player_num = buffer_read(global.net_buf_recv, buffer_u8);
                    cell_data = buffer_read(global.net_buf_recv, buffer_bool);
                    ds_grid_set(grd_dgn_icons_marker, 0, (map_num * 512) + (player_num * 64) + cell_num, cell_data);
                break;
                case 107: //sync single dungeon number
                    map_num = buffer_read(global.net_buf_recv, buffer_u8);
                    dgn_num = buffer_read(global.net_buf_recv, buffer_s8);
                    ds_grid_set(grd_dgn_nums, 0, map_num, dgn_num);
                break;
                case 108: //sync single dungeon color
                    map_num = buffer_read(global.net_buf_recv, buffer_u8);
                    dgn_color = buffer_read(global.net_buf_recv, buffer_u32);
                    ds_grid_set(grd_dgn_colors, 0, map_num, dgn_color);
                break;
                case 109: //sync single horizontal dungeon door
                    map_num = buffer_read(global.net_buf_recv, buffer_u8);
                    cell_num = buffer_read(global.net_buf_recv, buffer_u8);
                    cell_data = buffer_read(global.net_buf_recv, buffer_u8);
                    ds_grid_set(grd_dgn_doors_h, 0, (map_num * 56) + cell_num, cell_data);
                break;
                case 110://sync single vertical dungeon door
                    map_num = buffer_read(global.net_buf_recv, buffer_u8);
                    cell_num = buffer_read(global.net_buf_recv, buffer_u8);
                    cell_data = buffer_read(global.net_buf_recv, buffer_u8);
                    ds_grid_set(grd_dgn_doors_v, 0, (map_num * 56) + cell_num, cell_data);
                break;
                case 111: //sync single classic dungeon icon
                    map_num = buffer_read(global.net_buf_recv, buffer_u8);
                    cell_num = buffer_read(global.net_buf_recv, buffer_u8);
                    cell_data = buffer_read(global.net_buf_recv, buffer_u8);
                    ds_grid_set(grd_dgn_classic_icons, 0, (map_num * 128) + cell_num, cell_data);
                break;
                case 112://sync single classic dungeon marker
                    map_num = buffer_read(global.net_buf_recv, buffer_u8);
                    cell_num = buffer_read(global.net_buf_recv, buffer_u8);
                    player_num = buffer_read(global.net_buf_recv, buffer_u8);
                    cell_data = buffer_read(global.net_buf_recv, buffer_bool);
                    ds_grid_set(grd_dgn_classic_icons_marker, 0, (map_num * 1024) + (player_num * 128) + cell_num, cell_data);
                break;
                case 113://sync single dungeon location hint
                    hint_num = buffer_read(global.net_buf_recv, buffer_u8);
                    hint_loc = buffer_read(global.net_buf_recv, buffer_u8);
                    ds_grid_set(grd_hint_dgnloc, 0, hint_num, hint_loc);
                break;
                case 201://auto dungeon map number response
                    //set the player's dungeon map and switch to that map if needed
                    global.playerdgnmap[global.net_playerid] = buffer_read(global.net_buf_recv, buffer_u8);
                    global.curr_map = global.playerdgnmap[global.net_playerid] + 1;
                    inst_btn_auto.map_type_prev = 2;
                break;
                case 254: //keep-alive
                    //send a #254 to server
                    buffer_seek(global.net_buf_send, buffer_seek_start, 0);
                    buffer_write(global.net_buf_send, buffer_u8, 254);
                    buffer_write(global.net_buf_send, buffer_s8, global.net_playerid);
                    network_send_raw(global.net_socketid, global.net_buf_send, 2);
                    
                    //show message to client
                    global.alert_msg = "Keep-alive packet received from server."
                    global.alert_show = 1;
                    with(global.inst_ctrl_tracker){
                        alarm[2] = floor(global.alert_time * 0.4); //shorten alert time
                    }
                break;
                case 255: //kick player
                    network_destroy(global.net_socketid);
                    global.net_socketid = -1;
                    global.net_active = 0;
                    global.net_playerid = -1;
                    global.playernames[0] = global.playername;
                    global.playercolors[0] = global.playercolor;
                    global.playerowpos[0] = 255;
                    global.playerowpos[1] = 255;
                    global.playerowpos[2] = 255;
                    global.playerowpos[3] = 255;
                    global.playerowpos[4] = 255;
                    global.playerowpos[5] = 255;
                    global.playerowpos[6] = 255;
                    global.playerowpos[7] = 255;
                    
                    global.playerdgnpos[0] = 255;
                    global.playerdgnpos[1] = 255;
                    global.playerdgnpos[2] = 255;
                    global.playerdgnpos[3] = 255;
                    global.playerdgnpos[4] = 255;
                    global.playerdgnpos[5] = 255;
                    global.playerdgnpos[6] = 255;
                    global.playerdgnpos[7] = 255;
                    
                    global.playermaptype[0] = 0;
                    global.playermaptype[1] = 0;
                    global.playermaptype[2] = 0;
                    global.playermaptype[3] = 0;
                    global.playermaptype[4] = 0;
                    global.playermaptype[5] = 0;
                    global.playermaptype[6] = 0;
                    global.playermaptype[7] = 0;
                    
                    global.playerdgnmap[0] = 255;
                    global.playerdgnmap[1] = 255;
                    global.playerdgnmap[2] = 255;
                    global.playerdgnmap[3] = 255;
                    global.playerdgnmap[4] = 255;
                    global.playerdgnmap[5] = 255;
                    global.playerdgnmap[6] = 255;
                    global.playerdgnmap[7] = 255;
                    global.alert_msg = "You were kicked by the server.";
                    global.alert_show = 1;
                    with(global.inst_ctrl_tracker){
                        alarm[2] = global.alert_time;
                    }
                break;
                default:
                    global.alert_msg = "ANTICRASH: INVALID PACKET TYPE " + string(packet_id) + " RECEIVED! SKIPPING!";
                    global.alert_severe = 1;
                    global.alert_show = 1;
                    with(global.inst_ctrl_tracker){
                        alarm[2] = global.alert_time;
                    }
            }
        }
        //save layout
        global.inst_ctrl_tracker.alarm[0] = global.autosave_time;
    }
}

