//globals
frame = 1;
global.quest = 0; //currently selected quest
global.mixed = 0; //1 if mixed mode is active
global.mirrored = 0; //1 if overworld map is mirrored
global.curr_map = 0; //currently selected map
global.show_areas = 0; //whether or not to show areas overlay
global.autosave_time = 60; //amount of time to wait before auto-saving
global.autosave_message_enable = 0; //flag that tells if autosave message is shown
global.autosave_message_time = 30; //number of frames to keep the message visible
global.inst_ctrl_tracker = self.id; //this instance's id
global.wheel_done = false; //because GM mousewheel events are a glitchfest
global.alert_msg = ""; //alert message
global.alert_show = 0; //whether alert message is shown
global.alert_severe = 0; //whether the alert is severe or not (anticrash messages, errors, etc.)
global.alert_time = 120; //time to show the alert for
global.alert_time_severe = 120; //time to show the severe alert for
global.ow_transparency = 0; //toggles transparency of overworld icons so you can see the map underneath them
global.ow_map_transparency = 0; //toggles transparency of the overworld map to make auto-mapping more visible
global.track_auto = 0; //toggles whether automatic tracking is enabled or not
global.track_auto_interval = 30; //time in frames between auto-tracker updates on the server
global.dgn_finder_auto = 1; //whether dungeon finder is semi-auto or disabled
global.dgn_itemtype = global.dgn_item_style; //0 for hearts, 1 for item boxes (item area below triforce icons)
global.dgn_transparency = 0; //toggles transparency of unmarked dungeon areas on the D1-D9 maps
//expanded = 0;

if(global.is_yyc_build){
    window_set_caption("ZHelper " + global.version + "-YYC: F1-Reset F2-Load F7/F8-Scale F9-Main Menu F5/F6-Map/Icon Transparency");
}
else{
    window_set_caption("ZHelper " + global.version + ": F1-Reset F2-Load F7/F8-Scale F9-Main Menu F5/F6-Map/Icon Transparency");
}

//create automapper surface
if(surface_exists(global.srf_owmap)){
    surface_free(global.srf_owmap);
}
global.srf_owmap = surface_create(256, 88);

//setup data structures
global.playercolors[0] = global.playercolor;
global.playercolors[1] = c_white;
global.playercolors[2] = c_white;
global.playercolors[3] = c_white;
global.playercolors[4] = c_white;
global.playercolors[5] = c_white;
global.playercolors[6] = c_white;
global.playercolors[7] = c_white;

global.playernames[0] = global.playername;
global.playernames[1] = "";
global.playernames[2] = "";
global.playernames[3] = "";
global.playernames[4] = "";
global.playernames[5] = "";
global.playernames[6] = "";
global.playernames[7] = "";

global.playerowpos[0] = 255;
global.playerowpos[1] = 255;
global.playerowpos[2] = 255;
global.playerowpos[3] = 255;
global.playerowpos[4] = 255;
global.playerowpos[5] = 255;
global.playerowpos[6] = 255;
global.playerowpos[7] = 255;

global.playerdgnpos[0] = 255;
global.playerdgnpos[1] = 255;
global.playerdgnpos[2] = 255;
global.playerdgnpos[3] = 255;
global.playerdgnpos[4] = 255;
global.playerdgnpos[5] = 255;
global.playerdgnpos[6] = 255;
global.playerdgnpos[7] = 255;

global.playermaptype[0] = 0;
global.playermaptype[1] = 0;
global.playermaptype[2] = 0;
global.playermaptype[3] = 0;
global.playermaptype[4] = 0;
global.playermaptype[5] = 0;
global.playermaptype[6] = 0;
global.playermaptype[7] = 0;

global.playerdgnmap[0] = 255;
global.playerdgnmap[1] = 255;
global.playerdgnmap[2] = 255;
global.playerdgnmap[3] = 255;
global.playerdgnmap[4] = 255;
global.playerdgnmap[5] = 255;
global.playerdgnmap[6] = 255;
global.playerdgnmap[7] = 255;

grd_starts = ds_grid_create(1, 10);
grd_triforce = ds_grid_create(1, 8);
grd_hearts = ds_grid_create(1, 13);
grd_items = ds_grid_create(1, 24);
grd_items_marker = ds_grid_create(1, 24);
grd_bomb_up = ds_grid_create(1, 2);
grd_ow_icons = ds_grid_create(1, 128);
grd_ow_icons_marker = ds_grid_create(1, 1024);
grd_dgn_icons = ds_grid_create(1, 576);
grd_dgn_icons_marker = ds_grid_create(1, 4608);
grd_dgn_nums = ds_grid_create(1, 9);
grd_dgn_colors = ds_grid_create(1, 9);
grd_dgn_doors_h = ds_grid_create(1, 504);
grd_dgn_doors_v = ds_grid_create(1, 504);
grd_dgn_classic_icons = ds_grid_create(1, 512);
grd_dgn_classic_icons_marker = ds_grid_create(1, 4096);
grd_hint_dgnloc = ds_grid_create(1, 9);
grd_auto_dgnpals = ds_grid_create(1, 36);
for(i = 0; i < 36; i++){
    ds_grid_set(grd_auto_dgnpals, 0, i, c_white);
}
grd_auto_dgnlevels = ds_grid_create(1, 9);

//set all starts to -1 to avoid wrong drawing
ds_grid_clear(grd_starts, -1);

//set all dungeon colors to white to avoid issues
ds_grid_clear(grd_dgn_colors, c_white);

//temp var for networking to put crap in
garbage_dump = 0;
frame = 0;
buf_leftover = -1;

//create instances
//top bar buttons
var inst_temp;
for(i = 0; i < 15; i++){
    inst_temp = instance_create(i * 12, 0, o_btn_tr_quickview);
    inst_temp.image_single = i;
}

//triforce icons
for(i = 0; i < 8; i += 1){
    inst_triforce[i] = instance_create(1 + (i * 10), 10, o_btn_tr_triforce);
    inst_triforce[i].inst_num = i;
}

//dungeon heart icons
for(i = 0; i < 8; i += 1){
    inst_hearts[i] = instance_create(1 + (i * 10), 20, o_btn_tr_heart);
    inst_hearts[i].inst_num = i;
}

//below triforce item boxes
for(i = 16; i < 24; i += 1){
    inst_items[i] = instance_create(1 + ((i - 16) * 10), 20, o_btn_tr_itembox);
    inst_items[i].inst_num = i;
}

//overworld heart icons
for(i = 0; i < 4; i += 1){
    inst_hearts[8 + i] = instance_create(216 + (i * 10), 10, o_btn_tr_heart);
    inst_hearts[8 + i].inst_num = i + 8;
}

//ladder heart
inst_hearts[12] = instance_create(190, 10, o_btn_tr_heart);
inst_hearts[12].inst_num = 12;

//dungeon item icons
for(i = 0; i < 9; i += 1){
    inst_items[i] = instance_create(81 + (i * 12), 10, o_btn_tr_itembox);
    inst_items[i].inst_num = i;

    
    switch(i){ //create extras where needed
        case 0:
            inst_items[9] = instance_create(81 + (i * 12), 22, o_btn_tr_itembox);
            inst_items[9].inst_num = 9;
        break;
        case 3:
            inst_items[10] = instance_create(81 + (i * 12), 22, o_btn_tr_itembox);
            inst_items[10].inst_num = 10;
        break;
        case 7:
            inst_items[11] = instance_create(81 + (i * 12), 22, o_btn_tr_itembox);
            inst_items[11].inst_num = 11;
        break;
        case 8:
            inst_items[12] = instance_create(81 + (i * 12), 22, o_btn_tr_itembox);
            inst_items[12].inst_num = 12;
        break;
    }
}

//overworld item icons
for(i = 0; i < 3; i += 1){
    inst_items[13 + i] = instance_create(189 + (i * 12), 20, o_btn_tr_itembox);
    inst_items[13 + i].inst_num = 13 + i;
}

//bomb upgrades
inst_bomb_up[0] = instance_create(130, 23, o_btn_tr_bombup);
inst_bomb_up[0].inst_num = 0;
inst_bomb_up[1] = instance_create(154, 23, o_btn_tr_bombup);
inst_bomb_up[0].inst_num = 1;

//create top section buttons
instance_create(13, 30, o_btn_tr_quest);
instance_create(1, 30, o_btn_tr_view);
instance_create(29, 30, o_btn_tr_mix);
instance_create(45, 30, o_btn_tr_area);
instance_create(65, 30, o_btn_tr_trans);
instance_create(162, 102, o_btn_tr_clear);
inst_shiftbtn[0] = instance_create(182, 132, o_btn_tr_shiftdgn);
inst_shiftbtn[0].inst_num = 0;
inst_shiftbtn[1] = instance_create(172, 122, o_btn_tr_shiftdgn);
inst_shiftbtn[1].inst_num = 1;
inst_shiftbtn[2] = instance_create(162, 132, o_btn_tr_shiftdgn);
inst_shiftbtn[2].inst_num = 2;
inst_shiftbtn[3] = instance_create(172, 132, o_btn_tr_shiftdgn);
inst_shiftbtn[3].inst_num = 3;

//instance_create(229, 163, o_btn_tr_clear);
inst_btn_auto = instance_create(95, 30, o_btn_tr_auto);
instance_create(232, 30, o_btn_tr_net);
inst_ow_grid = instance_create(228, 0, o_btn_tr_dgn_itemtype);

//create overworld map objects
inst_ow_grid = instance_create(0, 48, o_tr_grid_overworld);

//create dungeon map objects
//dungeon cells
for(i = 0; i < 64; i += 1){
    inst_dgn_cell[i] = instance_create(18 * (i mod 8), 53 + (14 * (i div 8)), o_btn_tr_dungeon_cell);
    inst_dgn_cell[i].cell_num = i;
}

//dungeon doors
for(i = 0; i < 56; i += 1){
    //horizontal
    inst_dgn_door_h[i] = instance_create(13 + (18 * (i mod 7)), 55 + (14 * (i div 7)), o_btn_tr_dungeon_door_h);
    inst_dgn_door_h[i].cell_num = i;
    
    //vertical
    inst_dgn_door_v[i] = instance_create(4 + (18 * (i mod 8)), 62 + (14 * (i div 8)), o_btn_tr_dungeon_door_v);
    inst_dgn_door_v[i].cell_num = i;
}

//dungeon number buttons
for(i = 0; i < 9; i += 1){
    //1st
    inst_dgn_num[i] = instance_create(162 + (10 * i), 52, o_btn_tr_dungeon_num);
    inst_dgn_num[i].image_single = i;
    inst_dgn_num[i].quest = 0;
    inst_dgn_num[i].dungeon = i;
    //2nd
    inst_dgn_num[9 + i] = instance_create(162 + (10 * i), 62, o_btn_tr_dungeon_num);
    inst_dgn_num[9 + i].image_single = i;
    inst_dgn_num[9 + i].quest = 1;
    inst_dgn_num[9 + i].dungeon = i;
    
    //set grid to null
    ds_grid_set(grd_dgn_nums, 0, i, -1);
}

//dungeon palette colors
dgn_pal[0] = make_color_rgb(128, 128, 128);
dgn_pal[1] = make_color_rgb(0, 80, 241);
dgn_pal[2] = make_color_rgb(59, 52, 255);
dgn_pal[3] = make_color_rgb(128, 34, 232);
dgn_pal[4] = make_color_rgb(187, 30, 165);
dgn_pal[5] = make_color_rgb(219, 41, 78);
dgn_pal[6] = make_color_rgb(215, 64, 0);
dgn_pal[7] = make_color_rgb(177, 94, 0);
dgn_pal[8] = make_color_rgb(115, 121, 0);
dgn_pal[9] = make_color_rgb(173, 173, 173);
dgn_pal[10] = make_color_rgb(75, 160, 255);
dgn_pal[11] = make_color_rgb(138, 132, 255);
dgn_pal[12] = make_color_rgb(209, 114, 255);
dgn_pal[13] = make_color_rgb(255, 109, 247);
dgn_pal[14] = make_color_rgb(255, 121, 158);
dgn_pal[15] = make_color_rgb(255, 144, 71);
dgn_pal[16] = make_color_rgb(255, 174, 10);
dgn_pal[17] = make_color_rgb(196, 202, 0);
dgn_pal[18] = make_color_rgb(255, 255, 255);
dgn_pal[19] = make_color_rgb(182, 216, 255);
dgn_pal[20] = make_color_rgb(208, 205, 255);
dgn_pal[21] = make_color_rgb(237, 198, 255);
dgn_pal[22] = make_color_rgb(255, 196, 252);
dgn_pal[23] = make_color_rgb(255, 200, 216);
dgn_pal[24] = make_color_rgb(255, 210, 180);
dgn_pal[25] = make_color_rgb(255, 222, 156);
dgn_pal[26] = make_color_rgb(231, 233, 148);
dgn_pal[27] = make_color_rgb(45, 139, 0);
dgn_pal[28] = make_color_rgb(0, 143, 8);
dgn_pal[29] = make_color_rgb(0, 132, 96);
dgn_pal[30] = make_color_rgb(0, 109, 181);
dgn_pal[31] = make_color_rgb(125, 220, 19);
dgn_pal[32] = make_color_rgb(65, 225, 87);
dgn_pal[33] = make_color_rgb(33, 213, 176);
dgn_pal[34] = make_color_rgb(37, 190, 255);
dgn_pal[35] = make_color_rgb(202, 241, 159);
dgn_pal[36] = make_color_rgb(178, 243, 187);
dgn_pal[37] = make_color_rgb(165, 238, 223);
dgn_pal[38] = make_color_rgb(166, 229, 255);

//dungeon palette buttons
for(i = 0; i < 9; i += 1){
        inst_dgn_pal[i] = instance_create(162 + (10 * i), 72, o_btn_tr_dungeon_pal);
        inst_dgn_pal[i].image_blend = dgn_pal[i];
        inst_dgn_pal[9 + i] = instance_create(162 + (10 * i), 82, o_btn_tr_dungeon_pal);
        inst_dgn_pal[9 + i].image_blend = dgn_pal[9 + i];
        inst_dgn_pal[18 + i] = instance_create(162 + (10 * i), 92, o_btn_tr_dungeon_pal);
        inst_dgn_pal[18 + i].image_blend = dgn_pal[18 + i];
}

for(i = 0; i < 4; i += 1){
        inst_dgn_pal[i] = instance_create(212 + (10 * i), 102, o_btn_tr_dungeon_pal);
        inst_dgn_pal[i].image_blend = dgn_pal[27 + i];
        inst_dgn_pal[9 + i] = instance_create(212 + (10 * i), 112, o_btn_tr_dungeon_pal);
        inst_dgn_pal[9 + i].image_blend = dgn_pal[31 + i];
        inst_dgn_pal[18 + i] = instance_create(212 + (10 * i), 122, o_btn_tr_dungeon_pal);
        inst_dgn_pal[18 + i].image_blend = dgn_pal[35 + i];
}
inst_dgn_pal[39] = instance_create(202, 102, o_btn_tr_dungeon_pal);
inst_dgn_pal[39].image_blend = c_white;

//create dungeon finder controller
instance_create(0, 0, o_ctrl_dgn_finder);

//create classic dungeon map objects
inst_dgn_classic_grid = instance_create(0, 48, o_tr_grid_dgn_classic);

//create hints screen objects
for(i = 0; i < 9; i += 1){
    inst_hint_dgnloc[i] = instance_create(13, 49 + (i * 12), o_btn_tr_hinticon);
    inst_hint_dgnloc[i].inst_num = i;
}

//load if requested
if(global.do_load){
    event_user(1);
    global.do_load = 0;
}

