//handle incoming packets if server is active
if(global.server_id >= 0){
    buf_data = -1;
    if(ds_map_find_value(async_load, "type") == network_type_connect){ //client connect
        client_ip = ds_map_find_value(async_load, "ip");
        client_socket = ds_map_find_value(async_load, "socket");
        zh_server_msg("Client connected. Socket ID is " + string(client_socket) + ".");
        if(!audio_is_playing(snd_client_connect) && global.server_audio_alerts){
            audio_play_sound(snd_client_connect, 100, 0);
        }
    }
    else if(ds_map_find_value(async_load, "type") == network_type_disconnect){ //client disconnect
        client_ip = ds_map_find_value(async_load, "ip");
        client_socket = ds_map_find_value(async_load, "socket");
        client_num = -1;
        for(i = 0; i < 8; i += 1){
            if(server_playersocket[i] == client_socket){
                client_num = i;
                server_playerconnected[i] = 0;
                server_playersocket[i] = -1;
                server_playerowpos[i] = 255;
                server_playerdgnpos[i] = 255;
                server_playermaptype[i] = 0;
                server_playerdgnmap[i] = 255;
                break;
            }
        }
        zh_server_msg("Client " + string(client_num) + " disconnected. Socket ID was " + string(client_socket) + ".");
        if(!audio_is_playing(snd_client_disconnect) && global.server_audio_alerts){
            audio_play_sound(snd_client_disconnect, 100, 0);
        }
    }
    else if(ds_map_find_value(async_load, "type") == network_type_data){ //data incoming
        //get buffer data
        if(buf_leftover == -1){ //no leftovers from anticrash
            buf_data = ds_map_find_value(async_load, "buffer");
            buffer_seek(buf_data, buffer_seek_start, 0);
        }
        else{ //put leftovers from anticrash at the start of the received data to repair the stream
            buf_data = buffer_create(buffer_get_size(buf_leftover) + ds_map_find_value(async_load, "size"), buffer_fixed, 1);
            buffer_seek(buf_data, buffer_seek_start, 0);
            buffer_copy(buf_leftover, 0, buffer_get_size(buf_leftover), buf_data, 0);
            buffer_copy(ds_map_find_value(async_load, "buffer"), 0, ds_map_find_value(async_load, "size"), buf_data, buffer_get_size(buf_leftover));
            buffer_seek(buf_data, buffer_seek_start, 0);
            buffer_delete(buf_leftover);
            buf_leftover = -1;
        }
        buf_size = ds_map_find_value(async_load, "size");
        client_ip = ds_map_find_value(async_load, "ip");
        client_socket = ds_map_find_value(async_load, "id");
        buffer_seek(buf_data, buffer_seek_start, 0);
        while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
            packet_id = buffer_read(buf_data, buffer_u8);
            if(buffer_tell(buf_data) < buffer_get_size(buf_data)){ //make sure it doesn't crash
                player_id = buffer_read(buf_data, buffer_s8);
            }
            else{
                //KILL IT BEFORE IT EVEN THINKS ABOUT READING FROM OUTSIDE THE BUFFER!!!
                buf_leftover = buffer_create(1, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            
            //KILL IT BEFORE IT EVEN THINKS ABOUT READING FROM OUTSIDE THE BUFFER!!!
            if(packet_id == 0 && (buffer_tell(buf_data) > buffer_get_size(buf_data) - 22)){
                buf_leftover = buffer_create((buffer_get_size(buf_data) - buffer_tell(buf_data)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(buf_data, buffer_u8));
                }
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            else if(packet_id == 101 && (buffer_tell(buf_data) > buffer_get_size(buf_data) - 2)){
                buf_leftover = buffer_create((buffer_get_size(buf_data) - buffer_tell(buf_data)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(buf_data, buffer_u8));
                }
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            else if(packet_id == 102 && (buffer_tell(buf_data) > buffer_get_size(buf_data) - 2)){
                buf_leftover = buffer_create((buffer_get_size(buf_data) - buffer_tell(buf_data)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(buf_data, buffer_u8));
                }
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            else if(packet_id == 103 && (buffer_tell(buf_data) > buffer_get_size(buf_data) - 2)){
                buf_leftover = buffer_create((buffer_get_size(buf_data) - buffer_tell(buf_data)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(buf_data, buffer_u8));
                }
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            else if(packet_id == 104 && (buffer_tell(buf_data) > buffer_get_size(buf_data) - 3)){
                buf_leftover = buffer_create((buffer_get_size(buf_data) - buffer_tell(buf_data)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(buf_data, buffer_u8));
                }
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            else if(packet_id == 105 && (buffer_tell(buf_data) > buffer_get_size(buf_data) - 3)){
                buf_leftover = buffer_create((buffer_get_size(buf_data) - buffer_tell(buf_data)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(buf_data, buffer_u8));
                }
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            else if(packet_id == 106 && (buffer_tell(buf_data) > buffer_get_size(buf_data) - 4)){
                buf_leftover = buffer_create((buffer_get_size(buf_data) - buffer_tell(buf_data)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(buf_data, buffer_u8));
                }
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            else if(packet_id == 107 && (buffer_tell(buf_data) > buffer_get_size(buf_data) - 2)){
                buf_leftover = buffer_create((buffer_get_size(buf_data) - buffer_tell(buf_data)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(buf_data, buffer_u8));
                }
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            else if(packet_id == 108 && (buffer_tell(buf_data) > buffer_get_size(buf_data) - 5)){
                buf_leftover = buffer_create((buffer_get_size(buf_data) - buffer_tell(buf_data)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(buf_data, buffer_u8));
                }
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            else if(packet_id == 109 && (buffer_tell(buf_data) > buffer_get_size(buf_data) - 3)){
                buf_leftover = buffer_create((buffer_get_size(buf_data) - buffer_tell(buf_data)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(buf_data, buffer_u8));
                }
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            else if(packet_id == 110 && (buffer_tell(buf_data) > buffer_get_size(buf_data) - 3)){
                buf_leftover = buffer_create((buffer_get_size(buf_data) - buffer_tell(buf_data)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(buf_data, buffer_u8));
                }
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            else if(packet_id == 111 && (buffer_tell(buf_data) > buffer_get_size(buf_data) - 3)){
                buf_leftover = buffer_create((buffer_get_size(buf_data) - buffer_tell(buf_data)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(buf_data, buffer_u8));
                }
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            else if(packet_id == 112 && (buffer_tell(buf_data) > buffer_get_size(buf_data) - 4)){
                buf_leftover = buffer_create((buffer_get_size(buf_data) - buffer_tell(buf_data)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(buf_data, buffer_u8));
                }
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            else if(packet_id == 113 && (buffer_tell(buf_data) > buffer_get_size(buf_data) - 2)){
                buf_leftover = buffer_create((buffer_get_size(buf_data) - buffer_tell(buf_data)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(buf_data, buffer_u8));
                }
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            else if(packet_id == 114 && (buffer_tell(buf_data) > buffer_get_size(buf_data) - 4)){
                buf_leftover = buffer_create((buffer_get_size(buf_data) - buffer_tell(buf_data)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(buf_data, buffer_u8));
                }
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            else if(packet_id == 115 && (buffer_tell(buf_data) > buffer_get_size(buf_data) - 2)){
                buf_leftover = buffer_create((buffer_get_size(buf_data) - buffer_tell(buf_data)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(buf_data, buffer_u8));
                }
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            else if(packet_id == 200 && (buffer_tell(buf_data) > buffer_get_size(buf_data) - 17)){
                buf_leftover = buffer_create((buffer_get_size(buf_data) - buffer_tell(buf_data)) + 2, buffer_fixed, 1);
                buffer_seek(buf_leftover, buffer_seek_start, 0);
                buffer_write(buf_leftover, buffer_u8, packet_id);
                buffer_write(buf_leftover, buffer_u8, player_id);
                while(buffer_tell(buf_data) < buffer_get_size(buf_data)){
                    buffer_write(buf_leftover, buffer_u8, buffer_read(buf_data, buffer_u8));
                }
                zh_server_msg("ANTICRASH: PREVENTED OOB CRASH! PACKET " + string(packet_id) + "!");
                break;
            }
            connect_done = 0;
            
            switch(packet_id){
                case 0: //handshake
                    player_color = buffer_read(buf_data, buffer_u32);
                    player_name_len = buffer_read(buf_data, buffer_u8);
                    player_name = buffer_read(buf_data, buffer_string);
                    for(i = 0; i < 16 - string_length(player_name); i += 1){
                        garbage_dump = buffer_read(buf_data, buffer_u8);
                    }
                    
                    connect_done = 0;
                    zh_server_msg("Received handshake from " + player_name + ". Socket ID is " + string(client_socket) + ".");
        
                    //check for reconnection
                    for(i = 0; i < 8; i += 1){
                        if(server_playerip[i] == client_ip && server_playername[i] == player_name){ //reconnection
                            server_playerip[i] = client_ip;
                            server_playername[i] = player_name;
                            server_playercolor[i] = player_color;
                            server_playersocket[i] = client_socket;
                            server_playerconnected[i] = 1;
                            zh_server_msg(server_playername[i] + " (P" + string(i) + ") reconnected. Socket ID is " + string(client_socket) + ".");
                            connect_done = 1;
        
                            //send client its id
                            buffer_seek(buf_server,buffer_seek_start, 0);
                            buffer_write(buf_server,  buffer_u8, 1);
                            buffer_write(buf_server, buffer_s8, -1);
                            buffer_write(buf_server, buffer_u8, i);
                            network_send_raw(client_socket, buf_server, 3);
                            
                            //send others the info
                            buffer_seek(buf_server, buffer_seek_start, 0);
                            buffer_write(buf_server, buffer_u8, 13);
                            buffer_write(buf_server, buffer_s8, -1);
                            for(j = 0; j < 8; j += 1){
                                buffer_write(buf_server, buffer_u32, server_playercolor[j]); //player color
                                buffer_write(buf_server, buffer_u8, string_length(server_playername[j])); //player name len
                                buffer_write(buf_server, buffer_string, server_playername[j]); //player name
                                for(k = 0; k < 16 - string_length(server_playername[j]); k += 1){
                                    buffer_write(buf_server, buffer_u8, 0);
                                }
                            }
                            for(j = 0; j < 8; j += 1){
                                if(server_playersocket[j] != -1 && server_playerconnected[j] && server_playername[j] != player_name){
                                    network_send_raw(server_playersocket[j], buf_server, 178);
                                }
                            }
                            zh_server_msg("Synced existing clients' player data.");
                            break;
                        }
                    }
                    
                    if(!connect_done){
                        i = 0;
                        do{
                            if(server_playerip[i] == "" && server_playername[i] == ""){ //found a free slot, so set the ip
                                server_playerip[i] = client_ip;
                                server_playername[i] = player_name;
                                server_playercolor[i] = player_color;
                                server_playersocket[i] = client_socket;
                                server_playerconnected[i] = 1;
                                zh_server_msg(player_name + " (P" + string(i) + ") set. Socket ID is: " + string(client_socket) + ".");
        
                                //send client its id
                                buffer_seek(buf_server, buffer_seek_start, 0);
                                buffer_write(buf_server, buffer_u8, 1);
                                buffer_write(buf_server, buffer_s8, -1);
                                buffer_write(buf_server, buffer_u8, i);
                                network_send_raw(client_socket, buf_server, 3);
        
                                //send others the info
                                buffer_seek(buf_server, buffer_seek_start, 0);
                                buffer_write(buf_server, buffer_u8, 13);
                                buffer_write(buf_server, buffer_s8, -1);
                                for(j = 0; j < 8; j += 1){
                                    buffer_write(buf_server, buffer_u32, server_playercolor[j]); //player color
                                    buffer_write(buf_server, buffer_u8, string_length(server_playername[j])); //player name len
                                    buffer_write(buf_server, buffer_string, server_playername[j]); //player name
                                    for(k = 0; k < 16 - string_length(server_playername[j]); k += 1){
                                        buffer_write(buf_server, buffer_u8, 0);
                                    }
                                }
                                for(j = 0; j < 8; j += 1){
                                    if(server_playersocket[j] != -1 && server_playerconnected[j] && server_playername[j] != player_name){
                                        network_send_raw(server_playersocket[j], buf_server, 178);
                                    }
                                }
                                zh_server_msg("Synced existing clients' player data.");
                                break;
                            }
                            i += 1;
                            if(i > 7){ //no free slot
                                zh_server_msg("Client connected, but no free slot. Socket ID was " + string(client_socket) + ". Kicking.");
                                buffer_seek(buf_server, buffer_seek_start, 0);
                                buffer_write(buf_server, buffer_u8, 255);
                                buffer_write(buf_server, buffer_s8, -1);
                                network_send_raw(client_socket, buf_server, 2);
                                break;
                            }
                        } until (0);
                    }
                break;
                case 3: //full sync request
                    player_name = server_playername[player_id];
                    zh_server_msg("Received full sync request from " + player_name + ". ID is " + string(player_id) + ".");
                    
                    //make sync handler and stream the data
                    inst_temp = instance_create(0, 0, o_server_synchandler);
                    inst_temp.client_socket = client_socket;
                    inst_temp.player_id = player_id;
                break;
                case 101: //sync single start marker
                    map_num = buffer_read(buf_data, buffer_u8);
                    screen_num = buffer_read(buf_data, buffer_u8);
        
                    //update server's info
                    ds_grid_set(grd_starts, 0, map_num, screen_num);
                    
                    zh_server_msg("P" + string(player_id) + ": Start " + string(map_num) + " is: " + string(screen_num) + ".");
                    
                    //send update to clients
                    buffer_seek(buf_server, buffer_seek_start, 0);
                    buffer_write(buf_server, buffer_u8, 101);
                    buffer_write(buf_server, buffer_s8, player_id);
                    buffer_write(buf_server, buffer_u8, map_num);
                    buffer_write(buf_server, buffer_u8, screen_num);
                    for(i = 0; i < 8; i += 1){
                        if(server_playersocket[i] != -1 && server_playerconnected[i] && i != player_id){
                            network_send_raw(server_playersocket[i], buf_server, 4);
                        }
                    }
                break;
                case 102: //sync single itembox item
                    cell_num = buffer_read(buf_data, buffer_u8);
                    cell_data = buffer_read(buf_data, buffer_u8);
        
                    //update server's info
                    ds_grid_set(grd_items, 0, cell_num, cell_data);
                    
                    zh_server_msg("P" + string(player_id) + ": Item " + string(cell_num) + " is: " + string(cell_data) + ".");
                    
                    //send update to clients
                    buffer_seek(buf_server, buffer_seek_start, 0);
                    buffer_write(buf_server, buffer_u8, 102);
                    buffer_write(buf_server, buffer_s8, player_id);
                    buffer_write(buf_server, buffer_u8, cell_num);
                    buffer_write(buf_server, buffer_u8, cell_data);
                    for(i = 0; i < 8; i += 1){
                        if(server_playersocket[i] != -1 && server_playerconnected[i] && i != player_id){
                            network_send_raw(server_playersocket[i], buf_server, 4);
                        }
                    }
                break;
                case 103: //sync single overworld icon
                    cell_num = buffer_read(buf_data, buffer_u8);
                    cell_data = buffer_read(buf_data, buffer_u8);
        
                    //update server's info
                    ds_grid_set(grd_ow_icons, 0, cell_num, cell_data);
                    
                    zh_server_msg("P" + string(player_id) + ": OW " + string(cell_num) + " is: " + string(cell_data) + ".");
                    
                    //send update to clients
                    buffer_seek(buf_server, buffer_seek_start, 0);
                    buffer_write(buf_server, buffer_u8, 103);
                    buffer_write(buf_server, buffer_s8, player_id);
                    buffer_write(buf_server, buffer_u8, cell_num);
                    buffer_write(buf_server, buffer_u8, cell_data);
                    for(i = 0; i < 8; i += 1){
                        if(server_playersocket[i] != -1 && server_playerconnected[i] && i != player_id){
                            network_send_raw(server_playersocket[i], buf_server, 4);
                        }
                    }
                break;
                case 104: //sync single overworld marker
                    cell_num = buffer_read(buf_data, buffer_u8);
                    player_num = buffer_read(buf_data, buffer_u8);
                    cell_data = buffer_read(buf_data, buffer_bool);
        
                    //update server's info
                    ds_grid_set(grd_ow_icons_marker, 0, (player_num * 128) + cell_num, cell_data);
                    
                    zh_server_msg("P" + string(player_id) + ": OW marker " + string((player_num * 128) + cell_num) + " is: " + string(cell_data) + ".");
                    
                    //send update to clients
                    buffer_seek(buf_server, buffer_seek_start, 0);
                    buffer_write(buf_server, buffer_u8, 104);
                    buffer_write(buf_server, buffer_s8, player_id);
                    buffer_write(buf_server, buffer_u8, cell_num);
                    buffer_write(buf_server, buffer_u8, player_num);
                    buffer_write(buf_server, buffer_bool, cell_data);
                    for(i = 0; i < 8; i += 1){
                        if(server_playersocket[i] != -1 && server_playerconnected[i] && i != player_id){
                            network_send_raw(server_playersocket[i], buf_server, 5);
                        }
                    }
                break;
                case 105: //sync single dungeon icon
                    map_num = buffer_read(buf_data, buffer_u8);
                    cell_num = buffer_read(buf_data, buffer_u8);
                    cell_data = buffer_read(buf_data, buffer_u8);
        
                    //update server's info
                    ds_grid_set(grd_dgn_icons, 0, (map_num * 64) + cell_num, cell_data);
                    
                    //sync with classic map if needed
                    if(ds_grid_get(grd_dgn_nums, 0, map_num) != -1){
                        classic_cell_num = zh_classic_dgn_cell_from_new(map_num, cell_num);
                        if(classic_cell_num != -1){
                            ds_grid_set(grd_dgn_classic_icons, 0, classic_cell_num, cell_data);
                        
                            //send update to clients
                            buffer_seek(buf_server, buffer_seek_start, 0);
                            buffer_write(buf_server, buffer_u8, 111);
                            buffer_write(buf_server, buffer_s8, player_id);
                            buffer_write(buf_server, buffer_u8, classic_cell_num div 128);
                            buffer_write(buf_server, buffer_u8, classic_cell_num mod 128);
                            buffer_write(buf_server, buffer_u8, cell_data);
                            for(i = 0; i < 8; i += 1){
                                if(server_playersocket[i] != -1 && server_playerconnected[i]){
                                    network_send_raw(server_playersocket[i], buf_server, 5);
                                }
                            }
                        }
                    }
                    
                    zh_server_msg("P" + string(player_id) + ": DGN " + string((map_num * 64) + cell_num) + " is: " + string(cell_data) + ".");
                    
                    //send update to clients
                    buffer_seek(buf_server, buffer_seek_start, 0);
                    buffer_write(buf_server, buffer_u8, 105);
                    buffer_write(buf_server, buffer_s8, player_id);
                    buffer_write(buf_server, buffer_u8, map_num);
                    buffer_write(buf_server, buffer_u8, cell_num);
                    buffer_write(buf_server, buffer_u8, cell_data);
                    for(i = 0; i < 8; i += 1){
                        if(server_playersocket[i] != -1 && server_playerconnected[i] && i != player_id){
                            network_send_raw(server_playersocket[i], buf_server, 5);
                        }
                    }
                break;
                case 106: //sync single dungeon marker
                    map_num = buffer_read(buf_data, buffer_u8);
                    cell_num = buffer_read(buf_data, buffer_u8);
                    player_num = buffer_read(buf_data, buffer_u8);
                    cell_data = buffer_read(buf_data, buffer_bool);
        
                    //update server's info
                    ds_grid_set(grd_dgn_icons_marker, 0, (map_num * 512) + (player_num * 64) + cell_num, cell_data);
                    
                    //sync with classic map if needed
                    if(ds_grid_get(grd_dgn_nums, 0, map_num) != -1){
                        classic_cell_num = zh_classic_dgn_cell_from_new(map_num, cell_num);
                        if(classic_cell_num != -1){
                            ds_grid_set(grd_dgn_classic_icons_marker, 0, ((classic_cell_num div 128) * 1024) + (player_num * 128) + (classic_cell_num mod 128), cell_data);
                        
                            //send update to clients
                            buffer_seek(buf_server, buffer_seek_start, 0);
                            buffer_write(buf_server, buffer_u8, 112);
                            buffer_write(buf_server, buffer_s8, player_id);
                            buffer_write(buf_server, buffer_u8, classic_cell_num div 128);
                            buffer_write(buf_server, buffer_u8, classic_cell_num mod 128);
                            buffer_write(buf_server, buffer_u8, player_num);
                            buffer_write(buf_server, buffer_bool, cell_data);
                            for(i = 0; i < 8; i += 1){
                                if(server_playersocket[i] != -1 && server_playerconnected[i]){
                                    network_send_raw(server_playersocket[i], buf_server, 6);
                                }
                            }
                        }
                    }
                    
                    zh_server_msg("P" + string(player_id) + ": DGN marker " + string((map_num * 512) + (player_num * 64) + cell_num) + " is: " + string(cell_data) + ".");
                    
                    //send update to clients
                    buffer_seek(buf_server, buffer_seek_start, 0);
                    buffer_write(buf_server, buffer_u8, 106);
                    buffer_write(buf_server, buffer_s8, player_id);
                    buffer_write(buf_server, buffer_u8, map_num);
                    buffer_write(buf_server, buffer_u8, cell_num);
                    buffer_write(buf_server, buffer_u8, player_num);
                    buffer_write(buf_server, buffer_bool, cell_data);
                    for(i = 0; i < 8; i += 1){
                        if(server_playersocket[i] != -1 && server_playerconnected[i] && i != player_id){
                            network_send_raw(server_playersocket[i], buf_server, 6);
                        }
                    }
                break;
                case 107: //sync single dungeon number
                    map_num = buffer_read(buf_data, buffer_u8);
                    cell_data = buffer_read(buf_data, buffer_u8);
        
                    //update server's info
                    need_sync = 0;
                    if(ds_grid_get(grd_dgn_nums, 0, map_num) != cell_data){
                        need_sync = 1;
                    }
                    ds_grid_set(grd_dgn_nums, 0, map_num, cell_data);
                    
                    zh_server_msg("P" + string(player_id) + ": DGN num " + string(map_num) + " is: " + string(cell_data) + ".");
                    
                    //send update to clients
                    buffer_seek(buf_server, buffer_seek_start, 0);
                    buffer_write(buf_server, buffer_u8, 107);
                    buffer_write(buf_server, buffer_s8, player_id);
                    buffer_write(buf_server, buffer_u8, map_num);
                    buffer_write(buf_server, buffer_s8, cell_data);
                    for(i = 0; i < 8; i += 1){
                        if(server_playersocket[i] != -1 && server_playerconnected[i] && i != player_id){
                            network_send_raw(server_playersocket[i], buf_server, 4);
                        }
                    }
                    
                    //sync the new and classic dungeon maps
                    if(need_sync){
                        inst_temp = instance_create(0, 0, o_server_synchandler_dgn);
                        inst_temp.dgn_num = cell_data;
                        inst_temp.map_num = map_num;
                    }
                break;
                case 108: //sync single dungeon color
                    map_num = buffer_read(buf_data, buffer_u8);
                    cell_data = buffer_read(buf_data, buffer_u32);
        
                    //update server's info
                    ds_grid_set(grd_dgn_colors, 0, map_num, cell_data);
                    
                    zh_server_msg("P" + string(player_id) + ": DGN color " + string(map_num) + " is: " + string(cell_data) + ".");
                    
                    //send update to clients
                    buffer_seek(buf_server, buffer_seek_start, 0);
                    buffer_write(buf_server, buffer_u8, 108);
                    buffer_write(buf_server, buffer_s8, player_id);
                    buffer_write(buf_server, buffer_u8, map_num);
                    buffer_write(buf_server, buffer_u32, cell_data);
                    for(i = 0; i < 8; i += 1){
                        if(server_playersocket[i] != -1 && server_playerconnected[i] && i != player_id){
                            network_send_raw(server_playersocket[i], buf_server, 7);
                        }
                    }
                break;
                case 109: //sync single horizontal dungeon door
                    map_num = buffer_read(buf_data, buffer_u8);
                    cell_num = buffer_read(buf_data, buffer_u8);
                    cell_data = buffer_read(buf_data, buffer_u8);
        
                    //update server's info
                    ds_grid_set(grd_dgn_doors_h, 0, (map_num * 56) + cell_num, cell_data);
                    
                    zh_server_msg("P" + string(player_id) + ": DGN door H " + string((map_num * 56) + cell_num) + " is: " + string(cell_data) + ".");
                    
                    //send update to clients
                    buffer_seek(buf_server, buffer_seek_start, 0);
                    buffer_write(buf_server, buffer_u8, 109);
                    buffer_write(buf_server, buffer_s8, player_id);
                    buffer_write(buf_server, buffer_u8, map_num);
                    buffer_write(buf_server, buffer_u8, cell_num);
                    buffer_write(buf_server, buffer_u8, cell_data);
                    for(i = 0; i < 8; i += 1){
                        if(server_playersocket[i] != -1 && server_playerconnected[i] && i != player_id){
                            network_send_raw(server_playersocket[i], buf_server, 5);
                        }
                    }
                break;
                case 110: //sync single vertical dungeon door
                    map_num = buffer_read(buf_data, buffer_u8);
                    cell_num = buffer_read(buf_data, buffer_u8);
                    cell_data = buffer_read(buf_data, buffer_u8);
        
                    //update server's info
                    ds_grid_set(grd_dgn_doors_v, 0, (map_num * 56) + cell_num, cell_data);
                    
                    zh_server_msg("P" + string(player_id) + ": DGN door V " + string((map_num * 56) + cell_num) + " is: " + string(cell_data) + ".");
                    
                    //send update to clients
                    buffer_seek(buf_server, buffer_seek_start, 0);
                    buffer_write(buf_server, buffer_u8, 110);
                    buffer_write(buf_server, buffer_s8, player_id);
                    buffer_write(buf_server, buffer_u8, map_num);
                    buffer_write(buf_server, buffer_u8, cell_num);
                    buffer_write(buf_server, buffer_u8, cell_data);
                    for(i = 0; i < 8; i += 1){
                        if(server_playersocket[i] != -1 && server_playerconnected[i] && i != player_id){
                            network_send_raw(server_playersocket[i], buf_server, 5);
                        }
                    }
                break;
                case 111: //sync single classic dungeon icon
                    map_num = buffer_read(buf_data, buffer_u8);
                    cell_num = buffer_read(buf_data, buffer_u8);
                    cell_data = buffer_read(buf_data, buffer_u8);
        
                    //update server's info
                    ds_grid_set(grd_dgn_classic_icons, 0, (map_num * 128) + cell_num, cell_data);

                    //sync with new map if needed
                    new_map_num = -1;
                    for(i = 0; i < 9; i += 1){
                        if(zh_new_dgn_num_from_classic((map_num * 128) + cell_num) == ds_grid_get(grd_dgn_nums, 0, i)){
                            new_map_num = i;
                            break;
                        }
                    }
                    if(new_map_num != -1){ //new dungeon exists, so sync with it
                        new_cell_num = zh_new_dgn_cell_from_classic((map_num * 128) + cell_num);
                        if(new_cell_num != -1){
                            ds_grid_set(grd_dgn_icons, 0, (new_map_num * 64) + new_cell_num, cell_data);
                        
                            //send update to clients
                            buffer_seek(buf_server, buffer_seek_start, 0);
                            buffer_write(buf_server, buffer_u8, 105);
                            buffer_write(buf_server, buffer_s8, player_id);
                            buffer_write(buf_server, buffer_u8, new_map_num);
                            buffer_write(buf_server, buffer_u8, new_cell_num);
                            buffer_write(buf_server, buffer_u8, cell_data);
                            for(i = 0; i < 8; i += 1){
                                if(server_playersocket[i] != -1 && server_playerconnected[i]){
                                    network_send_raw(server_playersocket[i], buf_server, 5);
                                }
                            }
                        }
                        else{
                            zh_server_msg("111 NEW EXIST: Tried to sync invalid dungeon cell.");
                        }
                    }
                    else{ //new dungeon doesn't exist, so make one
                        for(i = 0; i < 9; i += 1){
                            if(ds_grid_get(grd_dgn_nums, 0, i) == -1){
                                new_map_num = i;
                                break;
                            }
                        }
                        new_dgn_num = zh_new_dgn_num_from_classic((map_num * 128) + cell_num);
                        new_cell_num = zh_new_dgn_cell_from_classic((map_num * 128) + cell_num);
                        if(new_dgn_num != -1 && new_cell_num != -1){
                            //set the new dungeon icon and the level number
                            ds_grid_set(grd_dgn_icons, 0, (new_map_num * 64) + new_cell_num, cell_data);
                            ds_grid_set(grd_dgn_nums, 0, new_map_num, new_dgn_num);

                            //send dungeon number update to clients
                            buffer_seek(buf_server, buffer_seek_start, 0);
                            buffer_write(buf_server, buffer_u8, 107);
                            buffer_write(buf_server, buffer_s8, player_id);
                            buffer_write(buf_server, buffer_u8, new_map_num);
                            buffer_write(buf_server, buffer_s8, new_dgn_num);
                            for(i = 0; i < 8; i += 1){
                                if(server_playersocket[i] != -1 && server_playerconnected[i]){
                                    network_send_raw(server_playersocket[i], buf_server, 4);
                                }
                            }
                            
                            //populate the dungeon map (this handles markers as well, so no need for this in markers)
                            inst_temp = instance_create(0, 0, o_server_synchandler_dgn);
                            inst_temp.dgn_num = new_dgn_num;
                            inst_temp.map_num = new_map_num;
                        }
                        else{
                            zh_server_msg("111 NEW NOT: Tried to sync invalid dungeon cell.");
                        }
                    }
                    
                    zh_server_msg("P" + string(player_id) + ": CDGN " + string((map_num * 128) + cell_num) + " is: " + string(cell_data) + ".");
                    
                    //send update to clients
                    buffer_seek(buf_server, buffer_seek_start, 0);
                    buffer_write(buf_server, buffer_u8, 111);
                    buffer_write(buf_server, buffer_s8, player_id);
                    buffer_write(buf_server, buffer_u8, map_num);
                    buffer_write(buf_server, buffer_u8, cell_num);
                    buffer_write(buf_server, buffer_u8, cell_data);
                    for(i = 0; i < 8; i += 1){
                        if(server_playersocket[i] != -1 && server_playerconnected[i] && i != player_id){
                            network_send_raw(server_playersocket[i], buf_server, 5);
                        }
                    }
                break;
                case 112: //sync single classic dungeon marker
                    map_num = buffer_read(buf_data, buffer_u8);
                    cell_num = buffer_read(buf_data, buffer_u8);
                    player_num = buffer_read(buf_data, buffer_u8);
                    cell_data = buffer_read(buf_data, buffer_bool);
        
                    //update server's info
                    ds_grid_set(grd_dgn_classic_icons_marker, 0, (map_num * 1024) + (player_num * 128) + cell_num, cell_data);
                    
                    //sync with new map if needed
                    new_map_num = -1;
                    for(i = 0; i < 9; i += 1){
                        if(zh_new_dgn_num_from_classic((map_num * 128) + cell_num) == ds_grid_get(grd_dgn_nums, 0, i)){
                            new_map_num = i;
                            break;
                        }
                    }
                    if(new_map_num != -1){
                        new_cell_num = zh_new_dgn_cell_from_classic((map_num * 128) + cell_num);
                        if(new_cell_num != -1){
                            ds_grid_set(grd_dgn_icons_marker, 0, (new_map_num * 512) + (player_num * 64) + new_cell_num, cell_data);
                        
                            //send update to clients
                            buffer_seek(buf_server, buffer_seek_start, 0);
                            buffer_write(buf_server, buffer_u8, 106);
                            buffer_write(buf_server, buffer_s8, player_id);
                            buffer_write(buf_server, buffer_u8, new_map_num);
                            buffer_write(buf_server, buffer_u8, new_cell_num);
                            buffer_write(buf_server, buffer_u8, player_num);
                            buffer_write(buf_server, buffer_bool, cell_data);
                            for(i = 0; i < 8; i += 1){
                                if(server_playersocket[i] != -1 && server_playerconnected[i]){
                                    network_send_raw(server_playersocket[i], buf_server, 6);
                                }
                            }
                        }
                        else{
                            zh_server_msg("112: Tried to sync invalid dungeon cell.");
                        }
                    }
                    
                    zh_server_msg("P" + string(player_id) + ": CDGN marker " + string((map_num * 1024) + (player_num * 128) + cell_num) + " is: " + string(cell_data) + ".");
                    
                    //send update to clients
                    buffer_seek(buf_server, buffer_seek_start, 0);
                    buffer_write(buf_server, buffer_u8, 112);
                    buffer_write(buf_server, buffer_s8, player_id);
                    buffer_write(buf_server, buffer_u8, map_num);
                    buffer_write(buf_server, buffer_u8, cell_num);
                    buffer_write(buf_server, buffer_u8, player_num);
                    buffer_write(buf_server, buffer_bool, cell_data);
                    for(i = 0; i < 8; i += 1){
                        if(server_playersocket[i] != -1 && server_playerconnected[i] && i != player_id){
                            network_send_raw(server_playersocket[i], buf_server, 6);
                        }
                    }
                break;
                case 113: //sync single dungeon location hint
                    hint_num = buffer_read(buf_data, buffer_u8);
                    hint_loc = buffer_read(buf_data, buffer_u8);
        
                    //update server's info
                    ds_grid_set(grd_hint_dgnloc, 0, hint_num, hint_loc);
                    
                    zh_server_msg("P" + string(player_id) + ": Location hint " + string(hint_num) + " is: " + string(hint_loc) + ".");
                    
                    //send update to clients
                    buffer_seek(buf_server, buffer_seek_start, 0);
                    buffer_write(buf_server, buffer_u8, 113);
                    buffer_write(buf_server, buffer_s8, player_id);
                    buffer_write(buf_server, buffer_u8, hint_num);
                    buffer_write(buf_server, buffer_u8, hint_loc);
                    for(i = 0; i < 8; i += 1){
                        if(server_playersocket[i] != -1 && server_playerconnected[i] && i != player_id){
                            network_send_raw(server_playersocket[i], buf_server, 4);
                        }
                    }
                break;
                case 114: //sync single player location
                    ow_pos = buffer_read(buf_data, buffer_u8);
                    map_type = buffer_read(buf_data, buffer_u8);
                    dgn_map = buffer_read(buf_data, buffer_u8);
                    dgn_pos = buffer_read(buf_data, buffer_u8);
        
                    //update server's info
                    server_playerowpos[player_id] = ow_pos;
                    server_playermaptype[player_id] = map_type;
                    server_playerdgnmap[player_id] = dgn_map;
                    server_playerdgnpos[player_id] = dgn_pos;
                    
                    //turning this one off cause it spams like a 10k+ viewer Twitch chat
                    //zh_server_msg("P" + string(player_id) + ": OW Loc is " + string(ow_pos) + ", Map type is " + string(map_type) + ".");
                break;
                case 115: //sync single auto dungeon number
                    dgn_map = buffer_read(buf_data, buffer_u8);
                    lvl_num = buffer_read(buf_data, buffer_u8);
        
                    //update server's info
                    ds_grid_set(grd_auto_dgnlevels, 0, dgn_map, lvl_num);
                    
                    //send update with all level number data to clients
                    buffer_seek(buf_server, buffer_seek_start, 0);
                    buffer_write(buf_server, buffer_u8, 16);
                    buffer_write(buf_server, buffer_s8, -1);
                    for(j = 0; j < 9; j++){
                        buffer_write(buf_server, buffer_u8, ds_grid_get(grd_auto_dgnlevels, 0, j));
                    }
                    for(j = 0; j < 8; j += 1){
                        if(server_playersocket[j] != -1 && server_playerconnected[j]){
                            network_send_raw(server_playersocket[j], buf_server, 11);
                        }
                    }
                    
                    zh_server_msg("P" + string(player_id) + ": DGN Map " + string(dgn_map) + " is level " + string(lvl_num) + ".");
                break;
                case 200: //sync single player location
                    dgn_c1 = buffer_read(buf_data, buffer_u32);
                    dgn_c2 = buffer_read(buf_data, buffer_u32);
                    dgn_c3 = buffer_read(buf_data, buffer_u32);
                    dgn_c4 = buffer_read(buf_data, buffer_u32);
                    dgn_start = buffer_read(buf_data, buffer_u8);
                    zh_server_msg("P" + string(player_id) + ": AUTO DMAP REQUEST: PALS " + string(dgn_c1) + "," + string(dgn_c2) + "," + string(dgn_c3) + "," + string(dgn_c4) + "; START " + string(dgn_start));
                    
                    //search for the dungeon, creating a new one if needed
                    var r, g, b, cf, dgn_amap;
                    dgn_amap = 255;
                    
                    //search existing too even though the client thinks its not there, just in case it is
                    for(i = 0; i < 9; i++){
                        dgn_amap = i;
                        if(ds_grid_get(grd_starts, 0, i + 1) == dgn_start && dgn_c1 == ds_grid_get(grd_auto_dgnpals, 0, i * 4) && dgn_c2 == ds_grid_get(grd_auto_dgnpals, 0, 1 + (i * 4)) &&  dgn_c3 == ds_grid_get(grd_auto_dgnpals, 0, 2 + (i * 4)) &&  dgn_c4 == ds_grid_get(grd_auto_dgnpals, 0, 3 + (i * 4))){
                            dgn_amap = i;
                            global.playerdgnmap[player_id] = i;
                            break;
                        }
                        else if(c_white == ds_grid_get(grd_auto_dgnpals, 0, i * 4) && c_white == ds_grid_get(grd_auto_dgnpals, 0, 1 + (i * 4)) &&  c_white == ds_grid_get(grd_auto_dgnpals, 0, 2 + (i * 4)) &&  c_white == ds_grid_get(grd_auto_dgnpals, 0, 3 + (i * 4))){
                            dgn_amap = i;
                            global.playerdgnmap[player_id] = i;
                            
                            //set colors
                            ds_grid_set(grd_auto_dgnpals, 0, (dgn_amap * 4), dgn_c1);
                            ds_grid_set(grd_auto_dgnpals, 0, (1 + (dgn_amap * 4)), dgn_c2);
                            ds_grid_set(grd_auto_dgnpals, 0, (2 + (dgn_amap * 4)), dgn_c3);
                            ds_grid_set(grd_auto_dgnpals, 0, (3 + (dgn_amap * 4)), dgn_c4);
                            
                            r = (color_get_red(dgn_c1) + color_get_red(dgn_c2) + color_get_red(dgn_c3)) div 3;
                            g = (color_get_green(dgn_c1) + color_get_green(dgn_c2) + color_get_green(dgn_c3)) div 3;
                            b = (color_get_blue(dgn_c1) + color_get_blue(dgn_c2) + color_get_blue(dgn_c3)) div 3;
                            
                            cf = make_color_rgb(r, g, b);
                            if(color_get_value(cf) < 160){
                                cf = make_color_hsv(color_get_hue(cf), color_get_saturation(cf), 160);
                            }
                            ds_grid_set(grd_dgn_colors, 0, dgn_amap, cf);
                            
                            //set start screen
                            ds_grid_set(grd_starts, 0, dgn_amap + 1, dgn_start);
                            
                            //send updated stuff to clients
                            //dungeon color
                            buffer_seek(buf_server, buffer_seek_start, 0);
                            buffer_write(buf_server, buffer_u8, 108);
                            buffer_write(buf_server, buffer_s8, player_id);
                            buffer_write(buf_server, buffer_u8, dgn_amap);
                            buffer_write(buf_server, buffer_u32, cf);
                            for(j = 0; j < 8; j += 1){
                                if(server_playersocket[j] != -1 && server_playerconnected[j]){
                                    network_send_raw(server_playersocket[j], buf_server, 7);
                                }
                            }
                            
                            //update auto palettes
                            buffer_seek(buf_server, buffer_seek_start, 0);
                            buffer_write(buf_server, buffer_u8, 15);
                            buffer_write(buf_server, buffer_s8, -1);
                            for(j = 0; j < 36; j++){
                                buffer_write(buf_server, buffer_u32, ds_grid_get(grd_auto_dgnpals, 0, j));
                            }
                            for(j = 0; j < 8; j += 1){
                                if(server_playersocket[j] != -1 && server_playerconnected[j]){
                                    network_send_raw(server_playersocket[j], buf_server, 146);
                                }
                            }
                            
                            //dungeon start screen
                            buffer_seek(buf_server, buffer_seek_start, 0);
                            buffer_write(buf_server, buffer_u8, 101);
                            buffer_write(buf_server, buffer_s8, player_id);
                            buffer_write(buf_server, buffer_u8, dgn_amap + 1);
                            buffer_write(buf_server, buffer_u8, dgn_start);
                            for(j = 0; j < 8; j += 1){
                                if(server_playersocket[j] != -1 && server_playerconnected[j]){
                                    network_send_raw(server_playersocket[j], buf_server, 4);
                                }
                            }
                            break;
                        }
                    }

                    zh_server_msg("DMAP RESPONSE IS " + string(dgn_amap));
                    
                    //send response to client.
                    buffer_seek(buf_server, buffer_seek_start, 0);
                    buffer_write(buf_server, buffer_u8, 201);
                    buffer_write(buf_server, buffer_s8, -1);
                    buffer_write(buf_server, buffer_u8, dgn_amap);
                    if(server_playersocket[player_id] != -1 && server_playerconnected[player_id]){
                        network_send_raw(server_playersocket[player_id], buf_server, 3);
                    }
                    
                    //send immediate position update
                    event_perform(ev_alarm, 1);
                break;
                case 254: //keep-alive
                    pingpong = 1; //do something stupid just to make sure it runs
                break;
                default: //unknown packet error
                    zh_server_msg("ANTICRASH: INVALID PACKET TYPE " + string(packet_id) + " RECEIVED! SKIPPING!");
            }
        }
    }
    else{ //something isn't right
        zh_server_msg("WARNING: Networking event triggered with unrecognized type: " + ds_map_find_value(async_load, "type"));
    }
}

