//open log
global.lfs = file_text_open_write("zhserver.log");

//vars
frame = 0; //used for the pulsating warning text
warn = 0; //same
garbage_dump = 0; //temp var for dealing with garbage data

//set window properties
if(global.is_yyc_build){
    window_set_caption("ZHelper Server " + global.version + "-YYC");
}
else{
    window_set_caption("ZHelper Server " + global.version);
}
cx = window_get_x();
cy = window_get_y();
window_set_size(512, 416);
window_set_position(cx, cy);

//initialize server log
for(i = 0; i < 8; i += 1){
    server_log[i] = "";
}

//set instance id
global.inst_ctrl_server = id;

//define data structures
server_playercolor[0] = c_white;
server_playercolor[1] = c_white;
server_playercolor[2] = c_white;
server_playercolor[3] = c_white;
server_playercolor[4] = c_white;
server_playercolor[5] = c_white;
server_playercolor[6] = c_white;
server_playercolor[7] = c_white;

server_playername[0] = "";
server_playername[1] = "";
server_playername[2] = "";
server_playername[3] = "";
server_playername[4] = "";
server_playername[5] = "";
server_playername[6] = "";
server_playername[7] = "";

server_playersocket[0] = -1;
server_playersocket[1] = -1;
server_playersocket[2] = -1;
server_playersocket[3] = -1;
server_playersocket[4] = -1;
server_playersocket[5] = -1;
server_playersocket[6] = -1;
server_playersocket[7] = -1;

server_playerconnected[0] = -1;
server_playerconnected[1] = -1;
server_playerconnected[2] = -1;
server_playerconnected[3] = -1;
server_playerconnected[4] = -1;
server_playerconnected[5] = -1;
server_playerconnected[6] = -1;
server_playerconnected[7] = -1;

server_playerip[0] = "";
server_playerip[1] = "";
server_playerip[2] = "";
server_playerip[3] = "";
server_playerip[4] = "";
server_playerip[5] = "";
server_playerip[6] = "";
server_playerip[7] = "";

server_playerowpos[0] = 255;
server_playerowpos[1] = 255;
server_playerowpos[2] = 255;
server_playerowpos[3] = 255;
server_playerowpos[4] = 255;
server_playerowpos[5] = 255;
server_playerowpos[6] = 255;
server_playerowpos[7] = 255;

server_playerdgnpos[0] = 255;
server_playerdgnpos[1] = 255;
server_playerdgnpos[2] = 255;
server_playerdgnpos[3] = 255;
server_playerdgnpos[4] = 255;
server_playerdgnpos[5] = 255;
server_playerdgnpos[6] = 255;
server_playerdgnpos[7] = 255;

server_playermaptype[0] = 0;
server_playermaptype[1] = 0;
server_playermaptype[2] = 0;
server_playermaptype[3] = 0;
server_playermaptype[4] = 0;
server_playermaptype[5] = 0;
server_playermaptype[6] = 0;
server_playermaptype[7] = 0;

server_playerdgnmap[0] = 255;
server_playerdgnmap[1] = 255;
server_playerdgnmap[2] = 255;
server_playerdgnmap[3] = 255;
server_playerdgnmap[4] = 255;
server_playerdgnmap[5] = 255;
server_playerdgnmap[6] = 255;
server_playerdgnmap[7] = 255;

grd_starts = ds_grid_create(1, 10);
grd_items = ds_grid_create(1, 24);
grd_ow_icons = ds_grid_create(1, 128);
grd_ow_icons_marker = ds_grid_create(1, 1024);
grd_dgn_icons = ds_grid_create(1, 576);
grd_dgn_icons_marker = ds_grid_create(1, 4608);
grd_dgn_nums = ds_grid_create(1, 9);
grd_dgn_colors = ds_grid_create(1, 9);
grd_dgn_doors_h = ds_grid_create(1, 504);
grd_dgn_doors_v = ds_grid_create(1, 504);
grd_dgn_classic_icons = ds_grid_create(1, 512);
grd_dgn_classic_icons_marker = ds_grid_create(1, 4096);
grd_hint_dgnloc = ds_grid_create(1, 9);
grd_auto_dgnpals = ds_grid_create(1, 36);
for(i = 0; i < 36; i++){
    ds_grid_set(grd_auto_dgnpals, 0, i, c_white);
}
grd_auto_dgnlevels = ds_grid_create(1, 9);

//set all starts to -1 to avoid wrong drawing
ds_grid_clear(grd_starts, -1);

//set all dungeon colors to white to avoid issues
ds_grid_clear(grd_dgn_colors, c_white);

//set dungeon number grid to null
for(i = 0; i < 9; i += 1){
    ds_grid_set(grd_dgn_nums, 0, i, -1);
}

//create buffer
buf_server = buffer_create(1300, buffer_fixed, 1); //go lower just to be sure it doesn't go over 1500

//temp vars
temp_pid = -1;
buf_leftover = -1;

//output server log message
zh_server_msg("Data structures initialized.");

//start the server
global.server_id = network_create_server_raw(network_socket_tcp, global.server_port, 9);
if(global.server_id < 0){
    show_message_async("The server failed to start. Error code returned was: " + string(global.server_id) + ".");
    network_destroy(global.server_id);
    room_goto(r_mainmenu);
}
else{
    zh_server_msg("Server started with ID " + string(global.server_id) + " on port " + string(global.server_port) + ".");
}

//create instances
instance_create(120, 188, o_btn_server_resetall);
instance_create(188, 188, o_btn_server_shutdown);

//create player buttons
for(i = 0; i < 8; i += 1){
    inst_kick[i] = instance_create(4 + (124 * (i mod 2)), 30 + (10 * (i div 2)), o_btn_server_kick);
    inst_kick[i].inst_num = i;
    inst_sync[i] = instance_create(14 + (124 * (i mod 2)), 30 + (10 * (i div 2)), o_btn_server_sync);
    inst_sync[i].inst_num = i;
}

//create audio toggle button
instance_create(48, 69, o_chk_server_audio);

//set timer for keep-alive packets
alarm[0] = 1800;

//set timer for location updates
alarm[1] = 15;

