//globals
global.version = "4.45"; //zhelper version
global.hotkeys_zh_version = 4; //version number to warn users if hotkeys may have changed
global.win_scale = 2; //the scale of the main window
global.playername = ""; //the player's name
global.playercolor = c_white; //the player's color
global.show_outline = 1; //whether or not to outline the selected grid cell
global.show_indicators = 1; //whether or not to show player indicators and coords
global.inst_ctrl_main = self.id; // controller's instance id
global.dgn_finder_delay = 5; //delay between dungeon finder updates
global.ow_coord_style = 0; //0 = hex, 1 = decimal with letter
global.do_load = 0; //tells the tracker controller to load saved data on start
global.update_available = 0; //flag for whether an update is avilable or not
global.update_ver = ""; //version from the update.txt file
global.update_ignore_msg = 1; //flag so the first message from an update check is not shown
global.update_critical = 0; //flag set for important updates
global.update_changes = ""; //update changelog
global.update_failed = 0; //flag set if update check or update fails
global.is_yyc_build = code_is_compiled(); //flag to tell whether this is a YYC build or not
global.hotkeys_enable = 0; //whether hotkeys are enabled
global.hotkeys_enable_global = 0; //whether global hotkeys are enabled
global.hotkeys_user_version = 0; //user's hotkeys version number
global.srf_owmap = -1; //placeholder surface for overworld mapper
global.srl_mode = 1; //whether srl mode is enabled (disables stuff that could be an advantage)
global.zh5_released = 0;
global.srl_warn_accepted = 0; //whether the user has clicked through the SRL warning or not.
global.dgn_item_style = 0; //default setting for below triforce icon type. 0 = hearts, 1 = item boxes
global.dgn_trans_level = 0.9; //translucency level of "hidden" dungeon room icons and doors

//rando globals
global.rando_seed = 0; //randomizer seed
global.rando_rom_in = ""; //input rom
global.rando_rom_good = 0; //correct size rom flag
global.rando_drops = 0; //drop table flag
global.rando_dgnrooms = 0; //ZRLR prefab randomizer flag
global.rando_burnbomb = 0; //burn/bomb flag
global.rando_lostpaths = 0; //lost paths flag
global.rando_owpaths = 0; //overworld path rando flag
global.rando_readdata = 0; //flag to check if rando data has been read already
global.rando_ow_pal_sel = 0; //overworld palette selection
global.rando_mus_type = 144; //square wave instrument selection

//server globals
global.inst_ctrl_server = -4; //server instance id
global.server_id = -1; //server id
global.server_port = 19950; //listen port
global.server_stream_delay = 1; //delay between packets when streaming sync data
global.server_audio_alerts = 1; //enable audible alerts in the server

//client netmode globals
global.net_playerid = -1; //the player's network client id
global.net_socketid = -1; //the player's network socket id
global.net_active = 0; //whether net mode is active or not
global.net_addr = ""; //ip to connect to
global.net_port = 19950; //port to connect to
global.net_buf_send = buffer_create(1300, buffer_fixed, 1); //client buffer for sending
global.net_buf_recv = -1; //receive buffer id

//init all async variables first thing since GM IS INCREDIBLY STUPID AND FIRES ASYNC
//EVENTS EVEN FOR NONEXISTENT OBJECTS!
global.dr_01 = -1;
global.dr_02 = -1;
global.dr_03 = -1;
global.dr_04 = -1;
global.dr_05 = -1;
global.dr_06 = -1;
global.dr_07 = -1;
global.dr_08 = -1;
global.dr_09 = -1;
global.dr_10 = -1;
global.dr_11 = -1;
global.dr_12 = -1;
global.dr_13 = -1;
global.dr_14 = -1;
global.dr_15 = -1;
global.dr_16 = -1;
global.dr_id = -1;
global.http_01 = -1;
global.http_02 = -1;
global.http_03 = -1;

//setup sprite font
global.fnt_mwtiny = font_add_sprite(s_fnt_mwtiny, 32, 0, 0);

//set window size/location
window_set_size(256 * global.win_scale, 208 * global.win_scale);
window_center();
if(global.is_yyc_build){
    window_set_caption("ZHelper " + global.version + "-YYC");
}
else{
    window_set_caption("ZHelper " + global.version);
}

//color scheme
global.c_txt_bright = c_white;
global.c_txt_mid = c_silver;
global.c_txt_dark = c_gray;

done = false;
done2 = false;

//hotkey/icon globals
for(i = 0; i < sprite_get_number(s_icon_overworld); i += 1){
    global.icon_enable_ow[i] = 1;
    global.icon_hotkey_ow[i] = -1;
}
for(i = 0; i < sprite_get_number(s_icon_dungeon); i += 1){
    global.icon_enable_dgn[i] = 1;
    global.icon_hotkey_dgn[i] = -1;
}
for(i = 0; i < sprite_get_number(s_btn_tr_dungeon_door_h); i += 1){
    global.icon_enable_door[i] = 1;
    global.icon_hotkey_door[i] = -1;
}

//NES palette definitions (only Nestopia YUV and FCEUX for now)
//WARNING: ALL PALETTES ARE DEFINED IN BGR ORDER, NOT RGB!!!
//Nestopia YUV
global.nes_pal[0, 0] = $666666;
global.nes_pal[0, 1] = $9A1E00;
global.nes_pal[0, 2] = $A8090E;
global.nes_pal[0, 3] = $930044;
global.nes_pal[0, 4] = $600071;
global.nes_pal[0, 5] = $1D0189;
global.nes_pal[0, 6] = $001386;
global.nes_pal[0, 7] = $002969;
global.nes_pal[0, 8] = $003E39;
global.nes_pal[0, 9] = $004C04;
global.nes_pal[0, 10] = $004F00;
global.nes_pal[0, 11] = $2B4700;
global.nes_pal[0, 12] = $6C3500;
global.nes_pal[0, 13] = $000000;
global.nes_pal[0, 14] = $000000;
global.nes_pal[0, 15] = $000000;
global.nes_pal[0, 16] = $ADADAD;
global.nes_pal[0, 17] = $F15000;
global.nes_pal[0, 18] = $FF343B;
global.nes_pal[0, 19] = $E82280;
global.nes_pal[0, 20] = $A51EBB;
global.nes_pal[0, 21] = $4E29DB;
global.nes_pal[0, 22] = $0040D7;
global.nes_pal[0, 23] = $005EB1;
global.nes_pal[0, 24] = $007973;
global.nes_pal[0, 25] = $008B2D;
global.nes_pal[0, 26] = $088F00;
global.nes_pal[0, 27] = $608400;
global.nes_pal[0, 28] = $B56D00;
global.nes_pal[0, 29] = $000000;
global.nes_pal[0, 30] = $000000;
global.nes_pal[0, 31] = $000000;
global.nes_pal[0, 32] = $FFFFFF;
global.nes_pal[0, 33] = $FFA04B;
global.nes_pal[0, 34] = $FF848A;
global.nes_pal[0, 35] = $FF72D1;
global.nes_pal[0, 36] = $F76DFF;
global.nes_pal[0, 37] = $9E79FF;
global.nes_pal[0, 38] = $4790FF;
global.nes_pal[0, 39] = $0AAEFF;
global.nes_pal[0, 40] = $00CAC4;
global.nes_pal[0, 41] = $13DC7D;
global.nes_pal[0, 42] = $57E141;
global.nes_pal[0, 43] = $B0D521;
global.nes_pal[0, 44] = $FFBE25;
global.nes_pal[0, 45] = $4F4F4F;
global.nes_pal[0, 46] = $000000;
global.nes_pal[0, 47] = $000000;
global.nes_pal[0, 48] = $FFFFFF;
global.nes_pal[0, 49] = $FFD8B6;
global.nes_pal[0, 50] = $FFCDD0;
global.nes_pal[0, 51] = $FFC6ED;
global.nes_pal[0, 52] = $FCC4FF;
global.nes_pal[0, 53] = $D8C8FF;
global.nes_pal[0, 54] = $B4D2FF;
global.nes_pal[0, 55] = $9CDEFF;
global.nes_pal[0, 56] = $94E9E7;
global.nes_pal[0, 57] = $9FF1CA;
global.nes_pal[0, 58] = $BBF3B2;
global.nes_pal[0, 59] = $DFEEA5;
global.nes_pal[0, 60] = $FFE5A6;
global.nes_pal[0, 61] = $B8B8B8;
global.nes_pal[0, 62] = $000000;
global.nes_pal[0, 63] = $000000;

//FCEUX
global.nes_pal[1, 0] = $747474;
global.nes_pal[1, 1] = $8C1824;
global.nes_pal[1, 2] = $A80000;
global.nes_pal[1, 3] = $9C0044;
global.nes_pal[1, 4] = $74008C;
global.nes_pal[1, 5] = $1000A8;
global.nes_pal[1, 6] = $0000A4;
global.nes_pal[1, 7] = $00087C;
global.nes_pal[1, 8] = $002C40;
global.nes_pal[1, 9] = $004400;
global.nes_pal[1, 10] = $005000;
global.nes_pal[1, 11] = $143C00;
global.nes_pal[1, 12] = $5C3C18;
global.nes_pal[1, 13] = $000000;
global.nes_pal[1, 14] = $000000;
global.nes_pal[1, 15] = $000000;
global.nes_pal[1, 16] = $BCBCBC;
global.nes_pal[1, 17] = $EC7000;
global.nes_pal[1, 18] = $EC3820;
global.nes_pal[1, 19] = $F00080;
global.nes_pal[1, 20] = $BC00BC;
global.nes_pal[1, 21] = $5800E4;
global.nes_pal[1, 22] = $0028D8;
global.nes_pal[1, 23] = $0C4CC8;
global.nes_pal[1, 24] = $007088;
global.nes_pal[1, 25] = $009400;
global.nes_pal[1, 26] = $00A800;
global.nes_pal[1, 27] = $389000;
global.nes_pal[1, 28] = $888000;
global.nes_pal[1, 29] = $000000;
global.nes_pal[1, 30] = $000000;
global.nes_pal[1, 31] = $000000;
global.nes_pal[1, 32] = $FCFCFC;
global.nes_pal[1, 33] = $FCBC3C;
global.nes_pal[1, 34] = $FC945C;
global.nes_pal[1, 35] = $FC88CC;
global.nes_pal[1, 36] = $FC78F4;
global.nes_pal[1, 37] = $B474FC;
global.nes_pal[1, 38] = $6074FC;
global.nes_pal[1, 39] = $3898FC;
global.nes_pal[1, 40] = $3CBCF0;
global.nes_pal[1, 41] = $10D080;
global.nes_pal[1, 42] = $48DC4C;
global.nes_pal[1, 43] = $98F858;
global.nes_pal[1, 44] = $D8E800;
global.nes_pal[1, 45] = $787878;
global.nes_pal[1, 46] = $000000;
global.nes_pal[1, 47] = $000000;
global.nes_pal[1, 48] = $FCFCFC;
global.nes_pal[1, 49] = $FCE4A8;
global.nes_pal[1, 50] = $FCD4C4;
global.nes_pal[1, 51] = $FCC8D4;
global.nes_pal[1, 52] = $FCC4FC;
global.nes_pal[1, 53] = $D8C4FC;
global.nes_pal[1, 54] = $B0BCFC;
global.nes_pal[1, 55] = $A8D8FC;
global.nes_pal[1, 56] = $A0E4FC;
global.nes_pal[1, 57] = $A0FCE0;
global.nes_pal[1, 58] = $BCF0A8;
global.nes_pal[1, 59] = $CCFCB0;
global.nes_pal[1, 60] = $F0FC9C;
global.nes_pal[1, 61] = $C4C4C4;
global.nes_pal[1, 62] = $000000;
global.nes_pal[1, 63] = $000000;

//load custom GFX
zh_load_custom_gfx();

//show SRL warning
//show_message_async("WARNING!#============================================#Due to recent discussions on the ZeldaOne Discord server, ZHelper, along with other digital trackers, may soon be either partially or fully disallowed during races on SpeedRunsLive. If you're just planning on using this program for casual runs, you can safely ignore this message. If you plan on racing, please use this program at your own risk and follow whatever rules happen to come into play. See the general channel on the ZeldaOne Discord for more details.");

//screenread dll stuff
global.getemuhandle = external_define("screenread.dll", "GetEmuHandleFromPoint", dll_stdcall, ty_real, 2, ty_real, ty_real);
global.getemutype = external_define("screenread.dll", "GetEmuType", dll_stdcall, ty_real, 1, ty_real);
global.initemuscreen = external_define("screenread.dll", "InitEmuScreen", dll_stdcall, ty_real, 1, ty_real);
global.updateemuscreen = external_define("screenread.dll", "UpdateEmuScreen", dll_stdcall, ty_real, 1, ty_real);
global.destroyemuscreen = external_define("screenread.dll", "DestroyEmuScreen", dll_stdcall, ty_real, 1, ty_real);
global.getemupixel = external_define("screenread.dll", "GetEmuPixel", dll_stdcall, ty_real, 3, ty_real, ty_real, ty_real);
global.sr_init = 0;
global.sr_col = -1.0;
global.sr_handle = -1.0;

//enable debug overlay for monitoring draw calls and texture batches
//show_debug_overlay(1);

