//mark valid dungeon number buttons based on marked screens
if(process && global.curr_map != 0 && global.curr_map < 10){
    for(i = 0; i < 18; i += 1){
        dgn_valid[i] = 1;
    }
    for(i = 0; i < 64; i += 1){
        for(j = 0; j < 18; j += 1){
            if(dgn_valid[j]){
                if((ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + i) != 0) && (global.dgn_layouts[((j + 1) * 64) + i] != 1)){
                    dgn_valid[j] = 0;
                }
            }
        }
    }

    //highlight dungeon buttons
    for(i = 0; i < 18; i += 1){
        if(dgn_valid[i]){
            global.inst_ctrl_tracker.inst_dgn_num[i].image_blend = c_white;
        }
        else{
            if(global.srl_mode){
                global.inst_ctrl_tracker.inst_dgn_num[i].image_blend = c_white;
            }
            else{
                global.inst_ctrl_tracker.inst_dgn_num[i].image_blend = make_color_rgb(255, 128, 128);
            }
        }
    }
    
    //check for potential wrap-around for dungeon map shifting
    wrap_detected_r = false;
    wrap_detected_u = false;
    wrap_detected_l = false;
    wrap_detected_d = false;
    //right
    //check start position
    if(ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) mod 8 == 7){
        wrap_detected_r = true;
    }
    //check icons
    for(i = 0; i < 8; i++){
        if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + 7 + (i * 8)) != 0){
            wrap_detected_r = true;
        }
    }
    //check markers
    for(i = 0; i < 8; i++){
        for(j = 0; j < 8; j++){
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + (64 * j) + 7 + (i * 8)) != 0){
                wrap_detected_r = true;
            }
        }
    }
    //check horizontal doors
    for(i = 0; i < 8; i++){
        if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_doors_h, 0, (56 * (global.curr_map - 1)) + 6 + (i * 7))){
            wrap_detected_r = true;
        }
    }
    //check vertical doors
    for(i = 0; i < 7; i++){
        if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_doors_v, 0, (56 * (global.curr_map - 1)) + 7 + (i * 8))){
            wrap_detected_r = true;
        }
    }
    //up
    //check start position
    if(ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) >= 0 && ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) < 8){
        wrap_detected_u = true;
    }
    //check icons
    for(i = 0; i < 8; i++){
        if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + i) != 0){
            wrap_detected_u = true;
        }
    }
    //check markers
    for(i = 0; i < 8; i++){
        for(j = 0; j < 8; j++){
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + (64 * j) + i) != 0){
                wrap_detected_u = true;
            }
        }
    }
    //check horizontal doors
    for(i = 0; i < 7; i++){
        if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_doors_h, 0, (56 * (global.curr_map - 1)) + i)){
            wrap_detected_u = true;
        }
    }
    //check vertical doors
    for(i = 0; i < 8; i++){
        if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_doors_v, 0, (56 * (global.curr_map - 1)) + i)){
            wrap_detected_u = true;
        }
    }
    //left
    //check start position
    if(ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) mod 8 == 0){
        wrap_detected_l = true;
    }
    //check icons
    for(i = 0; i < 8; i++){
        if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + (i * 8)) != 0){
            wrap_detected_l = true;
        }
    }
    //check markers
    for(i = 0; i < 8; i++){
        for(j = 0; j < 8; j++){
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + (64 * j) + (i * 8)) != 0){
                wrap_detected_l = true;
            }
        }
    }
    //check horizontal doors
    for(i = 0; i < 8; i++){
        if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_doors_h, 0, (56 * (global.curr_map - 1)) + (i * 7))){
            wrap_detected_l = true;
        }
    }
    //check vertical doors
    for(i = 0; i < 7; i++){
        if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_doors_v, 0, (56 * (global.curr_map - 1)) + (i * 8))){
            wrap_detected_l = true;
        }
    }
    //down
    //check start position
    if(ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) >= 56){
        wrap_detected_d = true;
    }
    //check icons
    for(i = 0; i < 8; i++){
        if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + 56 + i) != 0){
            wrap_detected_d = true;
        }
    }
    //check markers
    for(i = 0; i < 8; i++){
        for(j = 0; j < 8; j++){
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + (64 * j) + 56 + i) != 0){
                wrap_detected_d = true;
            }
        }
    }
    //check horizontal doors
    for(i = 0; i < 7; i++){
        if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_doors_h, 0, (56 * (global.curr_map - 1)) + 49 + i)){
            wrap_detected_d = true;
        }
    }
    //check vertical doors
    for(i = 0; i < 8; i++){
        if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_doors_v, 0, (56 * (global.curr_map - 1)) + 48 + i)){
            wrap_detected_d = true;
        }
    }
    
    //make sure we dont process again until alarm resets flag
    process = false;
    alarm[0] = global.dgn_finder_delay;
}

