var icon_copy, door_h_copy, door_v_copy, marker_copy
var wrap_detected = false
var i, j

if(global.curr_map != 0 && global.curr_map < 10){
    //bail if network is active, or if auto-tracking is on
    if(global.net_active){
        //Getting this to work while classic dungeon maps are a thing would be HELL!
        //Its not worth the hassle because of the auto-syncing for both map types on the server.
        global.alert_msg = "Can't shift dungeons in network mode! Blame classic maps :(";
        global.alert_show = 1;
        global.inst_ctrl_tracker.alarm[2] = global.alert_time;
        exit;
    }
    if(global.track_auto){
        global.alert_msg = "Function disabled while auto-tracking is active!";
        global.alert_show = 1;
        global.inst_ctrl_tracker.alarm[2] = global.alert_time;
        exit;
    }
    
    //check for potential wrap-around and error if it would happen
    if(inst_num == 0){ //right
        //check start position
        if(ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) mod 8 == 7){
            wrap_detected = true;
        }
        //check icons
        for(i = 0; i < 8; i++){
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + 7 + (i * 8)) != 0){
                wrap_detected = true;
            }
        }
        //check markers
        for(i = 0; i < 8; i++){
            for(j = 0; j < 8; j++){
                if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + (64 * j) + 7 + (i * 8)) != 0){
                    wrap_detected = true;
                }
            }
        }
        //check horizontal doors
        for(i = 0; i < 8; i++){
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_doors_h, 0, (56 * (global.curr_map - 1)) + 6 + (i * 7))){
                wrap_detected = true;
            }
        }
        //check vertical doors
        for(i = 0; i < 7; i++){
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_doors_v, 0, (56 * (global.curr_map - 1)) + 7 + (i * 8))){
                wrap_detected = true;
            }
        }
    }
    if(inst_num == 1){ //up
        //check start position
        if(ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) >= 0 && ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) < 8){
            wrap_detected = true;
        }
        //check icons
        for(i = 0; i < 8; i++){
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + i) != 0){
                wrap_detected = true;
            }
        }
        //check markers
        for(i = 0; i < 8; i++){
            for(j = 0; j < 8; j++){
                if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + (64 * j) + i) != 0){
                    wrap_detected = true;
                }
            }
        }
        //check horizontal doors
        for(i = 0; i < 7; i++){
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_doors_h, 0, (56 * (global.curr_map - 1)) + i)){
                wrap_detected = true;
            }
        }
        //check vertical doors
        for(i = 0; i < 8; i++){
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_doors_v, 0, (56 * (global.curr_map - 1)) + i)){
                wrap_detected = true;
            }
        }
    }
    if(inst_num == 2){ //left
        //check start position
        if(ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) mod 8 == 0){
            wrap_detected = true;
        }
        //check icons
        for(i = 0; i < 8; i++){
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + (i * 8)) != 0){
                wrap_detected = true;
            }
        }
        //check markers
        for(i = 0; i < 8; i++){
            for(j = 0; j < 8; j++){
                if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + (64 * j) + (i * 8)) != 0){
                    wrap_detected = true;
                }
            }
        }
        //check horizontal doors
        for(i = 0; i < 8; i++){
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_doors_h, 0, (56 * (global.curr_map - 1)) + (i * 7))){
                wrap_detected = true;
            }
        }
        //check vertical doors
        for(i = 0; i < 7; i++){
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_doors_v, 0, (56 * (global.curr_map - 1)) + (i * 8))){
                wrap_detected = true;
            }
        }
    }
    if(inst_num == 3){ //down
        //check start position
        if(ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) >= 56){
            wrap_detected = true;
        }
        //check icons
        for(i = 0; i < 8; i++){
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + 56 + i) != 0){
                wrap_detected = true;
            }
        }
        //check markers
        for(i = 0; i < 8; i++){
            for(j = 0; j < 8; j++){
                if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + (64 * j) + 56 + i) != 0){
                    wrap_detected = true;
                }
            }
        }
        //check horizontal doors
        for(i = 0; i < 7; i++){
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_doors_h, 0, (56 * (global.curr_map - 1)) + 49 + i)){
                wrap_detected = true;
            }
        }
        //check vertical doors
        for(i = 0; i < 8; i++){
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_doors_v, 0, (56 * (global.curr_map - 1)) + 48 + i)){
                wrap_detected = true;
            }
        }
    }
    if(wrap_detected){
        global.alert_msg = "Map shift failed! Wrap-around is not possible.";
        global.alert_show = 1;
        global.inst_ctrl_tracker.alarm[2] = global.alert_time;
        exit;
    }
    else{
        //get a copy of current map data
        icon_copy = ds_grid_create(1, 576);
        marker_copy = ds_grid_create(1, 4608);
        door_h_copy = ds_grid_create(1, 504);
        door_v_copy = ds_grid_create(1, 504);
        ds_grid_copy(icon_copy, global.inst_ctrl_tracker.grd_dgn_icons);
        ds_grid_copy(marker_copy, global.inst_ctrl_tracker.grd_dgn_icons_marker);
        ds_grid_copy(door_h_copy, global.inst_ctrl_tracker.grd_dgn_doors_h);
        ds_grid_copy(door_v_copy, global.inst_ctrl_tracker.grd_dgn_doors_v);
        
        //perform map shifting
        if(inst_num == 0){ //right
            //start position
            if(ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) != -1){
                ds_grid_set(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map, ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) + 1);
            }
            //icons
            for(i = 0; i < 64; i++){
                if(i mod 8 == 0){
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + i, 0);
                }
                else{
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + i, ds_grid_get(icon_copy, 0, (64 * (global.curr_map - 1)) + i - 1));
                }
            }
            //markers
            for(i = 0; i < 64; i++){
                for(j = 0; j < 8; j++){
                    if(i mod 8 == 0){
                        ds_grid_set(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + (64 * j) + i, 0);
                    }
                    else{
                        ds_grid_set(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + (64 * j) + i, ds_grid_get(marker_copy, 0, (512 * (global.curr_map - 1)) + (64 * j) + i - 1));
                    }
                }
            }
            //horizontal doors
            for(i = 0; i < 56; i++){
                if(i mod 7 == 0){
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_doors_h, 0, (56 * (global.curr_map - 1)) + i, 0);
                }
                else{
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_doors_h, 0, (56 * (global.curr_map - 1)) + i, ds_grid_get(door_h_copy, 0, (56 * (global.curr_map - 1)) + i - 1));
                }
            }
            //vertical doors
            for(i = 0; i < 56; i++){
                if(i mod 8 == 0){
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_doors_v, 0, (56 * (global.curr_map - 1)) + i, 0);
                }
                else{
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_doors_v, 0, (56 * (global.curr_map - 1)) + i, ds_grid_get(door_v_copy, 0, (56 * (global.curr_map - 1)) + i - 1));
                }
            }
        }
        if(inst_num == 1){ //up
            //start position
            if(ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) != -1){
                ds_grid_set(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map, ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) - 8);
            }
            //icons
            for(i = 0; i < 64; i++){
                if(i >= 56){
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + i, 0);
                }
                else{
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + i, ds_grid_get(icon_copy, 0, (64 * (global.curr_map - 1)) + i + 8));
                }
            }
            //markers
            for(i = 0; i < 64; i++){
                for(j = 0; j < 8; j++){
                    if(i >= 56){
                        ds_grid_set(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + (64 * j) + i, 0);
                    }
                    else{
                        ds_grid_set(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + (64 * j) + i, ds_grid_get(marker_copy, 0, (512 * (global.curr_map - 1)) + (64 * j) + i + 8));
                    }
                }
            }
            //horizontal doors
            for(i = 0; i < 56; i++){
                if(i >= 49){
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_doors_h, 0, (56 * (global.curr_map - 1)) + i, 0);
                }
                else{
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_doors_h, 0, (56 * (global.curr_map - 1)) + i, ds_grid_get(door_h_copy, 0, (56 * (global.curr_map - 1)) + i + 7));
                }
            }
            //vertical doors
            for(i = 0; i < 56; i++){
                if(i >= 48){
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_doors_v, 0, (56 * (global.curr_map - 1)) + i, 0);
                }
                else{
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_doors_v, 0, (56 * (global.curr_map - 1)) + i, ds_grid_get(door_v_copy, 0, (56 * (global.curr_map - 1)) + i + 8));
                }
            }
        }
        if(inst_num == 2){ //left
            //start position
            if(ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) != -1){
                ds_grid_set(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map, ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) - 1);
            }
            //icons
            for(i = 0; i < 64; i++){
                if(i mod 8 == 7){
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + i, 0);
                }
                else{
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + i, ds_grid_get(icon_copy, 0, (64 * (global.curr_map - 1)) + i + 1));
                }
            }
            //markers
            for(i = 0; i < 64; i++){
                for(j = 0; j < 8; j++){
                    if(i mod 8 == 7){
                        ds_grid_set(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + (64 * j) + i, 0);
                    }
                    else{
                        ds_grid_set(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + (64 * j) + i, ds_grid_get(marker_copy, 0, (512 * (global.curr_map - 1)) + (64 * j) + i + 1));
                    }
                }
            }
            //horizontal doors
            for(i = 0; i < 56; i++){
                if(i mod 7 == 6){
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_doors_h, 0, (56 * (global.curr_map - 1)) + i, 0);
                }
                else{
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_doors_h, 0, (56 * (global.curr_map - 1)) + i, ds_grid_get(door_h_copy, 0, (56 * (global.curr_map - 1)) + i + 1));
                }
            }
            //vertical doors
            for(i = 0; i < 56; i++){
                if(i mod 8 == 7){
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_doors_v, 0, (56 * (global.curr_map - 1)) + i, 0);
                }
                else{
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_doors_v, 0, (56 * (global.curr_map - 1)) + i, ds_grid_get(door_v_copy, 0, (56 * (global.curr_map - 1)) + i + 1));
                }
            }
        }
        if(inst_num == 3){ //down
            //start position
            if(ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) != -1){
                ds_grid_set(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map, ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) + 8);
            }
            //icons
            for(i = 0; i < 64; i++){
                if(i < 8){
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + i, 0);
                }
                else{
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + i, ds_grid_get(icon_copy, 0, (64 * (global.curr_map - 1)) + i - 8));
                }
            }
            //markers
            for(i = 0; i < 64; i++){
                for(j = 0; j < 8; j++){
                    if(i < 8){
                        ds_grid_set(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + (64 * j) + i, 0);
                    }
                    else{
                        ds_grid_set(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + (64 * j) + i, ds_grid_get(marker_copy, 0, (512 * (global.curr_map - 1)) + (64 * j) + i - 8));
                    }
                }
            }
            //horizontal doors
            for(i = 0; i < 56; i++){
                if(i < 7){
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_doors_h, 0, (56 * (global.curr_map - 1)) + i, 0);
                }
                else{
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_doors_h, 0, (56 * (global.curr_map - 1)) + i, ds_grid_get(door_h_copy, 0, (56 * (global.curr_map - 1)) + i - 7));
                }
            }
            //vertical doors
            for(i = 0; i < 56; i++){
                if(i < 8){
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_doors_v, 0, (56 * (global.curr_map - 1)) + i, 0);
                }
                else{
                    ds_grid_set(global.inst_ctrl_tracker.grd_dgn_doors_v, 0, (56 * (global.curr_map - 1)) + i, ds_grid_get(door_v_copy, 0, (56 * (global.curr_map - 1)) + i - 8));
                }
            }
        }
        
        //destroy data copies to prevent memory leaks
        ds_grid_destroy(icon_copy);
        ds_grid_destroy(marker_copy);
        ds_grid_destroy(door_h_copy);
        ds_grid_destroy(door_v_copy);
        
        //save layout
        global.inst_ctrl_tracker.alarm[0] = global.autosave_time;
    }
}

