var transparent;
if(global.curr_map != 0 && global.curr_map < 10){
    transparent = 0;
    
    //auto-determine cell highlights based on the layout image. shortcuts ftw :)
    if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + cell_num) == 0){
        temp_num = ds_grid_get(global.inst_ctrl_tracker.grd_dgn_nums, 0, global.curr_map - 1);
        if(temp_num == -1){
            temp_num = 0;
        }
        else{
            temp_num += 1;
        }
        if(global.dgn_layouts[(64 * temp_num) + cell_num]){
            image_single = 1; //highlighted, no icon
            transparent = 0;
        }
        else{
            image_single = 0; //empty, no icon
            if(global.dgn_transparency){
                transparent = 1;
            }
        }
    }
    else{
        image_single = 2; //has an active icon
        transparent = 0;
    }
    
    draw_sprite_ext(s_btn_tr_dungeon_cell, image_single, x, y, 1, 1, 0, ds_grid_get(global.inst_ctrl_tracker.grd_dgn_colors, 0, global.curr_map - 1), 1 - (global.dgn_trans_level * transparent));
    
    //draw icon
    if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + cell_num) != 0){
        draw_sprite(s_icon_dungeon, ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons, 0, (64 * (global.curr_map - 1)) + cell_num), x + 1, y + 1);
    }

    //draw player indicators
    if(global.show_indicators){
        //self
        if(global.net_playerid != -1){
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + (64 * global.net_playerid) + cell_num) == 1){
                draw_set_color(global.playercolor);
                draw_rectangle(x, y - 2, x + 3, y - 1, 0);
                draw_rectangle(x + 9,y - 2, x + 12, y - 1, 0);
            }
        
            //others
            for(j = 0; j < 8; j += 1){ 
                if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + cell_num + (64 * j)) == 1){
                    draw_set_color(make_color_hsv(color_get_hue(global.playercolors[j]), color_get_saturation(global.playercolors[j]), color_get_value(global.playercolors[j]) * 0.75));
                    if(j < 4){
                        draw_line(x + j,y - 6, x + j, y - 3);
                    }
                    else{
                        draw_line(x + 5 + j,y - 6, x + 5 + j, y - 3);
                    }
                }
            }
        }
        else{
            if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + cell_num) == 1){
                draw_set_color(global.playercolor);
                draw_rectangle(x, y - 2, x + 3, y - 1, 0);
                draw_rectangle(x + 9,y - 2, x + 12, y - 1, 0);
            }
        
            //others
            for(j = 0; j < 8; j += 1){ 
                if(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_icons_marker, 0, (512 * (global.curr_map - 1)) + cell_num + (64 * j)) == 1){
                    draw_set_color(make_color_hsv(color_get_hue(global.playercolors[j]), color_get_saturation(global.playercolors[j]), color_get_value(global.playercolors[j]) * 0.75));
                    if(j < 4){
                        draw_line(x + j,y - 6, x + j, y - 3);
                    }
                    else{
                        draw_line(x + 5 + j,y - 6, x + 5 + j, y - 3);
                    }
                }
            }
        }
    }

    //draw player location indicators if auto-tracking is enabled
    if(global.show_indicators){
        if(global.net_active){
            for(i = 0; i < 8; i++){
                if(i != global.net_playerid && global.playerdgnpos[i] < 64 && cell_num == global.playerdgnpos[i] && global.playerdgnmap[i] == global.curr_map - 1){
                    if(global.playermaptype[i] == 2){
                        draw_sprite_ext(s_outline_tr_playerloc_outer_dgn, 0, ((global.playerdgnpos[i] mod 8) * 18) - 5, 48 + ((global.playerdgnpos[i] div 8) * 14), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolors[i]), color_get_saturation(global.playercolors[i]), 255), 0.66 - (abs(sin(anim_cycle)) * 0.65));
                        draw_sprite_ext(s_outline_tr_playerloc_dgn, 0, ((global.playerdgnpos[i] mod 8) * 18), 53 + ((global.playerdgnpos[i] div 8) * 14), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolors[i]), color_get_saturation(global.playercolors[i]), 255 - (abs(sin(anim_cycle)) * 80)), 1.0);
                    }
                }
            }
            if(global.net_playerid != -1 && global.playerdgnpos[global.net_playerid] < 64 && cell_num == global.playerdgnpos[global.net_playerid] && global.playerdgnmap[global.net_playerid] == global.curr_map - 1){
                if(global.playermaptype[global.net_playerid] == 2){
                    draw_sprite_ext(s_outline_tr_playerloc_outer_dgn, 1, ((global.playerdgnpos[global.net_playerid] mod 8) * 18) - 5, 48 + ((global.playerdgnpos[global.net_playerid] div 8) * 14), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255), 0.66 - (abs(sin(anim_cycle)) * 0.65));
                    draw_sprite_ext(s_outline_tr_playerloc_dgn, 0, ((global.playerdgnpos[global.net_playerid] mod 8) * 18), 53 + ((global.playerdgnpos[global.net_playerid] div 8) * 14), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255 - (abs(sin(anim_cycle)) * 80)), 1.0);
                }
            }
        }
        else{
            if(global.playermaptype[0] == 2 && global.playerdgnpos[0] == cell_num && global.playerdgnmap[0] == global.curr_map - 1){
                draw_sprite_ext(s_outline_tr_playerloc_outer_dgn, 1, ((global.playerdgnpos[0] mod 8) * 18) - 5, 48 + ((global.playerdgnpos[0] div 8) * 14), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255), 0.66 - (abs(sin(anim_cycle)) * 0.65));
                draw_sprite_ext(s_outline_tr_playerloc_dgn, 0, ((global.playerdgnpos[0] mod 8) * 18), 53 + ((global.playerdgnpos[0] div 8) * 14), 1, 1, 0, make_color_hsv(color_get_hue(global.playercolor), color_get_saturation(global.playercolor), 255 - (abs(sin(anim_cycle)) * 80)), 1.0);
            }
        }
    }
    
    //draw start screen overlay
    if(ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.curr_map) == cell_num){
        draw_sprite(s_outline_startscreen_dgn, 0, x, y);
    }

    //draw outline under cursor if enabled
    if(global.show_outline && mouse_x >= x && mouse_y >= y && mouse_x < x + 13 && mouse_y < y + 9){
        draw_set_color(ds_grid_get(global.inst_ctrl_tracker.grd_dgn_colors, 0, global.curr_map - 1));
        draw_rectangle(x, y, x + 12, y + 8, 1);
    }
}

//increment animation counter
anim_cycle += pi / 60;
if(anim_cycle > pi * 2){
  anim_cycle = 0;
}

