var pal_temp;

if(!global.srl_mode){
    image_single = global.track_auto;
    if (global.sr_init && global.track_auto){
        image_blend = c_lime;
    }
    else{
        image_blend = c_white;
    }
    
    draw_sprite_ext(s_btn_tr_auto, global.track_auto, x, y, 1, 1, 0, image_blend, 1);
    
    
    if(global.sr_init && global.track_auto){
        //update auto-tracker
        emutype = floor(external_call(global.getemutype, global.sr_handle)); //check emu type
        if(emutype == 0){emutype = 1;}
        else if(emutype == 1){emutype = 0;}
        
        if(emutype == 0 || emutype == 1){
            if(floor(external_call(global.getemupixel, global.sr_handle, 0, 0)) != global.nes_pal[emutype, 0]){ //check for bomb flash, skip if found
                //check subscreen offset
                offset = 0;
                good = 0;
                do{
                    if(floor(external_call(global.getemupixel, global.sr_handle, AUTO_OFFSET_X, AUTO_OFFSET_Y + offset)) == global.nes_pal[emutype, 22]){
                        good = 1;
                    }
                    else{offset += 1;}
                } until(good || offset > 176);
                //if(good){offset--;} //workaround due to DUMB GM as usual!
                
                if(offset <= 176 && good){ //in game (hopefully)
                    //offset++; //STUPID ASS GM! DON'T ASK ME WHY THIS WORKS BUT IT DOES!
                    pal_temp = floor(external_call(global.getemupixel, global.sr_handle, 16, 16 + offset));
                    if(pal_temp == global.nes_pal[emutype, 0]){ //check for overworld grid bg
                        //on overworld, find link's position
                        for(i = 0; i < 128; i++){
                            //giant if statement
                            if(floor(external_call(global.getemupixel, global.sr_handle, 17 + (4 * (i mod 16)), 16 + offset + (4 * floor(i / 16)))) != global.nes_pal[emutype, 0]
                            && floor(external_call(global.getemupixel, global.sr_handle, 18 + (4 * (i mod 16)), 16 + offset + (4 * floor(i / 16)))) != global.nes_pal[emutype, 0]
                            && floor(external_call(global.getemupixel, global.sr_handle, 19 + (4 * (i mod 16)), 16 + offset + (4 * floor(i / 16)))) != global.nes_pal[emutype, 0]
                            && floor(external_call(global.getemupixel, global.sr_handle, 17 + (4 * (i mod 16)), 17 + offset + (4 * floor(i / 16)))) != global.nes_pal[emutype, 0]
                            && floor(external_call(global.getemupixel, global.sr_handle, 18 + (4 * (i mod 16)), 17 + offset + (4 * floor(i / 16)))) != global.nes_pal[emutype, 0]
                            && floor(external_call(global.getemupixel, global.sr_handle, 19 + (4 * (i mod 16)), 17 + offset + (4 * floor(i / 16)))) != global.nes_pal[emutype, 0]
                            && floor(external_call(global.getemupixel, global.sr_handle, 17 + (4 * (i mod 16)), 18 + offset + (4 * floor(i / 16)))) != global.nes_pal[emutype, 0]
                            && floor(external_call(global.getemupixel, global.sr_handle, 18 + (4 * (i mod 16)), 18 + offset + (4 * floor(i / 16)))) != global.nes_pal[emutype, 0]
                            && floor(external_call(global.getemupixel, global.sr_handle, 19 + (4 * (i mod 16)), 18 + offset + (4 * floor(i / 16)))) != global.nes_pal[emutype, 0]
                            && floor(external_call(global.getemupixel, global.sr_handle, 17 + (4 * (i mod 16)), 19 + offset + (4 * floor(i / 16)))) == global.nes_pal[emutype, 0]
                            && floor(external_call(global.getemupixel, global.sr_handle, 18 + (4 * (i mod 16)), 19 + offset + (4 * floor(i / 16)))) == global.nes_pal[emutype, 0]
                            && floor(external_call(global.getemupixel, global.sr_handle, 19 + (4 * (i mod 16)), 19 + offset + (4 * floor(i / 16)))) == global.nes_pal[emutype, 0])
                            {
                                screen = i;
                                if(on_type != 1){ //just switched to overworld, change map
                                    on_type = 1;
                                }
                                break;
                            }
                        }
                        
                        //make screencap if screen switched
                        if(screen != screen_prev && offset == 1){ //gotta use offset 1 even though its obviously incorrect, blame GM!
                            screen_prev = screen;
                            surface_set_target(global.srf_owmap);
                            for(i = 0; i < 16; i++){
                                for(j = 0; j < 11; j++){
                                    if(j != 10){
                                        col_f_r = 0;
                                        col_f_g = 0;
                                        col_f_b = 0;
                                        for(k = 0; k < 8; k++){
                                            for(l = 0; l < 8; l++){
                                                col = floor(external_call(global.getemupixel, global.sr_handle, (i * 16) + (k * 2), 58 + (j * 16) + (l * 2)));
                                                col_f_r += color_get_red(col);
                                                col_f_g += color_get_green(col);
                                                col_f_b += color_get_blue(col);
                                            }
                                        }
                                        col_f_r = col_f_r / 64;
                                        col_f_g = col_f_g / 64;
                                        col_f_b = col_f_b / 64;
                                    }
                                    else{
                                        col_f_r = 0;
                                        col_f_g = 0;
                                        col_f_b = 0;
                                        for(k = 0; k < 8; k++){
                                            for(l = 0; l < 4; l++){
                                                col = floor(external_call(global.getemupixel, global.sr_handle, (i * 16) + (k * 2), 58 + (j * 16) + (l * 2)));
                                                col_f_r += color_get_red(col);
                                                col_f_g += color_get_green(col);
                                                col_f_b += color_get_blue(col);
                                            }
                                        }
                                        col_f_r = col_f_r / 32;
                                        col_f_g = col_f_g / 32;
                                        col_f_b = col_f_b / 32;
                                    }
                                    col_f = make_color_rgb(col_f_r, col_f_g, col_f_b);
                                    draw_set_color(col_f);
                                    draw_point((16 * (screen mod 16)) + i, (11 * (screen div 16)) + j);
                                }
                            }
                            surface_reset_target();
                        }
                    }
                    else if(pal_temp == global.nes_pal[emutype, 15] || pal_temp == global.nes_pal[emutype, 18]){ //dungeon
                        if(on_type != 2){ //just switched to dungeon, set dungeon parameters and figure out which map it is
                            on_type = 2;
                            done = 0;
                        }
                        
                        if(!done){
                            //get link positions (there's two because of the compass)
                            dgn_scr[0] = -1;
                            dgn_scr[1] = -1;
                            dgn_scrs_found = 0;
                            for(i = 56; i < 64; i++){ //only check bottom row since that's the only place Link can start
                                pal_temp = floor(external_call(global.getemupixel, global.sr_handle, 18 + (8 * (i mod 8)), 16 + offset + (4 * (i div 8))));
                                if(pal_temp != global.nes_pal[emutype, 15] && pal_temp != global.nes_pal[emutype, 18]){
                                    if(dgn_scr[0] == -1){
                                        dgn_scr[0] = i;
                                        dgn_scrs_found = 1;
                                    }
                                    else if(dgn_scr[1] == -1){
                                        dgn_scr[1] = i;
                                        dgn_scrs_found = 2;
                                    }
                                }
                            }
                            
                            //figure out which map it is by colors and looking up
                            if(dgn_scrs_found != 0){
                                //get dungeon colors
                                dgn_col_temp[0] = floor(external_call(global.getemupixel, global.sr_handle, 1, 57)); //dark
                                dgn_col_temp[1] = floor(external_call(global.getemupixel, global.sr_handle, 0, 57)); //mid
                                dgn_col_temp[2] = floor(external_call(global.getemupixel, global.sr_handle, 2, 57)); //light
                                dgn_col_temp[3] = floor(external_call(global.getemupixel, global.sr_handle, 97, 138)); //water/statue
                                
                                for(i = 0; i < 9; i++){
                                    if(dgn_col_temp[0] == dgn_palettes[i * 4] && dgn_col_temp[1] == dgn_palettes[1 + (i * 4)] && dgn_col_temp[2] == dgn_palettes[2 + (i * 4)] && dgn_col_temp[3] == dgn_palettes[3 + (i * 4)]){
                                        if(dgn_scr[0] == dgn_scr_starts[i] || dgn_scr[1] == dgn_scr_starts[i] && !done){
                                            //this dungeon exists, set number and bail
                                            dgn_num = i;
                                            done = 1;
                                            break;
                                        }
                                    }
                                    else if(dgn_palettes[i * 4] == c_white && dgn_palettes[1 + (i * 4)] == c_white && dgn_palettes[2 + (i * 4)] == c_white && dgn_palettes[3 + (i * 4)] == c_white && !done){
                                        //doesn't exist, so set it and set number, then bail
                                        dgn_palettes[i * 4] = dgn_col_temp[0];
                                        dgn_palettes[1 + (i * 4)] = dgn_col_temp[1];
                                        dgn_palettes[2 + (i * 4)] = dgn_col_temp[2];
                                        dgn_palettes[3 + (i * 4)] = dgn_col_temp[3];
                                        dgn_num = i;
                                        
                                        //if its a new one, we can trust that only one link position is returned
                                        dgn_scr_starts[i] = dgn_scr[0];
                                        done = 1;
                                        break;
                                    }
                                }
                            }
                        }
                        
                        //get link positions (there's two because of the compass)
                        if(dgn_num != -1){
                            dgn_scr[0] = -1;
                            dgn_scr[1] = -1;
                            dgn_scrs_found = 0;
                            for(i = 0; i < 64; i++){ //check everywhere
                                pal_temp = floor(external_call(global.getemupixel, global.sr_handle, 18 + (8 * (i mod 8)), 16 + offset + (4 * (i div 8))));
                                if(pal_temp != global.nes_pal[emutype, 15] && pal_temp != global.nes_pal[emutype, 18]){
                                    if(dgn_scr[0] == -1){
                                        dgn_scr[0] = i;
                                        dgn_scrs_found = 1;
                                    }
                                    else if(dgn_scr[1] == -1){
                                        dgn_scr[1] = i;
                                        dgn_scrs_found = 2;
                                    }
                                }
                            }
                            
                            //check for compass
                            if(dgn_scrs_found_prev == 1 && dgn_scrs_found == 2 && dgn_scr_compass[dgn_num] == -1){
                                //YOU CAN'T MESS ME UP ANYMORE, COMPASS!
                                //CAN'T EVEN HIDE IF YOU'RE BLINKING BLACK!
                                if(dgn_scr_prev[0] == dgn_scr[0]){
                                    dgn_scr_compass[dgn_num] = dgn_scr[1];
                                }
                                else if(dgn_scr_prev[0] == dgn_scr[1]){
                                    dgn_scr_compass[dgn_num] = dgn_scr[0];
                                }
                            }
                            
                            //find link's real position
                            dgn_linkpos = 255;
                            if(dgn_scrs_found == 1){
                                if(dgn_scr[0] == dgn_scr_compass[dgn_num] && (dgn_linkpos_prev == dgn_scr[0] - 1 || dgn_linkpos_prev == dgn_scr[0] + 1 || dgn_linkpos_prev == dgn_scr[0] - 8 || dgn_linkpos_prev == dgn_scr[0] + 8)){
                                    //if he was next to compass screen, assume he's on the compass screen now
                                    //this will be incorrect if he's in stairs next to it
                                    //TODO: FIX THIS!
                                    dgn_linkpos = dgn_scr[0];
                                }
                                else if(dgn_scr[0] == dgn_scr_compass[dgn_num]){
                                    //now he's almost certainly in stairs so keep his last position
                                    dgn_linkpos = dgn_linkpos_prev;
                                }
                                else if(dgn_scr_compass[dgn_num] == -1){
                                    //he's gotta be where he says he is
                                    dgn_linkpos = dgn_scr[0];
                                }
                                else if(dgn_scr[0] != dgn_scr_compass[dgn_num] && dgn_scr_compass[dgn_num] != -1){
                                    //he's at the only position, because the compass dot is black so not recognized temporarily
                                    dgn_linkpos = dgn_scr[0];
                                }
                                else{
                                    //he's lost so report unknown
                                    dgn_linkpos = 255;
                                }
                            }
                            else if(dgn_scrs_found == 2){ //now its easier
                                if(dgn_scr[0] == dgn_scr_compass[dgn_num] && dgn_scr[1] != -1){
                                    //he's screen 2
                                    dgn_linkpos = dgn_scr[1];
                                }
                                else if(dgn_scr[1] == dgn_scr_compass[dgn_num] && dgn_scr[0] != -1){
                                    //he's screen 1
                                    dgn_linkpos = dgn_scr[0];
                                }
                                else{
                                    //something's gone terribly wrong, so report unknown
                                    dgn_linkpos = 255;
                                }
                            }
                            
                            //check for level number. use top left of the left L as a basic check to see if level is there
                            pal_temp = floor(external_call(global.getemupixel, global.sr_handle, 17, 8 + offset));
                            dgn_level = 0;
                            if(pal_temp == global.nes_pal[emutype, 48]){
                                //look for 1
                                if(dgn_level == 0){
                                    if(floor(external_call(global.getemupixel, global.sr_handle, 65, 14 + offset)) == global.nes_pal[emutype, 48]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 68, 11 + offset)) == global.nes_pal[emutype, 48]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 68, 12 + offset)) == global.nes_pal[emutype, 48]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 69, 11 + offset)) == global.nes_pal[emutype, 15])
                                    {
                                        dgn_level = 1;
                                    }
                                }
                                //look for 2
                                if(dgn_level == 0){
                                    if(floor(external_call(global.getemupixel, global.sr_handle, 68, 10 + offset)) == global.nes_pal[emutype, 48]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 64, 8 + offset)) == global.nes_pal[emutype, 15]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 68, 9 + offset)) == global.nes_pal[emutype, 15])
                                    {
                                        dgn_level = 2;
                                    }
                                }
                                //look for 3
                                if(dgn_level == 0){
                                    if(floor(external_call(global.getemupixel, global.sr_handle, 70, 8 + offset)) == global.nes_pal[emutype, 48]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 70, 9 + offset)) == global.nes_pal[emutype, 15]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 70, 10 + offset)) == global.nes_pal[emutype, 15])
                                    {
                                        dgn_level = 3;
                                    }
                                }
                                //look for 4
                                if(dgn_level == 0){
                                    if(floor(external_call(global.getemupixel, global.sr_handle, 64, 12 + offset)) == global.nes_pal[emutype, 48]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 69, 14 + offset)) == global.nes_pal[emutype, 48]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 64, 13 + offset)) == global.nes_pal[emutype, 15])
                                    {
                                        dgn_level = 4;
                                    }
                                }
                                //look for 5
                                if(dgn_level == 0){
                                    if(floor(external_call(global.getemupixel, global.sr_handle, 64, 8 + offset)) == global.nes_pal[emutype, 48]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 64, 13 + offset)) == global.nes_pal[emutype, 48])
                                    {
                                        dgn_level = 5;
                                    }
                                }
                                //look for 6
                                if(dgn_level == 0){
                                    if(floor(external_call(global.getemupixel, global.sr_handle, 65, 9 + offset)) == global.nes_pal[emutype, 48]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 66, 9 + offset)) == global.nes_pal[emutype, 48]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 64, 9 + offset)) == global.nes_pal[emutype, 15])
                                    {
                                        dgn_level = 6;
                                    }
                                }
                                //look for 7
                                if(dgn_level == 0){
                                    if(floor(external_call(global.getemupixel, global.sr_handle, 68, 10 + offset)) == global.nes_pal[emutype, 48]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 68, 11 + offset)) == global.nes_pal[emutype, 48]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 69, 10 + offset)) == global.nes_pal[emutype, 48]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 69, 11 + offset)) == global.nes_pal[emutype, 15])
                                    {
                                        dgn_level = 7;
                                    }
                                }
                                //look for 8
                                if(dgn_level == 0){
                                    if(floor(external_call(global.getemupixel, global.sr_handle, 69, 9 + offset)) == global.nes_pal[emutype, 48]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 69, 10 + offset)) == global.nes_pal[emutype, 48]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 68, 9 + offset)) == global.nes_pal[emutype, 15]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 69, 8 + offset)) == global.nes_pal[emutype, 15])
                                    {
                                        dgn_level = 8;
                                    }
                                }
                                //look for 9
                                if(dgn_level == 0){
                                    if(floor(external_call(global.getemupixel, global.sr_handle, 68, 13 + offset)) == global.nes_pal[emutype, 48]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 68, 14 + offset)) == global.nes_pal[emutype, 48]
                                    && floor(external_call(global.getemupixel, global.sr_handle, 69, 14 + offset)) == global.nes_pal[emutype, 15])
                                    {
                                        dgn_level = 9;
                                    }
                                }
                            }
                            
                            //update previous values
                            dgn_scr_prev[0] = dgn_scr[0];
                            dgn_scr_prev[1] = dgn_scr[1];
                            dgn_scrs_found_prev = dgn_scrs_found;
                            dgn_linkpos_prev = dgn_linkpos;
                        }
                    }
                    else{//something else
                        if(on_type != 0){ //update location type
                            on_type = 0;
                        }
                    }
                }
                else{ //not in game
                    if(on_type != 0){ //update location type
                        on_type = 0;
                    }
                }
            }
            
            //update tracker values accordingly
            if(global.net_active && global.net_playerid != -1){
                global.playerowpos[global.net_playerid] = screen;
                global.playermaptype[global.net_playerid] = on_type;
                if(on_type == 2){
                    global.playerdgnpos[global.net_playerid] = dgn_linkpos;
                }
                else{
                    global.playerdgnpos[global.net_playerid] = 255;
                }
                
                var c1, c2, c3, c4, r, g, b, cf, found, start;
                dgnlevel = 0;
                found = 0;
                if(global.playermaptype[global.net_playerid] == 2){
                    if(dgn_num != -1){
                        c1 = dgn_palettes[dgn_num * 4];
                        c2 = dgn_palettes[1 + (dgn_num * 4)];
                        c3 = dgn_palettes[2 + (dgn_num * 4)];
                        c4 = dgn_palettes[3 + (dgn_num * 4)];
                        start = dgn_scr_starts[dgn_num];
                    }
                    else{
                        c1 = c_white;
                        c2 = c_white;
                        c3 = c_white;
                        c4 = c_white;
                        start = 255;
                    }
                    dgnlevel = dgn_level;
                }
                else{
                    c1 = c_white;
                    c2 = c_white;
                    c3 = c_white;
                    c4 = c_white;
                    start = 255;
                    dgnlevel = 0;
                }
                
                //figure out what map it is if entering a dungeon
                if(global.playermaptype[global.net_playerid] == 2 && map_type_prev == 1 && start != 255 && global.playerdgnpos[global.net_playerid] != 255){
                    for(i = 0; i < 9; i++){
                        if(ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, i + 1) == start && c1 == ds_grid_get(global.inst_ctrl_tracker.grd_auto_dgnpals, 0, i * 4) && c2 == ds_grid_get(global.inst_ctrl_tracker.grd_auto_dgnpals, global.playerseedindex[global.net_playerid], 1 + (i * 4)) &&  c3 == ds_grid_get(global.inst_ctrl_tracker.grd_auto_dgnpals, 0, 2 + (i * 4)) &&  c4 == ds_grid_get(global.inst_ctrl_tracker.grd_auto_dgnpals, 0, 3 + (i * 4))){
                            global.playerdgnmap[global.net_playerid] = i;
                            
                            //automatically switch maps
                            global.curr_map = i + 1;
                            map_type_prev = 2;
                            found = 1;
                            break;
                        }
                    }
                    if(!found){
                        //get it from server if it doesn't exist already so we don't desync
                        buffer_seek(global.net_buf_send, buffer_seek_start, 0);
                        buffer_write(global.net_buf_send, buffer_u8, 200);
                        buffer_write(global.net_buf_send, buffer_s8, global.net_playerid);
                        buffer_write(global.net_buf_send, buffer_u32, c1);
                        buffer_write(global.net_buf_send, buffer_u32, c2);
                        buffer_write(global.net_buf_send, buffer_u32, c3);
                        buffer_write(global.net_buf_send, buffer_u32, c4);
                        buffer_write(global.net_buf_send, buffer_u8, start);
                        network_send_raw(global.net_socketid, global.net_buf_send, 19);
                    }
                }
                
                //dungeon-related DF stuff
                if(global.playermaptype[global.net_playerid] == 2 && global.playerdgnmap[global.net_playerid] >= 0 && global.playerdgnmap[global.net_playerid] < 9 && global.playerdgnpos[global.net_playerid] >= 0 && global.playerdgnpos[global.net_playerid] < 64){
                    //save level number for the current dmap so the DF can use it to narrow down MUCH faster
                    if(ds_grid_get(global.inst_ctrl_tracker.grd_auto_dgnlevels, 0, global.playerdgnmap[global.net_playerid]) == 0){
                        ds_grid_set(global.inst_ctrl_tracker.grd_auto_dgnlevels, 0, global.playerdgnmap[global.net_playerid], dgnlevel);
                        
                        //send it to the server
                        buffer_seek(global.net_buf_send, buffer_seek_start, 0);
                        buffer_write(global.net_buf_send, buffer_u8, 115);
                        buffer_write(global.net_buf_send, buffer_s8, global.net_playerid);
                        buffer_write(global.net_buf_send, buffer_u8, global.playerdgnmap[global.net_playerid]);
                        buffer_write(global.net_buf_send, buffer_u8, dgnlevel);
                        network_send_raw(global.net_socketid, global.net_buf_send, 4);
                        
                        //also update the overworld icon
                        ds_grid_set(global.inst_ctrl_tracker.grd_ow_icons, 0, global.playerowpos[global.net_playerid], dgnlevel + 1);
                        
                        //send it to the server
                        buffer_seek(global.net_buf_send, buffer_seek_start, 0);
                        buffer_write(global.net_buf_send, buffer_u8, 103);
                        buffer_write(global.net_buf_send, buffer_s8, global.net_playerid);
                        buffer_write(global.net_buf_send, buffer_u8, global.playerowpos[global.net_playerid]);
                        buffer_write(global.net_buf_send, buffer_u8, ds_grid_get(global.inst_ctrl_tracker.grd_ow_icons, 0, global.playerowpos[global.net_playerid]));
                        network_send_raw(global.net_socketid, global.net_buf_send, 4);
                        
                        buffer_seek(global.net_buf_send, buffer_seek_start, 0);
                        buffer_write(global.net_buf_send, buffer_u8, 104);
                        buffer_write(global.net_buf_send, buffer_s8, global.net_playerid);
                        buffer_write(global.net_buf_send, buffer_u8, global.playerowpos[global.net_playerid]);
                        buffer_write(global.net_buf_send, buffer_u8, global.net_playerid);
                        buffer_write(global.net_buf_send, buffer_bool, ds_grid_get(global.inst_ctrl_tracker.grd_ow_icons_marker, 0, (global.net_playerid * 128) + global.playerowpos[global.net_playerid]));
                        network_send_raw(global.net_socketid, global.net_buf_send, 5);
                    }
                }
                
                //switch to overworld if needed
                if(map_type_prev == 2 && global.playermaptype[global.net_playerid] == 1){
                    global.curr_map = 0;
                    map_type_prev = 1;
                }
            }
            else if(!global.net_active){
                global.playerowpos[0] = screen;
                global.playermaptype[0] = on_type;
                if(global.playermaptype[0] == 2){
                    global.playerdgnpos[0] = dgn_linkpos;
                }
                else{
                    global.playerdgnpos[0] = 255;
                }
                
                var c1, c2, c3, c4, r, g, b, cf, map, start;
                dgnlevel = 0;
                map = 255;
                if(global.playermaptype[0] == 2){
                    if(dgn_num != -1){
                        c1 = dgn_palettes[dgn_num * 4];
                        c2 = dgn_palettes[1 + (dgn_num * 4)];
                        c3 = dgn_palettes[2 + (dgn_num * 4)];
                        c4 = dgn_palettes[3 + (dgn_num * 4)];
                        start = dgn_scr_starts[dgn_num];
                    }
                    else{
                        c1 = c_white;
                        c2 = c_white;
                        c3 = c_white;
                        c4 = c_white;
                        start = 255;
                    }
                    dgnlevel = dgn_level;
                }
                else{
                    c1 = c_white;
                    c2 = c_white;
                    c3 = c_white;
                    c4 = c_white;
                    start = 255;
                    dgnlevel = 0;
                }

                //figure out what map it is if entering a dungeon
                if(global.playermaptype[0] == 2 && map_type_prev == 1 && start != 255 && global.playerdgnpos[0] != 255){
                    for(i = 0; i < 9; i++){
                        map = i;
                        
                        if(ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, i + 1) == start && c1 == ds_grid_get(global.inst_ctrl_tracker.grd_auto_dgnpals, 0, i * 4) && c2 == ds_grid_get(global.inst_ctrl_tracker.grd_auto_dgnpals, 0, 1 + (i * 4)) &&  c3 == ds_grid_get(global.inst_ctrl_tracker.grd_auto_dgnpals, 0, 2 + (i * 4)) &&  c4 == ds_grid_get(global.inst_ctrl_tracker.grd_auto_dgnpals, 0, 3 + (i * 4))){
                            map = i;
                            global.playerdgnmap[0] = i;
                            
                            //automatically switch maps
                            global.curr_map = map + 1;
                            map_type_prev = 2;
                            break;
                        }
                        else if(c_white == ds_grid_get(global.inst_ctrl_tracker.grd_auto_dgnpals, 0, i * 4) && c_white == ds_grid_get(global.inst_ctrl_tracker.grd_auto_dgnpals, 0, 1 + (i * 4)) &&  c_white == ds_grid_get(global.inst_ctrl_tracker.grd_auto_dgnpals, 0, 2 + (i * 4)) &&  c_white == ds_grid_get(global.inst_ctrl_tracker.grd_auto_dgnpals, 0, 3 + (i * 4))){
                            map = i;
                            global.playerdgnmap[0] = i;
                            //set colors
                            ds_grid_set(global.inst_ctrl_tracker.grd_auto_dgnpals, 0, (map * 4), c1);
                            ds_grid_set(global.inst_ctrl_tracker.grd_auto_dgnpals, 0, (1 + (map * 4)), c2);
                            ds_grid_set(global.inst_ctrl_tracker.grd_auto_dgnpals, 0, (2 + (map * 4)), c3);
                            ds_grid_set(global.inst_ctrl_tracker.grd_auto_dgnpals, 0, (3 + (map * 4)), c4);
                            
                            r = (color_get_red(c1) + color_get_red(c2) + color_get_red(c3)) div 3;
                            g = (color_get_green(c1) + color_get_green(c2) + color_get_green(c3)) div 3;
                            b = (color_get_blue(c1) + color_get_blue(c2) + color_get_blue(c3)) div 3;
                            
                            cf = make_color_rgb(r, g, b);
                            if(color_get_value(cf) < 128){
                                cf = make_color_hsv(color_get_hue(cf), color_get_saturation(cf), 128);
                            }
                            ds_grid_set(global.inst_ctrl_tracker.grd_dgn_colors, 0, map, cf);
                            
                            //set start screen
                            ds_grid_set(global.inst_ctrl_tracker.grd_starts, 0, map + 1, start);
                            
                            //automatically switch maps
                            global.curr_map = map + 1;
                            map_type_prev = 2;
                            break;
                        }
                    }
                }
    
                //dungeon-related auto icon stuff
                if(global.playermaptype[0] == 2 && global.playerdgnmap[0] >= 0 && global.playerdgnmap[0] < 9 && global.playerdgnpos[0] >= 0 && global.playerdgnpos[0] < 64){
                    //save level number for the current dmap so the DF can use it to narrow down MUCH faster
                    ds_grid_set(global.inst_ctrl_tracker.grd_auto_dgnlevels, 0, global.playerdgnmap[0], dgnlevel);
                    
                    //set DF level number to the correct 9 if the screen reader knows it and DF is not disabled
                    //doing this helps it find other levels even faster since it instantly eliminates 9 upon entry
                    //this is possible because the LEVEL text is ALWAYS there, and the start screen never changes
                    //will break once rando shapes are in, but you shouldn't be using auto-DF in that case anyway
                    if(global.dgn_finder_auto != 0 && ds_grid_get(global.inst_ctrl_tracker.grd_dgn_nums, 0, global.playerdgnmap[0]) != 8 && dgnlevel == 9 && ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.playerdgnmap[0] + 1) == 62){
                        //ds_grid_set(global.inst_ctrl_tracker.grd_dgn_nums, 0, global.playerdgnmap[0], 8);
                    }
                    else if(global.dgn_finder_auto != 0 && ds_grid_get(global.inst_ctrl_tracker.grd_dgn_nums, 0, global.playerdgnmap[0]) != 17 && dgnlevel == 9 && ds_grid_get(global.inst_ctrl_tracker.grd_starts, 0, global.playerdgnmap[0] + 1) == 60){
                        //ds_grid_set(global.inst_ctrl_tracker.grd_dgn_nums, 0, global.playerdgnmap[0], 17);
                    }
                    
                    //mark corresponding overworld screen with the correct level number
                    if(global.playerowpos[0] >= 0 && global.playerowpos[0] < 128){
                        dnum = ds_grid_get(global.inst_ctrl_tracker.grd_dgn_nums, 0, global.playerdgnmap[0]);
    
                        //just set the icon to the level number if we know it from the screen read
                        if(dgnlevel != 0){
                            if(ds_grid_get(global.inst_ctrl_tracker.grd_ow_icons, 0, global.playerowpos[0]) != dgnlevel + 1){
                                ds_grid_set(global.inst_ctrl_tracker.grd_ow_icons, 0, global.playerowpos[0], dgnlevel + 1);
                            }
                        }
                        else if(dnum != -1){
                            if(dnum < 9){
                                if(ds_grid_get(global.inst_ctrl_tracker.grd_ow_icons, 0, global.playerowpos[0]) != dnum + 2){
                                    ds_grid_set(global.inst_ctrl_tracker.grd_ow_icons, 0, global.playerowpos[0], dnum + 2);
                                }
                            }
                            else{
                                if(ds_grid_get(global.inst_ctrl_tracker.grd_ow_icons, 0, global.playerowpos[0]) != dnum - 7){
                                    ds_grid_set(global.inst_ctrl_tracker.grd_ow_icons, 0, global.playerowpos[0], dnum - 7);
                                }
                            }
                        }
                        else{
                            if(ds_grid_get(global.inst_ctrl_tracker.grd_ow_icons, 0, global.playerowpos[0]) != 1){
                                ds_grid_set(global.inst_ctrl_tracker.grd_ow_icons, 0, global.playerowpos[0], 1);
                            }
                        }
                    }
                }
                
                //switch to overworld if needed            
                if(map_type_prev == 2 && global.playermaptype[0] == 1){
                    global.curr_map = 0;
                    map_type_prev = 1;
                }
            }
        }
        else{
            global.sr_handle = 0;
            global.sr_init = 0;
        }
    }
}

