if(image_single == 0){
    show_message_async("No ROM selected. Click on Pick ROM and choose a ROM.");
}
else if(image_single == 2){
    show_message_async("Something is horribly wrong, or you selected a ROM that's the wrong size.");
}
else if(image_single == 1){
    //make flags string
    flags = "";
    if(global.rando_drops){flags = "D";}
    if(global.rando_dgnrooms){flags += "R";}
    if(global.rando_burnbomb){flags += "B";}
    if(global.rando_lostpaths){flags += "L";}
    if(global.rando_owpaths){flags += "O";}

    dbgstr = "";
    //get the output rom path
    //temp workaround for the breakage of filename_change_ext.
    //go figure, they mess up something that should've never been edited because it worked just fine
    global.rando_rom_out = get_save_filename_ext("iNES ROM Files|*.nes", string_copy(filename_name(global.rando_rom_in), 0, string_length(filename_name(global.rando_rom_in)) - 4) + "_ZHR-" + flags + "_" + string(global.rando_seed) + ".nes", filename_path(global.rando_rom_in), "Choose Output ROM Location and Name");
    //global.rando_rom_out = get_save_filename_ext("iNES Rom Files|*.nes", filename_change_ext(filename_name(global.rando_rom_in), "") + "_ZHR-" + flags + "_" + string(global.rando_seed) + ".nes", filename_path(global.rando_rom_in), "Choose Output ROM Location and Name");
    if(global.rando_rom_out != ""){
        //read original rom
        buf_orig = buffer_create(131088, buffer_fast, 1);
        buf_out = buffer_create(131088, buffer_fast, 1);
        buffer_load_ext(buf_orig, global.rando_rom_in, 0);
        buffer_copy(buf_orig, 0, 131088, buf_out, 0);
        
        //reset data and set seed
        event_user(0);
        event_user(1);
        random_set_seed(global.rando_seed);

        //write version data
        buffer_seek(buf_out, buffer_seek_start, 109407);
        buffer_write(buf_out, buffer_u8, 35);
        buffer_write(buf_out, buffer_u8, 17);
        buffer_write(buf_out, buffer_u8, 14);
        buffer_write(buf_out, buffer_u8, 21);
        buffer_write(buf_out, buffer_u8, 25);
        buffer_write(buf_out, buffer_u8, 14);
        buffer_write(buf_out, buffer_u8, 27);
        buffer_write(buf_out, buffer_u8, 36);
        buffer_write(buf_out, buffer_u8, 28);
        buffer_write(buf_out, buffer_u8, 14);
        buffer_write(buf_out, buffer_u8, 14);
        buffer_write(buf_out, buffer_u8, 13);
        buffer_write(buf_out, buffer_u8, 36);

        //find length of seed string
        seed_len = string_length(string(global.rando_seed));
        
        //parse and add to title screen
        if(global.rando_seed < 0){
            buffer_seek(buf_out, buffer_seek_start, 109420);
            buffer_write(buf_out, buffer_u8, 47);
        }
        else{
            buffer_seek(buf_out, buffer_seek_start, 109421);
        }
        for(i = 1; i < seed_len; i += 1){
            buffer_write(buf_out, buffer_u8, ord(string_char_at(string(global.rando_seed), i + 1)) - 48);
        }
        
        //write version info
        buffer_seek(buf_out, buffer_seek_start, 109442);
        buffer_write(buf_out, buffer_u8, 31);
        buffer_write(buf_out, buffer_u8, ord(string_char_at(global.version, 1)) - 48);
        buffer_write(buf_out, buffer_u8, 44);
        buffer_write(buf_out, buffer_u8, ord(string_char_at(global.version, 3)) - 48);
        buffer_write(buf_out, buffer_u8, ord(string_char_at(global.version, 4)) - 48);
        
        //write flags
        buffer_seek(buf_out, buffer_seek_start, 109456);
        if(global.rando_drops){buffer_write(buf_out, buffer_u8, 13);}
        else{buffer_write(buf_out, buffer_u8, 36);}
        if(global.rando_dgnrooms){buffer_write(buf_out, buffer_u8, 27);}
        else{buffer_write(buf_out, buffer_u8, 36);}
        if(global.rando_burnbomb){buffer_write(buf_out, buffer_u8, 11);}
        else{buffer_write(buf_out, buffer_u8, 36);}
        if(global.rando_lostpaths){buffer_write(buf_out, buffer_u8, 21);}
        else{buffer_write(buf_out, buffer_u8, 36);}
        if(global.rando_owpaths){buffer_write(buf_out, buffer_u8, 24);}
        else{buffer_write(buf_out, buffer_u8, 36);}
        
        //set square wave instrument
        buffer_seek(buf_out, buffer_seek_start, 8096);
        buffer_write(buf_out, buffer_u8, global.rando_mus_type);
        
        //write overworld palette if changed
        if(global.rando_ow_pal_sel != 0){
            buffer_seek(buf_out, buffer_seek_start, 103196);
            buffer_write(buf_out, buffer_u8, global.rando_ow_pal[global.rando_ow_pal_sel - 1, 1]);
            buffer_write(buf_out, buffer_u8, global.rando_ow_pal[global.rando_ow_pal_sel - 1, 2]);
            buffer_write(buf_out, buffer_u8, global.rando_ow_pal[global.rando_ow_pal_sel - 1, 3]);
            buffer_seek(buf_out, buffer_seek_start, 103200);
            buffer_write(buf_out, buffer_u8, global.rando_ow_pal[global.rando_ow_pal_sel - 1, 4]);
            buffer_write(buf_out, buffer_u8, global.rando_ow_pal[global.rando_ow_pal_sel - 1, 5]);
            buffer_write(buf_out, buffer_u8, global.rando_ow_pal[global.rando_ow_pal_sel - 1, 6]);
        }
        
        //mix up overworld routing a bit if enabled
        if(global.rando_owpaths){
            zh_rando_owpaths();
        }
        
        //mix up lost paths if enabled
        if(global.rando_lostpaths){
            //lost woods
            lostpath_woods[0] = irandom(2);
            lostpath_woods[1] = irandom(2);
            lostpath_woods[2] = irandom(2);

            buffer_seek(buf_out, buffer_seek_start, 28071);
            for(i = 0; i < 3; i += 1){
                if(lostpath_woods[i] == 0){lostpath_woods[i] = 2;}
                else if(lostpath_woods[i] == 1){lostpath_woods[i] = 4;}
                else if(lostpath_woods[i] == 2){lostpath_woods[i] = 8;}
                buffer_write(buf_out, buffer_u8, lostpath_woods[i]);
            }
            buffer_write(buf_out, buffer_u8, 2);

            //lost hills
            lostpath_hills[0] = irandom(2);
            lostpath_hills[1] = irandom(2);
            lostpath_hills[2] = irandom(2);

            for(i = 0; i < 3; i += 1){
                if(lostpath_hills[i] == 0){lostpath_hills[i] = 1;}
                else if(lostpath_hills[i] == 1){lostpath_hills[i] = 4;}
                else if(lostpath_hills[i] == 2){lostpath_hills[i] = 8;}
                buffer_write(buf_out, buffer_u8, lostpath_hills[i]);
            }
            buffer_write(buf_out, buffer_u8, 8);
        }

        //mix up dungeon room prefabs if enabled
        if(global.rando_dgnrooms){
            //write first part of lanmola fix
            buffer_seek(buf_out, buffer_seek_start, 76533);
            buffer_write(buf_out, buffer_u8, 32);
            buffer_write(buf_out, buffer_u8, 192);
            buffer_write(buf_out, buffer_u8, 175);
            buffer_write(buf_out, buffer_u8, 234);
            buffer_write(buf_out, buffer_u8, 234);

            //write second part of lanmola fix
            buffer_seek(buf_out, buffer_seek_start, 77776);
            buffer_write(buf_out, buffer_u8, 74);
            buffer_write(buf_out, buffer_u8, 144);
            buffer_write(buf_out, buffer_u8, 50);
            buffer_write(buf_out, buffer_u8, 173);
            buffer_write(buf_out, buffer_u8, 15);
            buffer_write(buf_out, buffer_u8, 5);
            buffer_write(buf_out, buffer_u8, 205);
            buffer_write(buf_out, buffer_u8, 241);
            buffer_write(buf_out, buffer_u8, 127);
            buffer_write(buf_out, buffer_u8, 208);
            buffer_write(buf_out, buffer_u8, 29);
            buffer_write(buf_out, buffer_u8, 238);
            buffer_write(buf_out, buffer_u8, 240);
            buffer_write(buf_out, buffer_u8, 127);
            buffer_write(buf_out, buffer_u8, 169);
            buffer_write(buf_out, buffer_u8, 8);
            buffer_write(buf_out, buffer_u8, 205);
            buffer_write(buf_out, buffer_u8, 240);
            buffer_write(buf_out, buffer_u8, 127);
            buffer_write(buf_out, buffer_u8, 208);
            buffer_write(buf_out, buffer_u8, 30);
            buffer_write(buf_out, buffer_u8, 173);
            buffer_write(buf_out, buffer_u8, 15);
            buffer_write(buf_out, buffer_u8, 5);
            buffer_write(buf_out, buffer_u8, 41);
            buffer_write(buf_out, buffer_u8, 8);
            buffer_write(buf_out, buffer_u8, 208);
            buffer_write(buf_out, buffer_u8, 7);
            buffer_write(buf_out, buffer_u8, 169);
            buffer_write(buf_out, buffer_u8, 13);
            buffer_write(buf_out, buffer_u8, 141);
            buffer_write(buf_out, buffer_u8, 15);
            buffer_write(buf_out, buffer_u8, 5);
            buffer_write(buf_out, buffer_u8, 208);
            buffer_write(buf_out, buffer_u8, 5);
            buffer_write(buf_out, buffer_u8, 169);
            buffer_write(buf_out, buffer_u8, 7);
            buffer_write(buf_out, buffer_u8, 141);
            buffer_write(buf_out, buffer_u8, 15);
            buffer_write(buf_out, buffer_u8, 5);
            buffer_write(buf_out, buffer_u8, 173);
            buffer_write(buf_out, buffer_u8, 15);
            buffer_write(buf_out, buffer_u8, 5);
            buffer_write(buf_out, buffer_u8, 141);
            buffer_write(buf_out, buffer_u8, 241);
            buffer_write(buf_out, buffer_u8, 127);
            buffer_write(buf_out, buffer_u8, 169);
            buffer_write(buf_out, buffer_u8, 0);
            buffer_write(buf_out, buffer_u8, 141);
            buffer_write(buf_out, buffer_u8, 240);
            buffer_write(buf_out, buffer_u8, 127);
            buffer_write(buf_out, buffer_u8, 169);
            buffer_write(buf_out, buffer_u8, 8);
            buffer_write(buf_out, buffer_u8, 96);
            
            //pick random rooms and write the new data
            buffer_seek(buf_out, buffer_seek_start, 90350);
            for(i = 0; i < 42; i += 1){
                //pick a random vanilla room from the database 2/3 of the time, original 1/3
                if(irandom(2) == 0){
                    rnd = 0;
                }
                else{
                    rnd = irandom(global.roomdata_vanilla[i, 1]);
                }

                //write the new room data
                for(j = 0; j < 12; j += 1){
                    buffer_write(buf_out, buffer_u8, ds_grid_get(global.roomdata_vanilla[i, 0], j, rnd));
                }
            }
        }
        
        //mix up drop tables if enabled
        drops_success = 0;
        if(global.rando_drops){
            buffer_seek(buf_out, buffer_seek_start, 77906);
            while(drops_success < 40){
                do{ //keep picking a slot until we get one thats not picked yet
                    rnd = irandom(39);
                } until (dropdata_orig[rnd, 1] == 0)
            
                //set pick, write byte
                dropdata_orig[rnd, 1] = 1;
                buffer_write(buf_out, buffer_u8, dropdata_orig[rnd, 0]);
                drops_success += 1;
            }
        }
        
        //mix up burn/bomb locations if enabled
        if(global.rando_burnbomb){
            zh_rando_burnbomb();
        }
        //all done, so write rom!
        buffer_save_ext(buf_out, global.rando_rom_out, 0, 131088);
        
        //delete buffers to avoid memory leaks
        buffer_delete(buf_orig);
        buffer_delete(buf_out);
        show_message_async("Generation Complete!");
    }
    else{
        show_message_async("Generation Failed!");
    }
}
else{
    show_message_async("Unknown error!");
}

