image_single = 0;

//init data
event_user(0);

//read rando data if needed
if(!global.rando_readdata){
    //load room databases
    for(i = 0; i < 42; i += 1){
        //load vanilla-only rooms
        if(file_exists(working_directory + "roomdata-vanilla/" + string(i) + ".zrd")){
            //open file and determine how many rooms are in it
            fs = file_bin_open(working_directory + "roomdata-vanilla/" + string(i) + ".zrd", 0);
            data_max = file_bin_size(fs) div 12;
            
            //make a grid in an array because gm doesn't like 3d arrays :(
            global.roomdata_vanilla[i, 0] = ds_grid_create(12, data_max); //room data
            global.roomdata_vanilla[i, 1] = data_max - 1; //amount of rooms in data; -1 because inclusive
    
            //read data into the grid
            for(j = 0; j < data_max; j += 1){
                for(k = 0; k < 12; k += 1){
                    ds_grid_set(global.roomdata_vanilla[i, 0], k, j, file_bin_read_byte(fs));
                }
            }
            //close the file
            file_bin_close(fs);
        }
        else{ //crash time!
            show_error("MISSING ROOM DATA: roomdata-vanilla/" + string(i) + ".zrd#Program will go boom now!",1);
        }
    }
    global.rando_readdata = 1;
    
    //create overworld palette info
    global.rando_ow_pal_max = 48; //highest palette index

    global.rando_ow_pal[0, 0] = "Snowy Evening";
    global.rando_ow_pal[0, 1] = $1B;
    global.rando_ow_pal[0, 2] = $31;
    global.rando_ow_pal[0, 3] = $21;
    global.rando_ow_pal[0, 4] = $00;
    global.rando_ow_pal[0, 5] = $31;
    global.rando_ow_pal[0, 6] = $21;
    global.rando_ow_pal[0, 7] = "Questwizard";

    global.rando_ow_pal[1, 0] = "Snowy Day";
    global.rando_ow_pal[1, 1] = $1B;
    global.rando_ow_pal[1, 2] = $20;
    global.rando_ow_pal[1, 3] = $21;
    global.rando_ow_pal[1, 4] = $00;
    global.rando_ow_pal[1, 5] = $20;
    global.rando_ow_pal[1, 6] = $21;
    global.rando_ow_pal[1, 7] = "Questwizard";

    global.rando_ow_pal[2, 0] = "Dead Default (Blue Water)";
    global.rando_ow_pal[2, 1] = $18;
    global.rando_ow_pal[2, 2] = $36;
    global.rando_ow_pal[2, 3] = $12;
    global.rando_ow_pal[2, 4] = $17;
    global.rando_ow_pal[2, 5] = $36;
    global.rando_ow_pal[2, 6] = $12;
    global.rando_ow_pal[2, 7] = "Questwizard";

    global.rando_ow_pal[3, 0] = "Dead Default (Greenish Water)";
    global.rando_ow_pal[3, 1] = $18;
    global.rando_ow_pal[3, 2] = $36;
    global.rando_ow_pal[3, 3] = $1C;
    global.rando_ow_pal[3, 4] = $17;
    global.rando_ow_pal[3, 5] = $36;
    global.rando_ow_pal[3, 6] = $1C;
    global.rando_ow_pal[3, 7] = "Questwizard";

    global.rando_ow_pal[4, 0] = "Dead Default (Green Water)";
    global.rando_ow_pal[4, 1] = $18;
    global.rando_ow_pal[4, 2] = $36;
    global.rando_ow_pal[4, 3] = $09;
    global.rando_ow_pal[4, 4] = $17;
    global.rando_ow_pal[4, 5] = $36;
    global.rando_ow_pal[4, 6] = $09;
    global.rando_ow_pal[4, 7] = "Questwizard";

    global.rando_ow_pal[5, 0] = "Gray World (Bloody Water)";
    global.rando_ow_pal[5, 1] = $2D;
    global.rando_ow_pal[5, 2] = $10;
    global.rando_ow_pal[5, 3] = $06;
    global.rando_ow_pal[5, 4] = $2D;
    global.rando_ow_pal[5, 5] = $10;
    global.rando_ow_pal[5, 6] = $06;
    global.rando_ow_pal[5, 7] = "Questwizard";

    global.rando_ow_pal[6, 0] = "Lush Lands";
    global.rando_ow_pal[6, 1] = $19;
    global.rando_ow_pal[6, 2] = $39;
    global.rando_ow_pal[6, 3] = $11;
    global.rando_ow_pal[6, 4] = $18;
    global.rando_ow_pal[6, 5] = $39;
    global.rando_ow_pal[6, 6] = $11;
    global.rando_ow_pal[6, 7] = "Questwizard";

    global.rando_ow_pal[7, 0] = "Dark World (Orange Ground)";
    global.rando_ow_pal[7, 1] = $18;
    global.rando_ow_pal[7, 2] = $27;
    global.rando_ow_pal[7, 3] = $0A;
    global.rando_ow_pal[7, 4] = $17;
    global.rando_ow_pal[7, 5] = $27;
    global.rando_ow_pal[7, 6] = $0A;
    global.rando_ow_pal[7, 7] = "Questwizard";

    global.rando_ow_pal[8, 0] = "Dark World (Light Ground)";
    global.rando_ow_pal[8, 1] = $18;
    global.rando_ow_pal[8, 2] = $37;
    global.rando_ow_pal[8, 3] = $0A;
    global.rando_ow_pal[8, 4] = $17;
    global.rando_ow_pal[8, 5] = $37;
    global.rando_ow_pal[8, 6] = $0A;
    global.rando_ow_pal[8, 7] = "Questwizard";

    global.rando_ow_pal[9, 0] = "Hallow (Terraria Style)";
    global.rando_ow_pal[9, 1] = $1B;
    global.rando_ow_pal[9, 2] = $3B;
    global.rando_ow_pal[9, 3] = $13;
    global.rando_ow_pal[9, 4] = $14;
    global.rando_ow_pal[9, 5] = $3B;
    global.rando_ow_pal[9, 6] = $13;
    global.rando_ow_pal[9, 7] = "Questwizard";

    global.rando_ow_pal[10, 0] = "Crimson (Terraria Style)";
    global.rando_ow_pal[10, 1] = $07;
    global.rando_ow_pal[10, 2] = $16;
    global.rando_ow_pal[10, 3] = $05;
    global.rando_ow_pal[10, 4] = $07;
    global.rando_ow_pal[10, 5] = $16;
    global.rando_ow_pal[10, 6] = $05;
    global.rando_ow_pal[10, 7] = "Questwizard";

    global.rando_ow_pal[11, 0] = "Corruption (Terraria Style)";
    global.rando_ow_pal[11, 1] = $03;
    global.rando_ow_pal[11, 2] = $13;
    global.rando_ow_pal[11, 3] = $01;
    global.rando_ow_pal[11, 4] = $03;
    global.rando_ow_pal[11, 5] = $13;
    global.rando_ow_pal[11, 6] = $01;
    global.rando_ow_pal[11, 7] = "Questwizard";

    global.rando_ow_pal[12, 0] = "Yellowish (Greenish Water)";
    global.rando_ow_pal[12, 1] = $18;
    global.rando_ow_pal[12, 2] = $38;
    global.rando_ow_pal[12, 3] = $1B;
    global.rando_ow_pal[12, 4] = $00;
    global.rando_ow_pal[12, 5] = $38;
    global.rando_ow_pal[12, 6] = $1B;
    global.rando_ow_pal[12, 7] = "Questwizard";

    global.rando_ow_pal[13, 0] = "Night (Blue)";
    global.rando_ow_pal[13, 1] = $0C;
    global.rando_ow_pal[13, 2] = $1C;
    global.rando_ow_pal[13, 3] = $01;
    global.rando_ow_pal[13, 4] = $08;
    global.rando_ow_pal[13, 5] = $1C;
    global.rando_ow_pal[13, 6] = $01;
    global.rando_ow_pal[13, 7] = "Questwizard";

    global.rando_ow_pal[14, 0] = "Night (Sunset)";
    global.rando_ow_pal[14, 1] = $17;
    global.rando_ow_pal[14, 2] = $26;
    global.rando_ow_pal[14, 3] = $04;
    global.rando_ow_pal[14, 4] = $15;
    global.rando_ow_pal[14, 5] = $26;
    global.rando_ow_pal[14, 6] = $04;
    global.rando_ow_pal[14, 7] = "Questwizard";

    global.rando_ow_pal[15, 0] = "Cave World (Dark Yellowish)";
    global.rando_ow_pal[15, 1] = $09;
    global.rando_ow_pal[15, 2] = $18;
    global.rando_ow_pal[15, 3] = $0C;
    global.rando_ow_pal[15, 4] = $08;
    global.rando_ow_pal[15, 5] = $18;
    global.rando_ow_pal[15, 6] = $0C;
    global.rando_ow_pal[15, 7] = "Questwizard";

    global.rando_ow_pal[16, 0] = "Cave World (Blue Cave)";
    global.rando_ow_pal[16, 1] = $0C;
    global.rando_ow_pal[16, 2] = $1C;
    global.rando_ow_pal[16, 3] = $0C;
    global.rando_ow_pal[16, 4] = $08;
    global.rando_ow_pal[16, 5] = $1C;
    global.rando_ow_pal[16, 6] = $0C;
    global.rando_ow_pal[16, 7] = "Questwizard";

    global.rando_ow_pal[17, 0] = "Blackout (Obvious)";
    global.rando_ow_pal[17, 1] = $0F;
    global.rando_ow_pal[17, 2] = $0F;
    global.rando_ow_pal[17, 3] = $0F;
    global.rando_ow_pal[17, 4] = $0F;
    global.rando_ow_pal[17, 5] = $0F;
    global.rando_ow_pal[17, 6] = $0F;
    global.rando_ow_pal[17, 7] = "Questwizard";

    global.rando_ow_pal[18, 0] = "Whiteout (Obvious)";
    global.rando_ow_pal[18, 1] = $30;
    global.rando_ow_pal[18, 2] = $30;
    global.rando_ow_pal[18, 3] = $30;
    global.rando_ow_pal[18, 4] = $30;
    global.rando_ow_pal[18, 5] = $30;
    global.rando_ow_pal[18, 6] = $30;
    global.rando_ow_pal[18, 7] = "Warlock82";
    
    global.rando_ow_pal[19, 0] = "Tropical";
    global.rando_ow_pal[19, 1] = $1B;
    global.rando_ow_pal[19, 2] = $38;
    global.rando_ow_pal[19, 3] = $1C;
    global.rando_ow_pal[19, 4] = $17;
    global.rando_ow_pal[19, 5] = $38;
    global.rando_ow_pal[19, 6] = $1C;
    global.rando_ow_pal[19, 7] = "Questwizard";

    global.rando_ow_pal[20, 0] = "Default (All Graveyard)";
    global.rando_ow_pal[20, 1] = $30;
    global.rando_ow_pal[20, 2] = $00;
    global.rando_ow_pal[20, 3] = $12;
    global.rando_ow_pal[20, 4] = $30;
    global.rando_ow_pal[20, 5] = $00;
    global.rando_ow_pal[20, 6] = $12;
    global.rando_ow_pal[20, 7] = "Questwizard";

    global.rando_ow_pal[21, 0] = "Default (All Green)";
    global.rando_ow_pal[21, 1] = $1A;
    global.rando_ow_pal[21, 2] = $37;
    global.rando_ow_pal[21, 3] = $12;
    global.rando_ow_pal[21, 4] = $1A;
    global.rando_ow_pal[21, 5] = $37;
    global.rando_ow_pal[21, 6] = $12;
    global.rando_ow_pal[21, 7] = "Questwizard";

    global.rando_ow_pal[22, 0] = "Default (All Brown)";
    global.rando_ow_pal[22, 1] = $17;
    global.rando_ow_pal[22, 2] = $37;
    global.rando_ow_pal[22, 3] = $12;
    global.rando_ow_pal[22, 4] = $17;
    global.rando_ow_pal[22, 5] = $37;
    global.rando_ow_pal[22, 6] = $12;
    global.rando_ow_pal[22, 7] = "Questwizard";

    global.rando_ow_pal[23, 0] = "Ice Age (Gray)";
    global.rando_ow_pal[23, 1] = $30;
    global.rando_ow_pal[23, 2] = $10;
    global.rando_ow_pal[23, 3] = $31;
    global.rando_ow_pal[23, 4] = $30;
    global.rando_ow_pal[23, 5] = $10;
    global.rando_ow_pal[23, 6] = $31;
    global.rando_ow_pal[23, 7] = "Questwizard";

    global.rando_ow_pal[24, 0] = "Ice Age (Alternate)";
    global.rando_ow_pal[24, 1] = $21;
    global.rando_ow_pal[24, 2] = $20;
    global.rando_ow_pal[24, 3] = $31;
    global.rando_ow_pal[24, 4] = $23;
    global.rando_ow_pal[24, 5] = $20;
    global.rando_ow_pal[24, 6] = $31;
    global.rando_ow_pal[24, 7] = "Questwizard";

    global.rando_ow_pal[25, 0] = "Subrosia (OoS)";
    global.rando_ow_pal[25, 1] = $17;
    global.rando_ow_pal[25, 2] = $27;
    global.rando_ow_pal[25, 3] = $06;
    global.rando_ow_pal[25, 4] = $16;
    global.rando_ow_pal[25, 5] = $27;
    global.rando_ow_pal[25, 6] = $06;
    global.rando_ow_pal[25, 7] = "Questwizard";

    global.rando_ow_pal[26, 0] = "Tarm Ruins (OoS, Holodrum)";
    global.rando_ow_pal[26, 1] = $25;
    global.rando_ow_pal[26, 2] = $35;
    global.rando_ow_pal[26, 3] = $19;
    global.rando_ow_pal[26, 4] = $17;
    global.rando_ow_pal[26, 5] = $35;
    global.rando_ow_pal[26, 6] = $19;
    global.rando_ow_pal[26, 7] = "Questwizard";

    global.rando_ow_pal[27, 0] = "Rolling Ridge (OoA, Labrynna)";
    global.rando_ow_pal[27, 1] = $02;
    global.rando_ow_pal[27, 2] = $22;
    global.rando_ow_pal[27, 3] = $13;
    global.rando_ow_pal[27, 4] = $02;
    global.rando_ow_pal[27, 5] = $22;
    global.rando_ow_pal[27, 6] = $13;
    global.rando_ow_pal[27, 7] = "Questwizard";

    global.rando_ow_pal[28, 0] = "Void (Purple)";
    global.rando_ow_pal[28, 1] = $13;
    global.rando_ow_pal[28, 2] = $03;
    global.rando_ow_pal[28, 3] = $0F;
    global.rando_ow_pal[28, 4] = $13;
    global.rando_ow_pal[28, 5] = $03;
    global.rando_ow_pal[28, 6] = $0F;
    global.rando_ow_pal[28, 7] = "Questwizard";

    global.rando_ow_pal[29, 0] = "Void (Gray)";
    global.rando_ow_pal[29, 1] = $10;
    global.rando_ow_pal[29, 2] = $00;
    global.rando_ow_pal[29, 3] = $0F;
    global.rando_ow_pal[29, 4] = $10;
    global.rando_ow_pal[29, 5] = $00;
    global.rando_ow_pal[29, 6] = $0F;
    global.rando_ow_pal[29, 7] = "Questwizard";

    global.rando_ow_pal[30, 0] = "NES Palette (Column 0)";
    global.rando_ow_pal[30, 1] = $10;
    global.rando_ow_pal[30, 2] = $20;
    global.rando_ow_pal[30, 3] = $00;
    global.rando_ow_pal[30, 4] = $10;
    global.rando_ow_pal[30, 5] = $20;
    global.rando_ow_pal[30, 6] = $00;
    global.rando_ow_pal[30, 7] = "Questwizard";

    global.rando_ow_pal[31, 0] = "NES Palette (Column 1)";
    global.rando_ow_pal[31, 1] = $11;
    global.rando_ow_pal[31, 2] = $21;
    global.rando_ow_pal[31, 3] = $01;
    global.rando_ow_pal[31, 4] = $11;
    global.rando_ow_pal[31, 5] = $21;
    global.rando_ow_pal[31, 6] = $01;
    global.rando_ow_pal[31, 7] = "Questwizard";

    global.rando_ow_pal[32, 0] = "NES Palette (Column 2)";
    global.rando_ow_pal[32, 1] = $12;
    global.rando_ow_pal[32, 2] = $22;
    global.rando_ow_pal[32, 3] = $02;
    global.rando_ow_pal[32, 4] = $12;
    global.rando_ow_pal[32, 5] = $22;
    global.rando_ow_pal[32, 6] = $02;
    global.rando_ow_pal[32, 7] = "Questwizard";

    global.rando_ow_pal[33, 0] = "NES Palette (Column 3)";
    global.rando_ow_pal[33, 1] = $13;
    global.rando_ow_pal[33, 2] = $23;
    global.rando_ow_pal[33, 3] = $03;
    global.rando_ow_pal[33, 4] = $13;
    global.rando_ow_pal[33, 5] = $23;
    global.rando_ow_pal[33, 6] = $03;
    global.rando_ow_pal[33, 7] = "Questwizard";

    global.rando_ow_pal[34, 0] = "NES Palette (Column 4)";
    global.rando_ow_pal[34, 1] = $14;
    global.rando_ow_pal[34, 2] = $24;
    global.rando_ow_pal[34, 3] = $04;
    global.rando_ow_pal[34, 4] = $14;
    global.rando_ow_pal[34, 5] = $24;
    global.rando_ow_pal[34, 6] = $04;
    global.rando_ow_pal[34, 7] = "Questwizard";

    global.rando_ow_pal[35, 0] = "NES Palette (Column 5)";
    global.rando_ow_pal[35, 1] = $15;
    global.rando_ow_pal[35, 2] = $25;
    global.rando_ow_pal[35, 3] = $05;
    global.rando_ow_pal[35, 4] = $15;
    global.rando_ow_pal[35, 5] = $25;
    global.rando_ow_pal[35, 6] = $05;
    global.rando_ow_pal[35, 7] = "Questwizard";

    global.rando_ow_pal[36, 0] = "NES Palette (Column 6)";
    global.rando_ow_pal[36, 1] = $16;
    global.rando_ow_pal[36, 2] = $26;
    global.rando_ow_pal[36, 3] = $06;
    global.rando_ow_pal[36, 4] = $16;
    global.rando_ow_pal[36, 5] = $26;
    global.rando_ow_pal[36, 6] = $06;
    global.rando_ow_pal[36, 7] = "Questwizard";

    global.rando_ow_pal[37, 0] = "NES Palette (Column 7)";
    global.rando_ow_pal[37, 1] = $17;
    global.rando_ow_pal[37, 2] = $27;
    global.rando_ow_pal[37, 3] = $07;
    global.rando_ow_pal[37, 4] = $17;
    global.rando_ow_pal[37, 5] = $27;
    global.rando_ow_pal[37, 6] = $07;
    global.rando_ow_pal[37, 7] = "Questwizard";

    global.rando_ow_pal[38, 0] = "NES Palette (Column 8)";
    global.rando_ow_pal[38, 1] = $18;
    global.rando_ow_pal[38, 2] = $28;
    global.rando_ow_pal[38, 3] = $08;
    global.rando_ow_pal[38, 4] = $18;
    global.rando_ow_pal[38, 5] = $28;
    global.rando_ow_pal[38, 6] = $08;
    global.rando_ow_pal[38, 7] = "Questwizard";

    global.rando_ow_pal[39, 0] = "NES Palette (Column 9)";
    global.rando_ow_pal[39, 1] = $19;
    global.rando_ow_pal[39, 2] = $29;
    global.rando_ow_pal[39, 3] = $09;
    global.rando_ow_pal[39, 4] = $19;
    global.rando_ow_pal[39, 5] = $29;
    global.rando_ow_pal[39, 6] = $09;
    global.rando_ow_pal[39, 7] = "Questwizard";

    global.rando_ow_pal[40, 0] = "NES Palette (Column A)";
    global.rando_ow_pal[40, 1] = $1A;
    global.rando_ow_pal[40, 2] = $2A;
    global.rando_ow_pal[40, 3] = $0A;
    global.rando_ow_pal[40, 4] = $1A;
    global.rando_ow_pal[40, 5] = $2A;
    global.rando_ow_pal[40, 6] = $0A;
    global.rando_ow_pal[40, 7] = "Questwizard";

    global.rando_ow_pal[41, 0] = "NES Palette (Column B)";
    global.rando_ow_pal[41, 1] = $1B;
    global.rando_ow_pal[41, 2] = $2B;
    global.rando_ow_pal[41, 3] = $0B;
    global.rando_ow_pal[41, 4] = $1B;
    global.rando_ow_pal[41, 5] = $2B;
    global.rando_ow_pal[41, 6] = $0B;
    global.rando_ow_pal[41, 7] = "Questwizard";

    global.rando_ow_pal[42, 0] = "NES Palette (Column C)";
    global.rando_ow_pal[42, 1] = $1C;
    global.rando_ow_pal[42, 2] = $2C;
    global.rando_ow_pal[42, 3] = $0C;
    global.rando_ow_pal[42, 4] = $1C;
    global.rando_ow_pal[42, 5] = $2C;
    global.rando_ow_pal[42, 6] = $0C;
    global.rando_ow_pal[42, 7] = "Questwizard";

    global.rando_ow_pal[43, 0] = "Wasteland";
    global.rando_ow_pal[43, 1] = $18;
    global.rando_ow_pal[43, 2] = $28;
    global.rando_ow_pal[43, 3] = $19;
    global.rando_ow_pal[43, 4] = $18;
    global.rando_ow_pal[43, 5] = $28;
    global.rando_ow_pal[43, 6] = $19;
    global.rando_ow_pal[43, 7] = "Questwizard";

    global.rando_ow_pal[44, 0] = "CGA (Warlock82's CGA Dgn.)";
    global.rando_ow_pal[44, 1] = $24;
    global.rando_ow_pal[44, 2] = $30;
    global.rando_ow_pal[44, 3] = $2C;
    global.rando_ow_pal[44, 4] = $24;
    global.rando_ow_pal[44, 5] = $30;
    global.rando_ow_pal[44, 6] = $2C;
    global.rando_ow_pal[44, 7] = "Warlock82";

    global.rando_ow_pal[45, 0] = "Fiery (Orange/Red)";
    global.rando_ow_pal[45, 1] = $17;
    global.rando_ow_pal[45, 2] = $26;
    global.rando_ow_pal[45, 3] = $06;
    global.rando_ow_pal[45, 4] = $16;
    global.rando_ow_pal[45, 5] = $26;
    global.rando_ow_pal[45, 6] = $06;
    global.rando_ow_pal[45, 7] = "Questwizard";
    
    global.rando_ow_pal[46, 0] = "Negative (Both)";
    global.rando_ow_pal[46, 1] = $24;
    global.rando_ow_pal[46, 2] = $0C;
    global.rando_ow_pal[46, 3] = $28;
    global.rando_ow_pal[46, 4] = $21;
    global.rando_ow_pal[46, 5] = $0C;
    global.rando_ow_pal[46, 6] = $28;
    global.rando_ow_pal[46, 7] = "Devan2002";
    
    global.rando_ow_pal[47, 0] = "Negative (Brightness Only)";
    global.rando_ow_pal[47, 1] = $0A;
    global.rando_ow_pal[47, 2] = $0F;
    global.rando_ow_pal[47, 3] = $02;
    global.rando_ow_pal[47, 4] = $07;
    global.rando_ow_pal[47, 5] = $0F;
    global.rando_ow_pal[47, 6] = $02;
    global.rando_ow_pal[47, 7] = "Devan2002";
    
    global.rando_ow_pal[48, 0] = "Negative (Color Only)";
    global.rando_ow_pal[48, 1] = $1A;
    global.rando_ow_pal[48, 2] = $32;
    global.rando_ow_pal[48, 3] = $17;
    global.rando_ow_pal[48, 4] = $12;
    global.rando_ow_pal[48, 5] = $32;
    global.rando_ow_pal[48, 6] = $17;
    global.rando_ow_pal[48, 7] = "Devan2002";
}

//rando overworld init
//random ow maze generator objects
for(i = 0; i < 128; i += 1){
    for(j = 0; j < 5; j += 1){
        cell[i, j] = 0;
        coll[i] = instance_create(((i mod 16) * 3) + 128, ((i div 16) * 3) + 128, o_map_rando_ow_collision);
        coll[i].inst_num = i;
    }
}

instance_create(129 + 21, 129 + 21, o_map_rando_player);

dirs = ds_list_create();
list = ds_list_create();

