//arg0 = new screen, arg1 = old screen
var dat_old, dat_new;

//get data
dat_old = ds_grid_get(global.inst_ctrl_server.grd_dgn_classic_icons, 0, argument1);
dat_new = ds_grid_get(global.inst_ctrl_server.grd_dgn_icons, 0, argument0);

//sync icon data
if((dat_new != 0 && dat_new != 2) && (dat_old == 0 || dat_old == 2)){ //new better than old
    ds_grid_set(global.inst_ctrl_server.grd_dgn_classic_icons, 0, argument1, dat_new);
}
else if((dat_old != 0 && dat_old != 2) && (dat_new == 0 || dat_new == 2)){ // old better than new
    ds_grid_set(global.inst_ctrl_server.grd_dgn_icons, 0, argument0, dat_old);
}
else if(dat_new == 2 && dat_old == 0){ //old unknown, new empty
    ds_grid_set(global.inst_ctrl_server.grd_dgn_classic_icons, 0, argument1, 2);
}
else if(dat_old == 2 && dat_new == 0){ //new unknown, old empty
    ds_grid_set(global.inst_ctrl_server.grd_dgn_icons, 0, argument0, 2);
}
else if(dat_old == dat_new){ //equal
    //do nothing
}
else{ //discrepancy, so report it to the server as somebody may have marked something wrong
    if(!audio_is_playing(snd_server_error) && global.server_audio_alerts){
        audio_play_sound(snd_server_error, 100, 0);
    }
    zh_server_msg("WARNING: Conflicting dungeon icon found! Somebody may have");
    zh_server_msg("marked something wrong! New map D" + string((argument0 div 64) + 1) + ", Classic map C" + string((argument1 div 128) + 1) + ", screen " + zh_get_hex_char(argument1 mod 128) + ".");
    zh_server_msg("Skipping this cell due to the conflict.");
}

//sync marker data
for(i = 0; i < 8; i += 1){
    dat_new = ds_grid_get(global.inst_ctrl_server.grd_dgn_icons_marker, 0, ((argument0 div 64) * 512) + (i * 128) + (argument0 mod 64));
    dat_old = ds_grid_get(global.inst_ctrl_server.grd_dgn_classic_icons_marker, 0, ((argument1 div 128) * 1024) + (i * 128) + (argument1 mod 128));

    if(dat_old != 0 || dat_new != 0){
        ds_grid_set(global.inst_ctrl_server.grd_dgn_icons_marker, 0, ((argument0 div 64) * 512) + (i * 128) + (argument0 mod 64), 1);
        ds_grid_set(global.inst_ctrl_server.grd_dgn_classic_icons_marker, 0, ((argument1 div 128) * 1024) + (i * 128) + (argument1 mod 128), 1);
    }
    else{
        ds_grid_set(global.inst_ctrl_server.grd_dgn_icons_marker, 0, ((argument0 div 64) * 512) + (i * 128) + (argument0 mod 64), 0);
        ds_grid_set(global.inst_ctrl_server.grd_dgn_classic_icons_marker, 0, ((argument1 div 128) * 1024) + (i * 128) + (argument1 mod 128), 0);
    }
}
