//reset cells
valid = 0;
num = 0;
ds_list_clear(dirs);
ds_list_clear(list);
ds_list_add(dirs, 0);
ds_list_add(dirs, 1);
ds_list_add(dirs, 2);
ds_list_add(dirs, 3);
for(i = 0; i < 128; i += 1){
    for(j = 0; j < 5; j += 1){
        cell[i, j] = 0;
    }
}

//pick starting cell
index = irandom(127)
ds_list_add(list, index);
cell[index, 4] = 1;

//make it!
do{
    //pick cell
    index = ds_list_find_value(list, irandom(ds_list_size(list) - 1));
    cx = index mod 16;
    cy = index div 16;
    
    //make list of directions randomized
    ds_list_shuffle(dirs);
    
    //go through each direction until an unvisited neighbor is found
    dircheck = 0;
    do{
        valid = 0;
        cx = index mod 16;
        cy = index div 16;
        switch(dirs[| dircheck]){
            case 0:
                cx -= 1;
            break;
            case 1:
                cx += 1;
            break;
            case 2:
                cy -= 1;
            break;
            case 3:
                cy += 1;
        }
        if(cx >= 0 && cy >= 0 && cx < 16 && cy < 8){
            if(cell[(cy * 16) + cx, 4] == 0){ //make path if valid
                switch(dirs[| dircheck]){
                    case 0:
                        cell[index, 0] = 1;
                        cell[(cy * 16) + cx, 1] = 1;
                        cell[index, 4] = 1;
                        cell[(cy * 16) + cx, 4] = 1;
                        ds_list_add(list, (cy * 16) + cx);
                        valid = 1;
                    break;
                    case 1:
                        cell[index, 1] = 1;
                        cell[(cy * 16) + cx, 0] = 1;
                        cell[index, 4] = 1;
                        cell[(cy * 16) + cx, 4] = 1;
                        ds_list_add(list, (cy * 16) + cx);
                        valid = 1;
                    break;
                    case 2:
                        cell[index, 2] = 1;
                        cell[(cy * 16) + cx, 3] = 1;
                        cell[index, 4] = 1;
                        cell[(cy * 16) + cx, 4] = 1;
                        ds_list_add(list, (cy * 16) + cx);
                        valid = 1;
                    break;
                    case 3:
                        cell[index, 3] = 1;
                        cell[(cy * 16) + cx, 2] = 1;
                        cell[index, 4] = 1;
                        cell[(cy * 16) + cx, 4] = 1;
                        ds_list_add(list, (cy * 16) + cx);
                        valid = 1;
                }
            }
        }
        dircheck += 1;
        if(valid){
            break;
        }
    } until(dircheck > 3);
    if(!valid){ //no neighbor so kill it
        num += 1;
        ds_list_delete(list, ds_list_find_index(list, index));
    }
} until(ds_list_empty(list));

//set forced paths
//path values: 2 = force enable, -1 = force disable, 3 = sanity checker correction, 4 = bonus path maker
//path sides:
//0 = left
//1 = right
//2 = up
//3 = down
cell[5, 1] = 2;
cell[6, 0] = 2;
cell[6, 1] = 2;
cell[6, 2] = -1;
cell[6, 3] = -1;
cell[7, 0] = 2;
cell[7, 1] = 2;
cell[8, 0] = 2;
cell[8, 1] = 2;
cell[8, 2] = -1;
cell[8, 3] = -1;
cell[9, 0] = 2;
cell[9, 3] = -1;
cell[10, 1] = -1;
cell[11, 0] = -1;
cell[11, 1] = -1;
cell[11, 3] = 2;
cell[12, 0] = -1;
cell[14, 1] = -1;
cell[14, 3] = 2;
cell[15, 0] = -1;
cell[15, 3] = 2;
cell[18, 3] = -1;
cell[22, 1] = 2;
cell[22, 2] = -1;
cell[23, 0] = 2;
cell[23, 1] = -1;
cell[23, 3] = -1;
cell[24, 0] = -1;
cell[24, 1] = 2;
cell[24, 2] = -1;
cell[25, 0] = 2;
cell[25, 1] = 2;
cell[25, 2] = -1;
cell[26, 0] = 2;
cell[26, 1] = 2;
cell[27, 0] = 2;
cell[27, 1] = -1;
cell[27, 2] = 2;
cell[27, 3] = -1;
cell[28, 1] = -1;
cell[29, 0] = -1;
cell[29, 1] = 2;
cell[29, 3] = 2;
cell[30, 0] = 2;
cell[30, 1] = 2;
cell[30, 2] = 2;
cell[30, 3] = -1;
cell[31, 0] = 2;
cell[31, 2] = 2;
cell[31, 3] = -1;
cell[32, 3] = 2;
cell[33, 3] = 2;
cell[34, 1] = -1;
cell[34, 2] = -1;
cell[35, 0] = -1;
cell[36, 1] = 2;
cell[37, 0] = 2;
cell[38, 1] = 2;
cell[39, 0] = 2;
cell[39, 1] = -1;
cell[39, 2] = -1;
cell[39, 3] = -1;
cell[40, 0] = -1;
cell[41, 3] = -1;
cell[44, 3] = -1;
cell[45, 2] = 2;
cell[46, 1] = -1;
cell[46, 2] = -1;
cell[47, 0] = -1;
cell[47, 2] = -1;
cell[47, 3] = 2;
cell[48, 2] = 2;
cell[48, 3] = 2;
cell[49, 2] = 2;
cell[49, 3] = 2;
cell[50, 3] = -1;
cell[51, 3] = -1;
cell[53, 3] = -1;
cell[54, 3] = -1;
cell[55, 2] = -1;
cell[55, 3] = -1;
cell[56, 1] = -1;
cell[57, 0] = -1;
cell[57, 1] = -1;
cell[57, 2] = -1;
cell[57, 3] = 2;
cell[58, 0] = -1;
cell[59, 1] = -1;
cell[59, 3] = 2;
cell[60, 0] = -1;
cell[60, 1] = -1;
cell[60, 2] = -1;
cell[60, 3] = 2;
cell[61, 0] = -1;
cell[63, 2] = 2;
cell[63, 3] = 2;
cell[64, 2] = 2;
cell[65, 1] = -1;
cell[65, 2] = 2;
cell[66, 0] = -1;
cell[66, 1] = -1;
cell[66, 2] = -1;
cell[66, 3] = 2;
cell[67, 0] = -1;
cell[67, 1] = -1;
cell[67, 2] = -1;
cell[67, 3] = 2;
cell[68, 0] = -1;
cell[68, 1] = -1;
cell[69, 0] = -1;
cell[69, 1] = -1;
cell[69, 2] = -1;
cell[69, 3] = 2;
cell[70, 0] = -1;
cell[70, 1] = 2;
cell[70, 2] = -1;
cell[71, 0] = 2;
cell[71, 1] = 2;
cell[71, 2] = -1;
cell[72, 0] = 2;
cell[73, 2] = 2;
cell[75, 0] = -1;
cell[75, 2] = 2;
cell[75, 3] = 2;
cell[76, 2] = 2;
cell[78, 1] = -1;
cell[78, 3] = -1;
cell[79, 0] = -1;
cell[79, 2] = 2;
cell[79, 3] = 2;
cell[82, 2] = 2;
cell[83, 2] = 2;
cell[85, 0] = -1;
cell[85, 1] = -1;
cell[85, 2] = 2;
cell[85, 3] = 2;
cell[89, 1] = 2;
cell[90, 0] = 2;
cell[91, 2] = 2;
cell[93, 1] = 2;
cell[94, 0] = 2;
cell[94, 1] = -1;
cell[94, 2] = -1;
cell[94, 3] = -1;
cell[95, 0] = -1;
cell[95, 2] = 2;
cell[95, 3] = 2;
cell[96, 1] = 2;
cell[97, 0] = 2;
cell[97, 1] = 2;
cell[97, 2] = -1;
cell[97, 3] = -1;
cell[98, 0] = 2;
cell[100, 3] = -1;
cell[101, 2] = 2;
cell[105, 1] = 2;
cell[106, 0] = 2;
cell[106, 3] = -1;
cell[108, 3] = -1;
cell[109, 3] = -1;
cell[110, 2] = -1;
cell[111, 2] = 2;
cell[115, 1] = 2;
cell[116, 0] = 2;
cell[116, 1] = -1;
cell[116, 2] = -1;
cell[117, 0] = -1;
cell[121, 1] = 2;
cell[122, 0] = 2;
cell[122, 1] = 2;
cell[122, 2] = -1;
cell[123, 0] = 2;
cell[123, 1] = 2;
cell[124, 0] = 2;
cell[124, 1] = 2;
cell[124, 2] = -1;
cell[125, 0] = 2;
cell[125, 1] = 2;
cell[125, 2] = -1;
cell[126, 0] = 2;

//bonus path maker (just makes a bunch of paths, mostly vertical
repeat(40){
    //pick a screen
    screen = irandom(127);
    
    //check if its next to a screen that's not connected/disconnected already
    //and connect it if it can be (vertical bias)
    sx = screen mod 16;
    sy = screen div 16;
    if(sy == 0){ //top
        if(sx == 0){ //top left
            if(cell[screen, 3] == 0 && cell[sx + ((sy + 1) * 16), 2] == 0){ //y + 1
                cell[screen, 3] = 4;
                cell[sx + ((sy + 1) * 16), 2] = 4;
            }
            else if(cell[screen, 1] == 0 && cell[(sx + 1) + (sy * 16), 0] == 0){ //x + 1
                cell[screen, 1] = 4;
                cell[(sx + 1) + (sy * 16), 0] = 4;
            }
        }
        else if(sx == 15){ //top right
            if(cell[screen, 3] == 0 && cell[sx + ((sy + 1) * 16), 2] == 0){ //y + 1
                cell[screen, 3] = 4;
                cell[sx + ((sy + 1) * 16), 2] = 4;
            }
            else if(cell[screen, 0] == 0 && cell[(sx - 1) + (sy * 16), 1] == 0){ //x - 1
                cell[screen, 0] = 4;
                cell[(sx - 1) + (sy * 16), 1] = 4;
            }
        }
        else{ //top middle
            if(cell[screen, 3] == 0 && cell[sx + ((sy + 1) * 16), 2] == 0){ //y + 1
                cell[screen, 3] = 4;
                cell[sx + ((sy + 1) * 16), 2] = 4;
            }
            else if(cell[screen, 0] == 0 && cell[(sx - 1) + (sy * 16), 1] == 0){ //x - 1
                cell[screen, 0] = 4;
                cell[(sx - 1) + (sy * 16), 1] = 4;
            }
            else if(cell[screen, 1] == 0 && cell[(sx + 1) + (sy * 16), 0] == 0){ //x + 1
                cell[screen, 1] = 4;
                cell[(sx + 1) + (sy * 16), 0] = 4;
            }
        }
    }
    else if(sy == 7){ //bottom
        if(sx == 0){ //bottom left
            if(cell[screen, 2] == 0 && cell[sx + ((sy - 1) * 16), 3] == 0){ //y - 1
                cell[screen, 2] = 4;
                cell[sx + ((sy - 1) * 16), 3] = 4;
            }
            else if(cell[screen, 1] == 0 && cell[(sx + 1) + (sy * 16), 0] == 0){ //x + 1
                cell[screen, 1] = 4;
                cell[(sx + 1) + (sy * 16), 0] = 4;
            }
        }
        else if(sx == 15){ //bottom right
            if(cell[screen, 2] == 0 && cell[sx + ((sy - 1) * 16), 3] == 0){ //y - 1
                cell[screen, 2] = 4;
                cell[sx + ((sy - 1) * 16), 3] = 4;
            }
            else if(cell[screen, 0] == 0 && cell[(sx - 1) + (sy * 16), 1] == 0){ //x - 1
                cell[screen, 0] = 4;
                cell[(sx - 1) + (sy * 16), 1] = 4;
            }
        }
        else{ //bottom middle
            if(cell[screen, 2] == 0 && cell[sx + ((sy - 1) * 16), 3] == 0){ //y - 1
                cell[screen, 2] = 4;
                cell[sx + ((sy - 1) * 16), 3] = 4;
            }
            else if(cell[screen, 0] == 0 && cell[(sx - 1) + (sy * 16), 1] == 0){ //x - 1
                cell[screen, 0] = 4;
                cell[(sx - 1) + (sy * 16), 1] = 4;
            }
            else if(cell[screen, 1] == 0 && cell[(sx + 1) + (sy * 16), 0] == 0){ //x + 1
                cell[screen, 1] = 4;
                cell[(sx + 1) + (sy * 16), 0] = 4;
            }
        }
    }
    else{ //middle
        if(sx == 0){ //middle left
            if(cell[screen, 2] == 0 && cell[sx + ((sy - 1) * 16), 3] == 0){ //y - 1
                cell[screen, 2] = 4;
                cell[sx + ((sy - 1) * 16), 3] = 4;
            }
            else if(cell[screen, 3] == 0 && cell[sx + ((sy + 1) * 16), 2] == 0){ //y + 1
                cell[screen, 3] = 4;
                cell[sx + ((sy + 1) * 16), 2] = 4;
            }
            else if(cell[screen, 1] == 0 && cell[(sx + 1) + (sy * 16), 0] == 0){ //x + 1
                cell[screen, 1] = 4;
                cell[(sx + 1) + (sy * 16), 0] = 4;
            }
        }
        else if(sx == 15){ //middle right
            if(cell[screen, 2] == 0 && cell[sx + ((sy - 1) * 16), 3] == 0){ //y - 1
                cell[screen, 2] = 4;
                cell[sx + ((sy - 1) * 16), 3] = 4;
            }
            else if(cell[screen, 3] == 0 && cell[sx + ((sy + 1) * 16), 2] == 0){ //y + 1
                cell[screen, 3] = 4;
                cell[sx + ((sy + 1) * 16), 2] = 4;
            }
            else if(cell[screen, 0] == 0 && cell[(sx - 1) + (sy * 16), 1] == 0){ //x - 1
                cell[screen, 0] = 4;
                cell[(sx - 1) + (sy * 16), 1] = 4;
            }
        }
        else{ //middle
            if(cell[screen, 2] == 0 && cell[sx + ((sy - 1) * 16), 3] == 0){ //y - 1
                cell[screen, 2] = 4;
                cell[sx + ((sy - 1) * 16), 3] = 4;
            }
            else if(cell[screen, 3] == 0 && cell[sx + ((sy + 1) * 16), 2] == 0){ //y + 1
                cell[screen, 3] = 4;
                cell[sx + ((sy + 1) * 16), 2] = 4;
            }
            else if(cell[screen, 0] == 0 && cell[(sx - 1) + (sy * 16), 1] == 0){ //x - 1
                cell[screen, 0] = 4;
                cell[(sx - 1) + (sy * 16), 1] = 4;
            }
            else if(cell[screen, 1] == 0 && cell[(sx + 1) + (sy * 16), 0] == 0){ //x + 1
                cell[screen, 1] = 4;
                cell[(sx + 1) + (sy * 16), 0] = 4;
            }
        }
    }
}

//sanity check: fix any unreachable screens by randomly making paths to unreachable screens from reachable ones
//determine how many screens are reachable
reachable = 0;
with(o_map_rando_player){
    event_user(0);
}
for(i = 0; i < 128; i += 1){
    if(o_map_rando_player.valid[i]){
        reachable += 1;
    }
}

//fix unreachables
if(reachable < 128){
    do{
        //determine how many screens are reachable
        reachable = 0;
        with(o_map_rando_player){
            event_user(0);
        }
        for(i = 0; i < 128; i += 1){
            if(o_map_rando_player.valid[i]){
                reachable += 1;
            }
        }
        if(reachable == 128){break;} //bail if we're done
        
        do{ //not done, so keep going
            //pick a screen until we hit one that is unreachable
            goodcandidate = 0;
            do{
                screen = irandom(127);
            } until(!o_map_rando_player.valid[screen]);
            
            //output debug info showing map paths and seed
            /*dbgstr = "";
            dbgfs = file_text_open_write("debug.txt");
            for(f = 0; f < 8; f += 1){
                for(g = 0; g < 16; g += 1){
                    dbgstr += "　";
                    switch(cell[(f * 16) + g, 2]){
                        case -1:
                            dbgstr += "・";
                        break;
                        case 0:
                            dbgstr += "　";
                        break;
                        case 1:
                            dbgstr += "┃";
                        break;
                        case 2:
                            dbgstr += "↑";
                        break;
                        case 3:
                            dbgstr += "✓";
                        break;
                        case 4:
                            dbgstr += "★";
                        break;
                        default:
                            dbgstr += "？";
                    }
                    dbgstr += "　";
                }
                file_text_write_string(dbgfs, dbgstr);
                file_text_writeln(dbgfs);
                dbgstr = "";
                for(g = 0; g < 16; g += 1){
                    switch(cell[(f * 16) + g, 0]){
                        case -1:
                            dbgstr += "・";
                        break;
                        case 0:
                            dbgstr += "　";
                        break;
                        case 1:
                            dbgstr += "━";
                        break;
                        case 2:
                            dbgstr += "←";
                        break;
                        case 3:
                            dbgstr += "✓";
                        break;
                        case 4:
                            dbgstr += "★";
                        break;
                        default:
                            dbgstr += "？";
                    }
                    dbgstr += "■";
                    switch(cell[(f * 16) + g, 1]){
                        case -1:
                            dbgstr += "・";
                        break;
                        case 0:
                            dbgstr += "　";
                        break;
                        case 1:
                            dbgstr += "━";
                        break;
                        case 2:
                            dbgstr += "→";
                        break;
                        case 3:
                            dbgstr += "✓";
                        break;
                        case 4:
                            dbgstr += "★";
                        break;
                        default:
                            dbgstr += "？";
                    }
                }
                file_text_write_string(dbgfs, dbgstr);
                file_text_writeln(dbgfs);
                dbgstr = "";
                for(g = 0; g < 16; g += 1){
                    dbgstr += "　";
                    switch(cell[(f * 16) + g, 3]){
                        case -1:
                            dbgstr += "・";
                        break;
                        case 0:
                            dbgstr += "　";
                        break;
                        case 1:
                            dbgstr += "┃";
                        break;
                        case 2:
                            dbgstr += "↓";
                        break;
                        case 3:
                            dbgstr += "✓";
                        break;
                        case 4:
                            dbgstr += "★";
                        break;
                        default:
                            dbgstr += "？";
                    }
                    dbgstr += "　";
                }
                file_text_write_string(dbgfs, dbgstr);
                file_text_writeln(dbgfs);
                dbgstr = "";
            }
            file_text_write_string(dbgfs, string(global.rando_seed));
            file_text_close(dbgfs);*/
            
            //check if its next to a reachable screen that's not connected/disconnected by force
            //and fix it if it can be (horizontal bias)
            sx = screen mod 16;
            sy = screen div 16;
            if(sy == 0){ //top
                if(sx == 0){ //top left
                    if(cell[screen, 1] == 0 && cell[(sx + 1) + (sy * 16), 0] == 0){ //x + 1
                        cell[screen, 1] = 3;
                        cell[(sx + 1) + (sy * 16), 0] = 3;
                        goodcandidate = 1;
                    }
                    else if(cell[screen, 3] == 0 && cell[sx + ((sy + 1) * 16), 2] == 0){ //y + 1
                        cell[screen, 3] = 3;
                        cell[sx + ((sy + 1) * 16), 2] = 3;
                        goodcandidate = 1;
                    }
                }
                else if(sx == 15){ //top right
                    if(cell[screen, 0] == 0 && cell[(sx - 1) + (sy * 16), 1] == 0){ //x - 1
                        cell[screen, 0] = 3;
                        cell[(sx - 1) + (sy * 16), 1] = 3;
                        goodcandidate = 1;
                    }
                    else if(cell[screen, 3] == 0 && cell[sx + ((sy + 1) * 16), 2] == 0){ //y + 1
                        cell[screen, 3] = 3;
                        cell[sx + ((sy + 1) * 16), 2] = 3;
                        goodcandidate = 1;
                    }
                }
                else{ //top middle
                    if(cell[screen, 0] == 0 && cell[(sx - 1) + (sy * 16), 1] == 0){ //x - 1
                        cell[screen, 0] = 3;
                        cell[(sx - 1) + (sy * 16), 1] = 3;
                        goodcandidate = 1;
                    }
                    else if(cell[screen, 1] == 0 && cell[(sx + 1) + (sy * 16), 0] == 0){ //x + 1
                        cell[screen, 1] = 3;
                        cell[(sx + 1) + (sy * 16), 0] = 3;
                        goodcandidate = 1;
                    }
                    else if(cell[screen, 3] == 0 && cell[sx + ((sy + 1) * 16), 2] == 0){ //y + 1
                        cell[screen, 3] = 3;
                        cell[sx + ((sy + 1) * 16), 2] = 3;
                        goodcandidate = 1;
                    }
                }
            }
            else if(sy == 7){ //bottom
                if(sx == 0){ //bottom left
                    if(cell[screen, 1] == 0 && cell[(sx + 1) + (sy * 16), 0] == 0){ //x + 1
                        cell[screen, 1] = 3;
                        cell[(sx + 1) + (sy * 16), 0] = 3;
                        goodcandidate = 1;
                    }
                    else if(cell[screen, 2] == 0 && cell[sx + ((sy - 1) * 16), 3] == 0){ //y - 1
                        cell[screen, 2] = 3;
                        cell[sx + ((sy - 1) * 16), 3] = 3;
                        goodcandidate = 1;
                    }
                }
                else if(sx == 15){ //bottom right
                    if(cell[screen, 0] == 0 && cell[(sx - 1) + (sy * 16), 1] == 0){ //x - 1
                        cell[screen, 0] = 3;
                        cell[(sx - 1) + (sy * 16), 1] = 3;
                        goodcandidate = 1;
                    }
                    else if(cell[screen, 2] == 0 && cell[sx + ((sy - 1) * 16), 3] == 0){ //y - 1
                        cell[screen, 2] = 3;
                        cell[sx + ((sy - 1) * 16), 3] = 3;
                        goodcandidate = 1;
                    }
                }
                else{ //bottom middle
                    if(cell[screen, 0] == 0 && cell[(sx - 1) + (sy * 16), 1] == 0){ //x - 1
                        cell[screen, 0] = 3;
                        cell[(sx - 1) + (sy * 16), 1] = 3;
                        goodcandidate = 1;
                    }
                    else if(cell[screen, 1] == 0 && cell[(sx + 1) + (sy * 16), 0] == 0){ //x + 1
                        cell[screen, 1] = 3;
                        cell[(sx + 1) + (sy * 16), 0] = 3;
                        goodcandidate = 1;
                    }
                    else if(cell[screen, 2] == 0 && cell[sx + ((sy - 1) * 16), 3] == 0){ //y - 1
                        cell[screen, 2] = 3;
                        cell[sx + ((sy - 1) * 16), 3] = 3;
                        goodcandidate = 1;
                    }
                }
            }
            else{ //middle
                if(sx == 0){ //middle left
                    if(cell[screen, 1] == 0 && cell[(sx + 1) + (sy * 16), 0] == 0){ //x + 1
                        cell[screen, 1] = 3;
                        cell[(sx + 1) + (sy * 16), 0] = 3;
                        goodcandidate = 1;
                    }
                    else if(cell[screen, 2] == 0 && cell[sx + ((sy - 1) * 16), 3] == 0){ //y - 1
                        cell[screen, 2] = 3;
                        cell[sx + ((sy - 1) * 16), 3] = 3;
                        goodcandidate = 1;
                    }
                    else if(cell[screen, 3] == 0 && cell[sx + ((sy + 1) * 16), 2] == 0){ //y + 1
                        cell[screen, 3] = 3;
                        cell[sx + ((sy + 1) * 16), 2] = 3;
                        goodcandidate = 1;
                    }
                }
                else if(sx == 15){ //middle right
                    if(cell[screen, 0] == 0 && cell[(sx - 1) + (sy * 16), 1] == 0){ //x - 1
                        cell[screen, 0] = 3;
                        cell[(sx - 1) + (sy * 16), 1] = 3;
                        goodcandidate = 1;
                    }
                    else if(cell[screen, 2] == 0 && cell[sx + ((sy - 1) * 16), 3] == 0){ //y - 1
                        cell[screen, 2] = 3;
                        cell[sx + ((sy - 1) * 16), 3] = 3;
                        goodcandidate = 1;
                    }
                    else if(cell[screen, 3] == 0 && cell[sx + ((sy + 1) * 16), 2] == 0){ //y + 1
                        cell[screen, 3] = 3;
                        cell[sx + ((sy + 1) * 16), 2] = 3;
                        goodcandidate = 1;
                    }
                }
                else{ //middle
                    if(cell[screen, 0] == 0 && cell[(sx - 1) + (sy * 16), 1] == 0){ //x - 1
                        cell[screen, 0] = 3;
                        cell[(sx - 1) + (sy * 16), 1] = 3;
                        goodcandidate = 1;
                    }
                    else if(cell[screen, 1] == 0 && cell[(sx + 1) + (sy * 16), 0] == 0){ //x + 1
                        cell[screen, 1] = 3;
                        cell[(sx + 1) + (sy * 16), 0] = 3;
                        goodcandidate = 1;
                    }
                    else if(cell[screen, 2] == 0 && cell[sx + ((sy - 1) * 16), 3] == 0){ //y - 1
                        cell[screen, 2] = 3;
                        cell[sx + ((sy - 1) * 16), 3] = 3;
                        goodcandidate = 1;
                    }
                    else if(cell[screen, 3] == 0 && cell[sx + ((sy + 1) * 16), 2] == 0){ //y + 1
                        cell[screen, 3] = 3;
                        cell[sx + ((sy + 1) * 16), 2] = 3;
                        goodcandidate = 1;
                    }
                }
            }
            //show_message(str);
        } until(goodcandidate);
    } until(reachable == 128);
}

//change overworld screen data according to the generated layout
//path values: 2 = force enable, -1 = force disable, 3 = sanity checker correction, 4 = bonus path maker
//0 = disabled, 1 = enabled
//path sides:
//0 = left
//1 = right
//2 = up
//3 = down
//NOTE: i the layout number, not the actual screen coords! scr is the screen coords!
for(i = 0; i < 128; i += 1){
    switch(i){
        case 0:
            scr = 0;
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 1);
            }
        break;
        case 1:
            scr = 1;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 6);
            }
        break;
        case 2:
            scr = 2;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 231);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 1);
            }
        break;
        case 3:
            scr = 3;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 234);
                buffer_write(buf_out, buffer_u8, 169);
            }
            if(cell[scr, 1] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 1);
                buffer_write(buf_out, buffer_u8, 1);
                buffer_write(buf_out, buffer_u8, 1);
                buffer_write(buf_out, buffer_u8, 1);
                buffer_write(buf_out, buffer_u8, 1);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 10);
                buffer_write(buf_out, buffer_u8, 1);
            }
        break;
        case 4:
            scr = 4;
            if(cell[scr, 0] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 167);
                buffer_write(buf_out, buffer_u8, 234);
                buffer_write(buf_out, buffer_u8, 169);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 200);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 168);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 175);
            }
        break;
        case 5:
            scr = 5;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 169);
                buffer_write(buf_out, buffer_u8, 2);
            }
            if(cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 8);
                buffer_write(buf_out, buffer_u8, 175);
            }
        break;
        case 7:
            scr = 7;
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 4);
                buffer_write(buf_out, buffer_u8, 1);
            }
        break;
        case 8:
            scr = 9;
            if(cell[scr, 1] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 159);
            }
        break;
        case 9:
            scr = 10;
            if(cell[scr, 0] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 167);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 2);
            }
        break;
        case 11:
            scr = 12;
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 5);
                buffer_write(buf_out, buffer_u8, 1);
            }
        break;
        case 12:
            scr = 13;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 231);
                buffer_write(buf_out, buffer_u8, 223);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 1);
                buffer_write(buf_out, buffer_u8, 1);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 6);
            }
        break;
        case 13:
            scr = 14;
            if(cell[scr, 0] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 1);
                buffer_write(buf_out, buffer_u8, 1);
                buffer_write(buf_out, buffer_u8, 1);
                buffer_write(buf_out, buffer_u8, 1);
                buffer_write(buf_out, buffer_u8, 1);
            }
        break;
        case 15:
            scr = 16;
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 168);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 2);
            }
            if(cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 5);
                buffer_write(buf_out, buffer_u8, 175);
            }
        break;
        case 16:
            scr = 17;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 169);
            }
            if(cell[scr, 1] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 159);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 2);
            }
            if(cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 175);
            }
        break;
        case 17:
            scr = 18;
            if(cell[scr, 0] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 1);
                buffer_write(buf_out, buffer_u8, 6);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 168);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 6);
            }
        break;
        case 18:
            scr = 19;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 169);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 231);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 10);
                buffer_write(buf_out, buffer_u8, 6);
            }
            if(cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 56);
            }
        break;
        case 19:
            scr = 20;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 169);
                buffer_write(buf_out, buffer_u8, 2);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 168);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 182);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 10);
                buffer_write(buf_out, buffer_u8, 2);
            }
        break;
        case 20:
            scr = 21;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 8);
                buffer_write(buf_out, buffer_u8, 182);
                buffer_write(buf_out, buffer_u8, 2);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 6);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 2);
            }
        break;
        case 21:
            scr = 22;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 169);
                buffer_write(buf_out, buffer_u8, 2);
            }
            if(cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 175);
                buffer_write(buf_out, buffer_u8, 200);
                buffer_write(buf_out, buffer_u8, 137);
                buffer_write(buf_out, buffer_u8, 2);
            }
        break;
        case 22:
            scr = 23;
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 4);
                buffer_write(buf_out, buffer_u8, 6);
            }
        break;
        case 23:
            scr = 24;
            if(cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 170);
                buffer_write(buf_out, buffer_u8, 170);
            }
        break;
        case 24:
            scr = 25;
            if(cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 170);
                buffer_write(buf_out, buffer_u8, 170);
            }
        break;
        case 25:
            scr = 26;
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 6);
            }
            if(cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 4);
                buffer_write(buf_out, buffer_u8, 4);
            }
        break;
        case 27:
            scr = 28;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 5);
                buffer_write(buf_out, buffer_u8, 2);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 2);
            }
        break;
        case 28:
            scr = 29;
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 120);
                buffer_write(buf_out, buffer_u8, 120);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 81);
            }
        break;
        case 29:
            scr = 30;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 120);
                buffer_write(buf_out, buffer_u8, 120);
                buffer_write(buf_out, buffer_u8, 120);
                buffer_write(buf_out, buffer_u8, 120);
                buffer_write(buf_out, buffer_u8, 120);
            }
        break;
        case 31:
            scr = 32;
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 5);
                buffer_write(buf_out, buffer_u8, 24);
            }
        break;
        case 32:
            scr = 33;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 219);
            }
            if(cell[scr, 1] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 22);
                buffer_write(buf_out, buffer_u8, 22);
            }
            if(cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 24);
            }
        break;
        case 33:
            scr = 34;
            if(cell[scr, 0] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 234);
                buffer_write(buf_out, buffer_u8, 169);
                
                //correct color palette on outer border
                buffer_seek(buf_out, buffer_seek_start, 99378);
                buffer_seek(buf_orig, buffer_seek_start, 99378);
                temp = buffer_read(buf_orig, buffer_u8);
                temp = temp & ~($01);
                temp = temp & ~($01 << 1);
                buffer_write(buf_out, buffer_u8, temp);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 245);
            }
        break;
        case 34:
            scr = 35;
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 168);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 182);
                buffer_write(buf_out, buffer_u8, 2);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 2);
            }
        break;
        case 35:
            scr = 36;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 169);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 10);
                buffer_write(buf_out, buffer_u8, 2);
            }
            if(cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 6);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 175);
            }
        break;
        case 36:
            scr = 37;
            if(cell[scr, 1] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 233);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 2);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 4);
                buffer_write(buf_out, buffer_u8, 2);
            }
        break;
        case 37:
            scr = 38;
            if(cell[scr, 0] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 234);
            }
            if(cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 184);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 2);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 203);
            }
        break;
        case 39:
            scr = 40;
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 3] <= 0 && cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 3] <= 0 && cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
            }
            else if(cell[scr, 3] > 0 && cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 24);
                buffer_write(buf_out, buffer_u8, 24);
            }
        break;
        case 40:
            scr = 41;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 191);
                buffer_write(buf_out, buffer_u8, 191);
            }
        break;
        case 41:
            scr = 42;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 3] <= 0 && cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 2);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
            }
            else if(cell[scr, 3] <= 0 && cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 2);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 191);
                buffer_write(buf_out, buffer_u8, 191);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
            }
            else if(cell[scr, 3] > 0 && cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 2);
                buffer_write(buf_out, buffer_u8, 196);
                buffer_write(buf_out, buffer_u8, 196);
                buffer_write(buf_out, buffer_u8, 196);
                buffer_write(buf_out, buffer_u8, 196);
                buffer_write(buf_out, buffer_u8, 196);
                buffer_write(buf_out, buffer_u8, 190);
                buffer_write(buf_out, buffer_u8, 190);
                buffer_write(buf_out, buffer_u8, 196);
                buffer_write(buf_out, buffer_u8, 196);
                buffer_write(buf_out, buffer_u8, 196);
                buffer_write(buf_out, buffer_u8, 196);
                buffer_write(buf_out, buffer_u8, 196);
                buffer_write(buf_out, buffer_u8, 196);
            }
        break;
        case 42:
            scr = 43;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 3] <= 0 && cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 1);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
            }
            else if(cell[scr, 3] <= 0 && cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 1);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 191);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
            }
            else if(cell[scr, 3] > 0 && cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 1);
                buffer_write(buf_out, buffer_u8, 189);
                buffer_write(buf_out, buffer_u8, 189);
                buffer_write(buf_out, buffer_u8, 189);
                buffer_write(buf_out, buffer_u8, 189);
                buffer_write(buf_out, buffer_u8, 189);
                buffer_write(buf_out, buffer_u8, 189);
                buffer_write(buf_out, buffer_u8, 190);
                buffer_write(buf_out, buffer_u8, 189);
                buffer_write(buf_out, buffer_u8, 189);
                buffer_write(buf_out, buffer_u8, 189);
                buffer_write(buf_out, buffer_u8, 189);
                buffer_write(buf_out, buffer_u8, 189);
                buffer_write(buf_out, buffer_u8, 189);
            }
        break;
        case 43:
            scr = 44;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 169);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 168);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 2);
            }
        break;
        case 44:
            scr = 45;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 121);
                buffer_write(buf_out, buffer_u8, 121);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 6);
                buffer_write(buf_out, buffer_u8, 158);
                buffer_write(buf_out, buffer_u8, 8);
                buffer_write(buf_out, buffer_u8, 8);
            }
        break;
        case 45:
            scr = 46;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 121);
                buffer_write(buf_out, buffer_u8, 121);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 2);
                buffer_write(buf_out, buffer_u8, 54);
                buffer_write(buf_out, buffer_u8, 54);
                buffer_write(buf_out, buffer_u8, 54);
                buffer_write(buf_out, buffer_u8, 54);
                buffer_write(buf_out, buffer_u8, 54);
                buffer_write(buf_out, buffer_u8, 54);
                buffer_write(buf_out, buffer_u8, 54);
            }
        break;
        case 47:
            scr = 48;
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
        break;
        case 48:
            scr = 49;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
        break;
        case 49:
            scr = 50;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 6);
            }
        break;
        case 50:
            scr = 51;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 159);
                buffer_write(buf_out, buffer_u8, 1);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 2);
            }
        break;
        case 51:
            scr = 52;
            if(cell[scr, 0] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 167);
            }
            if(cell[scr, 1] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 81);
            }
            if(cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 182);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 8);
                buffer_write(buf_out, buffer_u8, 2);
            }
        break;
        case 52:
            scr = 53;
            if(cell[scr, 0] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 81);
                buffer_write(buf_out, buffer_u8, 81);
                buffer_write(buf_out, buffer_u8, 81);
                buffer_write(buf_out, buffer_u8, 81);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 120);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 4);
                buffer_write(buf_out, buffer_u8, 81);
            }
        break;
        case 53:
            scr = 54;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 120);
                buffer_write(buf_out, buffer_u8, 120);
            }
            if(cell[scr, 1] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 9);
                buffer_write(buf_out, buffer_u8, 11);
                buffer_write(buf_out, buffer_u8, 11);
                buffer_write(buf_out, buffer_u8, 11);
                buffer_write(buf_out, buffer_u8, 11);
                buffer_write(buf_out, buffer_u8, 11);
                buffer_write(buf_out, buffer_u8, 11);
                buffer_write(buf_out, buffer_u8, 11);

            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 2);
                buffer_write(buf_out, buffer_u8, 145);
                buffer_write(buf_out, buffer_u8, 151);
            }
        break;
        case 54:
            scr = 55;
            if(cell[scr, 0] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 11);
                buffer_write(buf_out, buffer_u8, 1);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 12);
            }
        break;
        case 55:
            scr = 56;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 12);
                buffer_write(buf_out, buffer_u8, 12);
                buffer_write(buf_out, buffer_u8, 12);
                buffer_write(buf_out, buffer_u8, 12);
                buffer_write(buf_out, buffer_u8, 12);
                buffer_write(buf_out, buffer_u8, 12);
            }
            if(cell[scr, 3] <= 0 && cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 3] <= 0 && cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
            }
            else if(cell[scr, 3] > 0 && cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 118);
            }
        break;
        case 57:
            scr = 58;
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 3] <= 0 && cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 2);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
            }
            else if(cell[scr, 3] <= 0 && cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 2);
                buffer_write(buf_out, buffer_u8, 191);
                buffer_write(buf_out, buffer_u8, 191);
                buffer_write(buf_out, buffer_u8, 191);
                buffer_write(buf_out, buffer_u8, 191);
                buffer_write(buf_out, buffer_u8, 191);
                buffer_write(buf_out, buffer_u8, 191);
                buffer_write(buf_out, buffer_u8, 191);
                buffer_write(buf_out, buffer_u8, 191);
                buffer_write(buf_out, buffer_u8, 191);
                buffer_write(buf_out, buffer_u8, 191);
                buffer_write(buf_out, buffer_u8, 191);
                buffer_write(buf_out, buffer_u8, 191);
                buffer_write(buf_out, buffer_u8, 191);
            }
            else if(cell[scr, 3] > 0 && cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 2);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 189);
                buffer_write(buf_out, buffer_u8, 189);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
            }
        break;
        case 58:
            scr = 59;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 1);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 249);
                buffer_write(buf_out, buffer_u8, 189);
                buffer_write(buf_out, buffer_u8, 189);
            }
        break;
        case 59:
            scr = 61;
            if(cell[scr, 1] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 22);
            }
            if(cell[scr, 3] <= 0 && cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 1);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 38);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 38);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 73);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 73);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 38);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 37);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 3] <= 0 && cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 1);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 38);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 38);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 73);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 73);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 38);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 37);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 3] > 0 && cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 1);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 38);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 38);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 73);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 73);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 38);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 37);
                buffer_write(buf_out, buffer_u8, 118);
            }
        break;
        case 60:
            scr = 62;
            if(cell[scr, 0] > 0 && cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 234);
                buffer_write(buf_out, buffer_u8, 169);
                buffer_write(buf_out, buffer_u8, 8);
                buffer_write(buf_out, buffer_u8, 8);
                buffer_write(buf_out, buffer_u8, 8);
                buffer_write(buf_out, buffer_u8, 8);
                buffer_write(buf_out, buffer_u8, 8);
                buffer_write(buf_out, buffer_u8, 8);
                buffer_write(buf_out, buffer_u8, 8);
            }
            else if(cell[scr, 0] > 0 && cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 234);
                buffer_write(buf_out, buffer_u8, 169);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 44);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 45);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 44);
                buffer_write(buf_out, buffer_u8, 2);
            }
            else if(cell[scr, 0] <= 0 && cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 169);
                buffer_write(buf_out, buffer_u8, 44);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 45);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 44);
                buffer_write(buf_out, buffer_u8, 2);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 121);
                buffer_write(buf_out, buffer_u8, 121);
            }
            if(cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 82);
                buffer_write(buf_out, buffer_u8, 82);
            }
        break;
        case 61:
            scr = 63;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 121);
                buffer_write(buf_out, buffer_u8, 121);
            }
        break;
        case 62:
            scr = 64;
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 2);
            }
        break;
        case 63:
            scr = 65;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 206);
            }
            if(cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 8);
                buffer_write(buf_out, buffer_u8, 24);
            }
        break;
        case 64:
            scr = 68;
            if(cell[scr, 2] <= 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 2);
            }
            else if(cell[scr, 2] > 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 8);
            }
            else if(cell[scr, 2] <= 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 7);
                buffer_write(buf_out, buffer_u8, 7);
            }
        break;
        case 66:
            scr = 70;
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 91);
                buffer_write(buf_out, buffer_u8, 91);

                //get original exits and clear positions
                buffer_seek(buf_orig, buffer_seek_start, 99344 + 70);
                exit_x = buffer_read(buf_orig, buffer_u8) & ~($0F << 4);
                buffer_seek(buf_orig, buffer_seek_start, 99984 + 70);
                exit_y = buffer_read(buf_orig, buffer_u8) & ~($07);
                
                //fix exit location
                //new x exit
                buffer_seek(buf_out, buffer_seek_start, 99344 + 70);
                buffer_write(buf_out, buffer_u8, exit_x | (9 << 4));
        
                //new y exit
                buffer_seek(buf_out, buffer_seek_start, 99984 + 70);
                buffer_write(buf_out, buffer_u8, exit_y | (5));
            }
        break;
        case 67:
            scr = 71;
            if(cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 6);
                buffer_write(buf_out, buffer_u8, 82);
                buffer_write(buf_out, buffer_u8, 72);
                buffer_write(buf_out, buffer_u8, 82);
                buffer_write(buf_out, buffer_u8, 72);
                buffer_write(buf_out, buffer_u8, 82);
            }
        break;
        case 68:
            scr = 72;
            if(cell[scr, 1] > 0){ //TODO: fix compatibility with burn/bomb rando as this one moves a secret
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 43); //moves burn bush secret
                buffer_write(buf_out, buffer_u8, 31);
                buffer_write(buf_out, buffer_u8, 31);
            }
            if(cell[scr, 2] <= 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 2] > 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
            }
            else if(cell[scr, 2] <= 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 118);
            }
        break;
        case 69:
            scr = 73;
            if(cell[scr, 0] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 31);
                buffer_write(buf_out, buffer_u8, 31);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 39);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 25);
                buffer_write(buf_out, buffer_u8, 25);
            }
        break;
        case 70:
            scr = 74;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] <= 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 2);
            }
            else if(cell[scr, 2] <= 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 7);
                buffer_write(buf_out, buffer_u8, 7);
            }
            else if(cell[scr, 2] > 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 24);
                buffer_write(buf_out, buffer_u8, 24);
            }
        break;
        case 71:
            scr = 75;
            if(cell[scr - 1, 1] <= 0){ //takes the screen to the left's right position
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 1] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 22);
                buffer_write(buf_out, buffer_u8, 22);
            }
        break;
        case 72:
            scr = 76;
            if(cell[scr, 0] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 234);
                buffer_write(buf_out, buffer_u8, 169);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 233);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 137);
                buffer_write(buf_out, buffer_u8, 175);
            }
        break;
        case 73:
            scr = 77;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 1);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 5);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 10);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 23);
            }
            if(cell[scr, 2] <= 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 2] <= 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 118);
            }
            else if(cell[scr, 2] > 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 35);
            }
        break;
        case 74:
            scr = 78;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 40);
            }
            if(cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
            }
        break;
        case 76:
            scr = 80;
            if(cell[scr, 1] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 6);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 6);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 2);
                buffer_write(buf_out, buffer_u8, 169);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 44);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 45);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 44);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 200);
                buffer_write(buf_out, buffer_u8, 199);
                buffer_write(buf_out, buffer_u8, 160);
                buffer_write(buf_out, buffer_u8, 6);
            }
        break;
        case 77:
            scr = 81;
            if(cell[scr, 0] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 244);
                buffer_write(buf_out, buffer_u8, 23);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 8);
                buffer_write(buf_out, buffer_u8, 35);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 10);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
            }
        break;
        case 78:
            scr = 82;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 5);
                buffer_write(buf_out, buffer_u8, 48);
                buffer_write(buf_out, buffer_u8, 48);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 9);
                buffer_write(buf_out, buffer_u8, 48);
                buffer_write(buf_out, buffer_u8, 48);
                buffer_write(buf_out, buffer_u8, 48);
                buffer_write(buf_out, buffer_u8, 48);
                buffer_write(buf_out, buffer_u8, 48);
            }
        break;
        case 79:
            scr = 83;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 4);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 23);
            }
        break;
        case 80:
            scr = 84;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 121);
                buffer_write(buf_out, buffer_u8, 121);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 9);
                buffer_write(buf_out, buffer_u8, 58);
                buffer_write(buf_out, buffer_u8, 72);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 72);
            }
        break;
        case 81:
            scr = 85;
            if(cell[scr - 1, 1] <= 0){ //takes the screen to the left's right position
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 121);
                buffer_write(buf_out, buffer_u8, 121);
            }
            if(cell[scr + 1, 0] <= 0){ //takes the screen to the right's left position
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 121);
                buffer_write(buf_out, buffer_u8, 121);
            }
        break;
        case 82:
            scr = 86;
            if(cell[scr, 0] <= 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 121);
                buffer_write(buf_out, buffer_u8, 121);
                buffer_write(buf_out, buffer_u8, 121);
            }
            else if(cell[scr, 0] <= 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 121);
                buffer_write(buf_out, buffer_u8, 82);
                buffer_write(buf_out, buffer_u8, 82);
            }
            else if(cell[scr, 0] > 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 55);
                buffer_write(buf_out, buffer_u8, 82);
                buffer_write(buf_out, buffer_u8, 82);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
            }
        break;
        case 83:
            scr = 87;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 6);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 8);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 10);
                buffer_write(buf_out, buffer_u8, 35);
            }
            if(cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 2);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 38);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 118);
            }
        break;
        case 84:
            scr = 88;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] <= 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 2] <= 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 118);
            }
            else if(cell[scr, 2] > 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 5);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 10);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 23);
            }
        break;
        case 85:
            scr = 89;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 39);
                buffer_write(buf_out, buffer_u8, 23);
            }
            if(cell[scr, 2] <= 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 22);
                buffer_write(buf_out, buffer_u8, 22);
            }
            else if(cell[scr, 2] <= 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 26);
                buffer_write(buf_out, buffer_u8, 26);
            }
            else if(cell[scr, 2] > 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 25);
                buffer_write(buf_out, buffer_u8, 25);
            }
        break;
        case 86:
            scr = 90;
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] <= 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 37);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 37);
                buffer_write(buf_out, buffer_u8, 37);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 37);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 2] > 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 37);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 37);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 37);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 2] > 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 24);
                buffer_write(buf_out, buffer_u8, 24);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 31);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 118);
            }
        break;
        case 87:
            scr = 91;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] <= 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 1);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 9);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 2] > 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 1);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 9);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
            }
            else if(cell[scr, 2] <= 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 1);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 9);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 23);
            }
        break;
        case 88:
            scr = 92;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 4);
                buffer_write(buf_out, buffer_u8, 41);
            }
            if(cell[scr, 2] <= 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 2] > 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 35);
            }
            else if(cell[scr, 2] > 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 24);
            }
        break;
        case 89:
            scr = 93;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] <= 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 22);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 22);
            }
            else if(cell[scr, 2] > 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 25);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 25);
            }
            else if(cell[scr, 2] <= 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 26);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 26);
            }
        break;
        case 91:
            scr = 96;
            if(cell[scr, 2] <= 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 2);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 31);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 39);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 38);
                buffer_write(buf_out, buffer_u8, 38);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 39);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 31);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 2] <= 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 2);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 31);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 42);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 38);
                buffer_write(buf_out, buffer_u8, 38);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 42);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 31);
                buffer_write(buf_out, buffer_u8, 118);
            }
            else if(cell[scr, 2] > 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 2);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 24);
            }
        break;
        case 93:
            scr = 98;
            //overhaul this screen a bit since pathing the vanilla screen is a pain
            buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 8);
            buffer_write(buf_out, buffer_u8, 43);
            buffer_write(buf_out, buffer_u8, 35);
            buffer_write(buf_out, buffer_u8, 35);
            buffer_write(buf_out, buffer_u8, 35);
            buffer_write(buf_out, buffer_u8, 35);
            buffer_write(buf_out, buffer_u8, 35);
            
            //now mod it
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] <= 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 5);
                buffer_write(buf_out, buffer_u8, 22);
                buffer_write(buf_out, buffer_u8, 40);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 43);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 42);
                buffer_write(buf_out, buffer_u8, 42);
                buffer_write(buf_out, buffer_u8, 42);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 2] <= 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 5);
                buffer_write(buf_out, buffer_u8, 22);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 43);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 31);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 31);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 2] > 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 5);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 31);
                buffer_write(buf_out, buffer_u8, 43);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 109);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 109);
                buffer_write(buf_out, buffer_u8, 35);
            }
        break;
        case 94:
            scr = 99;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] <= 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 4);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 2] <= 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 4);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 118);
            }
            else if(cell[scr, 2] > 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 4);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 35);
            }
        break;
        case 95:
            scr = 100;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 158);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 9);
                buffer_write(buf_out, buffer_u8, 157);
                buffer_write(buf_out, buffer_u8, 158);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 158);
            }
        break;
        case 96:
            scr = 101;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 8);
                buffer_write(buf_out, buffer_u8, 8);
            }
        break;
        case 97:
            scr = 102;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 1);
                buffer_write(buf_out, buffer_u8, 8);
                buffer_write(buf_out, buffer_u8, 8);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 2);
            }
        break;
        case 98:
            scr = 103;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 2);
                buffer_write(buf_out, buffer_u8, 8);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 4);
                buffer_write(buf_out, buffer_u8, 8);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 9);
                buffer_write(buf_out, buffer_u8, 44);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 45);
                buffer_write(buf_out, buffer_u8, 8);
                buffer_write(buf_out, buffer_u8, 44);
                buffer_write(buf_out, buffer_u8, 8);
            }
            if(cell[scr, 3] <= 0){ //TODO: Fix incompatibility with burn/bush rando
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 203);
                buffer_write(buf_out, buffer_u8, 2);
            }
        break;
        case 99:
            scr = 104;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] <= 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 5);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 10);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 2] > 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 5);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 10);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 35);
            }
            else if(cell[scr, 2] <= 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 5);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 10);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 118);
            }
        break;
        case 100:
            scr = 105;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
            }
            if(cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 82);
            }
        break;
        case 101:
            scr = 106;
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 31);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 23);
            }
            if(cell[scr, 1] <= 0 && cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 40);
            }
        break;
        case 102:
            scr = 107;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 1);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 9);
                buffer_write(buf_out, buffer_u8, 23);
            }
            if(cell[scr, 2] <= 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 2] > 0 && cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 35);
                buffer_write(buf_out, buffer_u8, 23);
            }
            else if(cell[scr, 2] <= 0 && cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 118);
            }
        break;
        case 103:
            //overhaul this screen because pathing the vanilla screen is a nightmare
            scr = 108;
            buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
            buffer_write(buf_out, buffer_u8, 22);
            buffer_write(buf_out, buffer_u8, 22);
            buffer_write(buf_out, buffer_u8, 40);
            buffer_write(buf_out, buffer_u8, 23);
            buffer_write(buf_out, buffer_u8, 35);
            buffer_write(buf_out, buffer_u8, 43);
            buffer_write(buf_out, buffer_u8, 23);
            buffer_write(buf_out, buffer_u8, 31);
            buffer_write(buf_out, buffer_u8, 23);
            buffer_write(buf_out, buffer_u8, 31);
            buffer_write(buf_out, buffer_u8, 23);
            buffer_write(buf_out, buffer_u8, 31);
            buffer_write(buf_out, buffer_u8, 35);
            buffer_write(buf_out, buffer_u8, 23);
            buffer_write(buf_out, buffer_u8, 48);
            buffer_write(buf_out, buffer_u8, 48);
            
            //now do the modding
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 4);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 23);
            }
        break;
        case 104:
            //overhaul this screen because pathing the vanilla screen is a nightmare
            scr = 109;
            buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
            buffer_write(buf_out, buffer_u8, 42);
            buffer_write(buf_out, buffer_u8, 42);
            buffer_write(buf_out, buffer_u8, 23);
            buffer_write(buf_out, buffer_u8, 109);
            buffer_write(buf_out, buffer_u8, 23);
            buffer_write(buf_out, buffer_u8, 31);
            buffer_write(buf_out, buffer_u8, 23);
            buffer_write(buf_out, buffer_u8, 38);
            buffer_write(buf_out, buffer_u8, 38);
            buffer_write(buf_out, buffer_u8, 23);
            buffer_write(buf_out, buffer_u8, 43);
            buffer_write(buf_out, buffer_u8, 23);
            buffer_write(buf_out, buffer_u8, 109);
            buffer_write(buf_out, buffer_u8, 23);
            buffer_write(buf_out, buffer_u8, 22);
            buffer_write(buf_out, buffer_u8, 22);
            
            //now do the modding
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 42);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 42);
            }
        break;
        case 105:
            scr = 110;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 40);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 3] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 6);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 118);
                buffer_write(buf_out, buffer_u8, 118);
            }
        break;
        case 106:
            scr = 111;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 169);
            }
            if(cell[scr, 3] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 4);
                buffer_write(buf_out, buffer_u8, 158);
                buffer_write(buf_out, buffer_u8, 8);
                buffer_write(buf_out, buffer_u8, 8);
                buffer_write(buf_out, buffer_u8, 8);
                buffer_write(buf_out, buffer_u8, 8);
            }
        break;
        case 107:
            scr = 112;
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 168);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 158);
                buffer_write(buf_out, buffer_u8, 8);
            }
        break;
        case 108:
            scr = 113;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 169);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 10);
                buffer_write(buf_out, buffer_u8, 157);
                buffer_write(buf_out, buffer_u8, 158);
            }
        break;
        case 109:
            //overhaul this screen because pathing the vanilla screen is a nightmare
            scr = 114;
            buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
            buffer_write(buf_out, buffer_u8, 22);
            buffer_write(buf_out, buffer_u8, 22);
            buffer_write(buf_out, buffer_u8, 40);
            buffer_write(buf_out, buffer_u8, 31);
            buffer_write(buf_out, buffer_u8, 23);
            buffer_write(buf_out, buffer_u8, 31);
            buffer_write(buf_out, buffer_u8, 35);
            buffer_write(buf_out, buffer_u8, 35);
            buffer_write(buf_out, buffer_u8, 38);
            buffer_write(buf_out, buffer_u8, 23);
            buffer_write(buf_out, buffer_u8, 31);
            buffer_write(buf_out, buffer_u8, 23);
            buffer_write(buf_out, buffer_u8, 38);
            buffer_write(buf_out, buffer_u8, 23);
            buffer_write(buf_out, buffer_u8, 48);
            buffer_write(buf_out, buffer_u8, 48);
            
            //now do the modding
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 6);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
            }
        break;
        case 110:
            scr = 115;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 21);
                buffer_write(buf_out, buffer_u8, 40);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 39);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 13);
                buffer_write(buf_out, buffer_u8, 23);
            }
        break;
        case 112:
            //add a bridge to the river so pathing is easier
            scr = 117;
            buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 5);
            buffer_write(buf_out, buffer_u8, 11);
            buffer_write(buf_out, buffer_u8, 11);
            
            //now do the modding
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 168);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 46);
                buffer_write(buf_out, buffer_u8, 155);
            }
        break;
        case 113:
            scr = 118;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 169);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 168);
            }
        break;
        case 114:
            scr = 119;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 0);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 6);
                buffer_write(buf_out, buffer_u8, 2);
                buffer_write(buf_out, buffer_u8, 200);
                buffer_write(buf_out, buffer_u8, 199);
            }
        break;
        case 115:
            scr = 120;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 169);
            }
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 15);
                buffer_write(buf_out, buffer_u8, 21);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 3);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 5);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 7);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 10);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 12);
                buffer_write(buf_out, buffer_u8, 23);
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 23);
            }
        break;
        case 116:
            scr = 121;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 0);
                buffer_write(buf_out, buffer_u8, 167);
                buffer_write(buf_out, buffer_u8, 234);
                buffer_write(buf_out, buffer_u8, 169);
                buffer_write(buf_out, buffer_u8, 200);
                buffer_write(buf_out, buffer_u8, 137);
            }
            if(cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 10);
                buffer_write(buf_out, buffer_u8, 192);
                buffer_write(buf_out, buffer_u8, 8);
            }
        break;
        case 117:
            scr = 123;
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 11);
                buffer_write(buf_out, buffer_u8, 71);
                buffer_write(buf_out, buffer_u8, 71);
                buffer_write(buf_out, buffer_u8, 71);
            }
        break;
        case 119:
            scr = 126;
            if(cell[scr, 1] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 14);
                buffer_write(buf_out, buffer_u8, 120);
                buffer_write(buf_out, buffer_u8, 120);
            }
            if(cell[scr, 2] > 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 4);
                buffer_write(buf_out, buffer_u8, 81);
                buffer_write(buf_out, buffer_u8, 151);
                buffer_write(buf_out, buffer_u8, 88);
                buffer_write(buf_out, buffer_u8, 88);
                buffer_write(buf_out, buffer_u8, 88);
                buffer_write(buf_out, buffer_u8, 88);
            }
        break;
        case 120:
            scr = 127;
            if(cell[scr, 0] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 0);
                buffer_write(buf_out, buffer_u8, 120);
                buffer_write(buf_out, buffer_u8, 120);
                buffer_write(buf_out, buffer_u8, 151);
                buffer_write(buf_out, buffer_u8, 145);
            }
            if(cell[scr, 2] <= 0){
                buffer_seek(buf_out, buffer_seek_start, 87080 + (16 * i) + 5);
                buffer_write(buf_out, buffer_u8, 145);
                buffer_write(buf_out, buffer_u8, 75);
                buffer_write(buf_out, buffer_u8, 75);
                buffer_write(buf_out, buffer_u8, 151);
            }
    }
}
